/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.TimeValue;
import org.assertj.db.type.ValueType;

public class Values {
    private Values() {
    }

    public static boolean areEqual(Object value, Object expected) {
        ValueType valueType = ValueType.getType(value);
        switch (valueType) {
            case BOOLEAN: {
                if (!(expected instanceof Boolean)) break;
                return Values.areEqual(value, (Boolean)expected);
            }
            case NUMBER: {
                if (expected instanceof Number) {
                    return Values.areEqual(value, (Number)expected);
                }
                if (!(expected instanceof String)) break;
                return Values.areEqual(value, (String)expected);
            }
            case BYTES: {
                if (!(expected instanceof byte[])) break;
                return Values.areEqual(value, (byte[])expected);
            }
            case TEXT: {
                if (!(expected instanceof String)) break;
                return Values.areEqual(value, (String)expected);
            }
            case DATE: {
                if (expected instanceof DateValue) {
                    return Values.areEqual(value, (DateValue)expected);
                }
                if (expected instanceof String) {
                    return Values.areEqual(value, (String)expected);
                }
                if (!(expected instanceof Date)) break;
                return Values.areEqual(value, DateValue.from((Date)expected));
            }
            case TIME: {
                if (expected instanceof TimeValue) {
                    return Values.areEqual(value, (TimeValue)expected);
                }
                if (expected instanceof String) {
                    return Values.areEqual(value, (String)expected);
                }
                if (!(expected instanceof Time)) break;
                return Values.areEqual(value, TimeValue.from((Time)expected));
            }
            case DATE_TIME: {
                if (expected instanceof DateTimeValue) {
                    return Values.areEqual(value, (DateTimeValue)expected);
                }
                if (expected instanceof DateValue) {
                    return Values.areEqual(value, (DateValue)expected);
                }
                if (expected instanceof String) {
                    return Values.areEqual(value, (String)expected);
                }
                if (!(expected instanceof Timestamp)) break;
                return Values.areEqual(value, DateTimeValue.from((Timestamp)expected));
            }
            default: {
                if (expected != null || value != null) break;
                return true;
            }
        }
        return false;
    }

    public static boolean areEqual(Object value, Boolean expected) {
        if (expected == null) {
            return value == null;
        }
        return expected.equals(value);
    }

    public static boolean areEqual(Object value, Number expected) {
        if (expected == null) {
            return value == null;
        }
        if (expected instanceof BigInteger) {
            BigInteger bi;
            if (value instanceof BigInteger) {
                bi = (BigInteger)value;
            } else {
                try {
                    bi = new BigInteger("" + value);
                }
                catch (NumberFormatException e) {
                    throw new AssertJDBException("Expected <%s> can not be compared to a BigInteger (<%s>)", expected, value);
                }
            }
            if (bi.compareTo((BigInteger)expected) == 0) {
                return true;
            }
        } else if (expected instanceof BigDecimal) {
            BigDecimal bd;
            if (value instanceof BigDecimal) {
                bd = (BigDecimal)value;
            } else {
                try {
                    bd = new BigDecimal("" + value);
                }
                catch (NumberFormatException e) {
                    throw new AssertJDBException("Expected <%s> can not be compared to a BigDecimal (<%s>)", expected, value);
                }
            }
            if (bd.compareTo((BigDecimal)expected) == 0) {
                return true;
            }
        } else {
            Long actualValue = null;
            if (value instanceof Float) {
                if (((Float)value).floatValue() == expected.floatValue()) {
                    return true;
                }
            } else if (value instanceof Double) {
                if (((Double)value).doubleValue() == expected.doubleValue()) {
                    return true;
                }
            } else if (value instanceof BigInteger) {
                BigInteger bi = new BigInteger("" + expected);
                if (((BigInteger)value).compareTo(bi) == 0) {
                    return true;
                }
            } else if (value instanceof BigDecimal) {
                BigDecimal bd = new BigDecimal("" + expected);
                if (((BigDecimal)value).compareTo(bd) == 0) {
                    return true;
                }
            } else if (value instanceof Byte) {
                actualValue = ((Byte)value).longValue();
            } else if (value instanceof Short) {
                actualValue = ((Short)value).longValue();
            } else if (value instanceof Integer) {
                actualValue = ((Integer)value).longValue();
            } else if (value instanceof Long) {
                actualValue = (Long)value;
            }
            if (actualValue != null && (expected instanceof Float ? (float)actualValue.longValue() == expected.floatValue() : (expected instanceof Double ? (double)actualValue.longValue() == expected.doubleValue() : actualValue.longValue() == expected.longValue()))) {
                return true;
            }
        }
        return false;
    }

    public static boolean areEqual(Object value, byte[] expected) {
        if (expected == null) {
            return value == null;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            if (bytes.length != expected.length) {
                return false;
            }
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] == expected[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean areEqual(Date date, String expected) {
        try {
            DateTimeValue dateTimeValue = DateTimeValue.of(DateValue.from(date));
            DateTimeValue expectedDateTimeValue = DateTimeValue.parse(expected);
            if (dateTimeValue.equals(expectedDateTimeValue)) {
                return true;
            }
        }
        catch (ParseException e) {
            throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, date);
        }
        return false;
    }

    private static boolean areEqual(Time time, String expected) {
        try {
            TimeValue timeValue = TimeValue.from(time);
            TimeValue expectedTimeValue = TimeValue.parse(expected);
            if (timeValue.equals(expectedTimeValue)) {
                return true;
            }
        }
        catch (ParseException e) {
            throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, time);
        }
        return false;
    }

    private static boolean areEqual(Timestamp timestamp, String expected) {
        try {
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            DateTimeValue expectedDateTimeValue = DateTimeValue.parse(expected);
            if (dateTimeValue.equals(expectedDateTimeValue)) {
                return true;
            }
        }
        catch (ParseException e) {
            throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, timestamp);
        }
        return false;
    }

    private static boolean areEqual(Number number, String expected) {
        try {
            if (number instanceof Float) {
                if (number.floatValue() == Float.parseFloat(expected)) {
                    return true;
                }
            } else if (number instanceof Double) {
                if (number.doubleValue() == Double.parseDouble(expected)) {
                    return true;
                }
            } else if (number instanceof BigInteger) {
                BigInteger bi = new BigInteger("" + expected);
                if (((BigInteger)number).compareTo(bi) == 0) {
                    return true;
                }
            } else if (number instanceof BigDecimal) {
                BigDecimal bd = new BigDecimal("" + expected);
                if (((BigDecimal)number).compareTo(bd) == 0) {
                    return true;
                }
            } else {
                Long actual = null;
                if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
                    actual = number.longValue();
                } else if (number instanceof Long) {
                    actual = (Long)number;
                }
                if (actual != null && actual == Long.parseLong(expected)) {
                    return true;
                }
            }
        }
        catch (NumberFormatException e) {
            throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, number);
        }
        return false;
    }

    public static boolean areEqual(Object value, String expected) {
        if (expected == null) {
            return value == null;
        }
        if (value instanceof Number) {
            return Values.areEqual((Number)value, expected);
        }
        if (value instanceof Date) {
            return Values.areEqual((Date)value, expected);
        }
        if (value instanceof Time) {
            return Values.areEqual((Time)value, expected);
        }
        if (value instanceof Timestamp) {
            return Values.areEqual((Timestamp)value, expected);
        }
        return expected.equals(value);
    }

    public static boolean areEqual(Object value, DateValue expected) {
        if (expected == null) {
            return value == null;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            DateValue dateValue = DateValue.from(date);
            return dateValue.equals(expected);
        }
        if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            return dateTimeValue.equals(DateTimeValue.of(expected));
        }
        return false;
    }

    public static boolean areEqual(Object value, TimeValue expected) {
        if (expected == null) {
            return value == null;
        }
        if (value instanceof Time) {
            Time time = (Time)value;
            TimeValue timeValue = TimeValue.from(time);
            return timeValue.equals(expected);
        }
        return false;
    }

    public static boolean areEqual(Object value, DateTimeValue expected) {
        if (expected == null) {
            return value == null;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            DateTimeValue dateTimeValue = DateTimeValue.of(DateValue.from(date));
            return dateTimeValue.equals(expected);
        }
        if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            return dateTimeValue.equals(expected);
        }
        return false;
    }

    public static int compare(Object value, Number expected) {
        if (expected instanceof BigInteger) {
            BigInteger bi;
            if (value instanceof BigInteger) {
                bi = (BigInteger)value;
            } else {
                try {
                    bi = new BigInteger("" + value);
                }
                catch (NumberFormatException e) {
                    throw new AssertJDBException("Expected <%s> can not be compared to a BigInteger (<%s>)", expected, value);
                }
            }
            return bi.compareTo((BigInteger)expected);
        }
        if (expected instanceof BigDecimal) {
            BigDecimal bd;
            if (value instanceof BigDecimal) {
                bd = (BigDecimal)value;
            } else {
                try {
                    bd = new BigDecimal("" + value);
                }
                catch (NumberFormatException e) {
                    throw new AssertJDBException("Expected <%s> can not be compared to a BigDecimal (<%s>)", expected, value);
                }
            }
            return bd.compareTo((BigDecimal)expected);
        }
        Long actualValue = null;
        if (value instanceof Float) {
            float expectedF;
            float f = ((Float)value).floatValue();
            if (f > (expectedF = expected.floatValue())) {
                return 1;
            }
            if (f < expectedF) {
                return -1;
            }
            return 0;
        }
        if (value instanceof Double) {
            double expectedD;
            double d = (Double)value;
            if (d > (expectedD = expected.doubleValue())) {
                return 1;
            }
            if (d < expectedD) {
                return -1;
            }
            return 0;
        }
        if (value instanceof BigInteger) {
            BigInteger bi = new BigInteger("" + expected);
            return ((BigInteger)value).compareTo(bi);
        }
        if (value instanceof BigDecimal) {
            BigDecimal bd = new BigDecimal("" + expected);
            return ((BigDecimal)value).compareTo(bd);
        }
        if (value instanceof Byte) {
            actualValue = ((Byte)value).longValue();
        } else if (value instanceof Short) {
            actualValue = ((Short)value).longValue();
        } else if (value instanceof Integer) {
            actualValue = ((Integer)value).longValue();
        } else if (value instanceof Long) {
            actualValue = (Long)value;
        }
        if (actualValue != null) {
            if (expected instanceof Float) {
                float expectedF = expected.floatValue();
                if ((float)actualValue.longValue() > expectedF) {
                    return 1;
                }
                if ((float)actualValue.longValue() < expectedF) {
                    return -1;
                }
                return 0;
            }
            if (expected instanceof Double) {
                double expectedD = expected.doubleValue();
                if ((double)actualValue.longValue() > expectedD) {
                    return 1;
                }
                if ((double)actualValue.longValue() < expectedD) {
                    return -1;
                }
                return 0;
            }
            double expectedL = expected.longValue();
            if ((double)actualValue.longValue() > expectedL) {
                return 1;
            }
            if ((double)actualValue.longValue() < expectedL) {
                return -1;
            }
            return 0;
        }
        throw new AssertJDBException("Expected <%s> can not be compared to a Number (<%s>)", expected, value);
    }

    public static Object[] getRepresentationsFromValuesInFrontOfExpected(Object[] values, Object[] expected) {
        Object[] representationsValues = new Object[values.length];
        int i = 0;
        for (Object obj : values) {
            representationsValues[i] = i > expected.length ? obj : Values.getRepresentationFromValueInFrontOfExpected(obj, expected[i]);
            ++i;
        }
        return representationsValues;
    }

    public static Object getRepresentationFromValueInFrontOfExpected(Object value, Object expected) {
        switch (ValueType.getType(value)) {
            case DATE: {
                if (expected instanceof DateValue) {
                    return DateValue.from((Date)value);
                }
                if (expected instanceof DateTimeValue) {
                    return DateTimeValue.of(DateValue.from((Date)value));
                }
                if (expected instanceof String) {
                    if (((String)expected).contains("T")) {
                        return DateTimeValue.of(DateValue.from((Date)value)).toString();
                    }
                    return DateValue.from((Date)value).toString();
                }
                return value;
            }
            case TIME: {
                if (expected instanceof String) {
                    return TimeValue.from((Time)value).toString();
                }
                return TimeValue.from((Time)value);
            }
            case DATE_TIME: {
                if (expected instanceof String) {
                    return DateTimeValue.from((Timestamp)value).toString();
                }
                return DateTimeValue.from((Timestamp)value);
            }
            case NUMBER: {
                if (expected instanceof String) {
                    return value.toString();
                }
                return value;
            }
        }
        return value;
    }
}

