/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldBeChangeType;
import org.assertj.db.type.Change;
import org.assertj.db.type.ChangeType;

public class AssertionsOnChangeType {
    private static final Failures failures = Failures.instance();

    private AssertionsOnChangeType() {
    }

    public static <A extends AbstractAssert> A isOfType(A assertion, WritableAssertionInfo info, Change change, ChangeType expected) {
        ChangeType type = change.getChangeType();
        if (type != expected) {
            throw failures.failure((AssertionInfo)info, ShouldBeChangeType.shouldBeChangeType(expected, type));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A isCreation(A assertion, WritableAssertionInfo info, Change change) {
        return AssertionsOnChangeType.isOfType(assertion, info, change, ChangeType.CREATION);
    }

    public static <A extends AbstractAssert> A isModification(A assertion, WritableAssertionInfo info, Change change) {
        return AssertionsOnChangeType.isOfType(assertion, info, change, ChangeType.MODIFICATION);
    }

    public static <A extends AbstractAssert> A isDeletion(A assertion, WritableAssertionInfo info, Change change) {
        return AssertionsOnChangeType.isOfType(assertion, info, change, ChangeType.DELETION);
    }
}

