/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldBeValueClassWithEndPoint;
import org.assertj.db.error.ShouldBeValueClassWithStartPoint;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.Value;

public class AssertionsOnColumnOfChangeClass {
    private static final Failures failures = Failures.instance();

    private AssertionsOnColumnOfChangeClass() {
    }

    public static <A extends AbstractAssert> A isOfClass(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, Class<?> expected, boolean lenient) {
        if (expected == null) {
            throw new AssertJDBException("Class of the column is null", new Object[0]);
        }
        if (!(valueAtStartPoint.getValue() != null && expected.isAssignableFrom(valueAtStartPoint.getValue().getClass()) || lenient && valueAtStartPoint.getValue() == null)) {
            throw failures.failure((AssertionInfo)info, ShouldBeValueClassWithStartPoint.shouldBeValueClassWithStartPoint(valueAtStartPoint, expected));
        }
        if (!(valueAtEndPoint.getValue() != null && expected.isAssignableFrom(valueAtEndPoint.getValue().getClass()) || lenient && valueAtEndPoint.getValue() == null)) {
            throw failures.failure((AssertionInfo)info, ShouldBeValueClassWithEndPoint.shouldBeValueClassWithEndPoint(valueAtEndPoint, expected));
        }
        return assertion;
    }
}

