/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldHaveModifications;
import org.assertj.db.error.ShouldHaveNumberOfModifications;
import org.assertj.db.error.ShouldHaveNumberOfModificationsGreater;
import org.assertj.db.error.ShouldHaveNumberOfModificationsGreaterOrEqual;
import org.assertj.db.error.ShouldHaveNumberOfModificationsLess;
import org.assertj.db.error.ShouldHaveNumberOfModificationsLessOrEqual;
import org.assertj.db.type.Change;
import org.assertj.db.type.lettercase.LetterCase;
import org.assertj.db.util.Changes;

public class AssertionsOnModifiedColumns {
    private static final Failures failures = Failures.instance();

    private AssertionsOnModifiedColumns() {
    }

    public static <A extends AbstractAssert> A hasNumberOfModifiedColumns(A assertion, WritableAssertionInfo info, Change change, int number) {
        Integer[] indexesOfModifiedColumns = Changes.getIndexesOfModifiedColumns(change);
        if (number != indexesOfModifiedColumns.length) {
            throw failures.failure((AssertionInfo)info, ShouldHaveNumberOfModifications.shouldHaveNumberOfModifications(indexesOfModifiedColumns.length, number));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasNumberOfModifiedColumnsGreaterThan(A assertion, WritableAssertionInfo info, Change change, int number) {
        Integer[] indexesOfModifiedColumns = Changes.getIndexesOfModifiedColumns(change);
        if (number >= indexesOfModifiedColumns.length) {
            throw failures.failure((AssertionInfo)info, ShouldHaveNumberOfModificationsGreater.shouldHaveNumberOfModificationsGreater(indexesOfModifiedColumns.length, number));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasNumberOfModifiedColumnsLessThan(A assertion, WritableAssertionInfo info, Change change, int number) {
        Integer[] indexesOfModifiedColumns = Changes.getIndexesOfModifiedColumns(change);
        if (number <= indexesOfModifiedColumns.length) {
            throw failures.failure((AssertionInfo)info, ShouldHaveNumberOfModificationsLess.shouldHaveNumberOfModificationsLess(indexesOfModifiedColumns.length, number));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasNumberOfModifiedColumnsGreaterThanOrEqualTo(A assertion, WritableAssertionInfo info, Change change, int number) {
        Integer[] indexesOfModifiedColumns = Changes.getIndexesOfModifiedColumns(change);
        if (number > indexesOfModifiedColumns.length) {
            throw failures.failure((AssertionInfo)info, ShouldHaveNumberOfModificationsGreaterOrEqual.shouldHaveNumberOfModificationsGreaterOrEqual(indexesOfModifiedColumns.length, number));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasNumberOfModifiedColumnsLessThanOrEqualTo(A assertion, WritableAssertionInfo info, Change change, int number) {
        Integer[] indexesOfModifiedColumns = Changes.getIndexesOfModifiedColumns(change);
        if (number < indexesOfModifiedColumns.length) {
            throw failures.failure((AssertionInfo)info, ShouldHaveNumberOfModificationsLessOrEqual.shouldHaveNumberOfModificationsLessOrEqual(indexesOfModifiedColumns.length, number));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasModifiedColumns(A assertion, WritableAssertionInfo info, Change change, Integer ... indexes) {
        if (indexes == null) {
            throw new NullPointerException("Columns indexes must be not null");
        }
        Integer[] indexesOfModifiedColumns = Changes.getIndexesOfModifiedColumns(change);
        List<Integer> indexesOfModifiedList = Arrays.asList(indexesOfModifiedColumns);
        Collections.sort(indexesOfModifiedList);
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        for (Integer index : indexes) {
            if (index == null) {
                throw new NullPointerException("Column index must be not null");
            }
            indexesList.add(index);
        }
        Collections.sort(indexesList);
        if (!indexesList.equals(indexesOfModifiedList)) {
            throw failures.failure((AssertionInfo)info, ShouldHaveModifications.shouldHaveModifications(indexesOfModifiedColumns, indexes));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasModifiedColumns(A assertion, WritableAssertionInfo info, Change change, LetterCase columnLetterCase, String ... names) {
        if (names == null) {
            throw new NullPointerException("Columns names must be not null");
        }
        ArrayList<String> namesList = new ArrayList<String>();
        for (String name : names) {
            if (name == null) {
                throw new NullPointerException("Column name must be not null");
            }
            namesList.add(name);
        }
        Collections.sort(namesList, columnLetterCase);
        Integer[] indexesOfModifiedColumns = Changes.getIndexesOfModifiedColumns(change);
        String[] namesOfModifiedColumns = new String[indexesOfModifiedColumns.length];
        List<String> columnsNameList = change.getColumnsNameList();
        for (int i = 0; i < indexesOfModifiedColumns.length; ++i) {
            namesOfModifiedColumns[i] = columnsNameList.get(indexesOfModifiedColumns[i]);
        }
        List<String> namesOfModifiedList = Arrays.asList(namesOfModifiedColumns);
        Collections.sort(namesOfModifiedList, columnLetterCase);
        Iterator namesIterator = namesList.iterator();
        Iterator<String> namesOfModifiedIterator = namesOfModifiedList.iterator();
        while (namesIterator.hasNext() && namesOfModifiedIterator.hasNext()) {
            String nameOfModified;
            String name = (String)namesIterator.next();
            if (columnLetterCase.isEqual(name, nameOfModified = namesOfModifiedIterator.next())) continue;
            throw failures.failure((AssertionInfo)info, ShouldHaveModifications.shouldHaveModifications(namesOfModifiedColumns, names));
        }
        if (namesIterator.hasNext() || namesOfModifiedIterator.hasNext()) {
            throw failures.failure((AssertionInfo)info, ShouldHaveModifications.shouldHaveModifications(namesOfModifiedColumns, names));
        }
        return assertion;
    }
}

