/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldHaveChangesSize;
import org.assertj.db.error.ShouldHaveChangesSizeGreater;
import org.assertj.db.error.ShouldHaveChangesSizeGreaterOrEqual;
import org.assertj.db.error.ShouldHaveChangesSizeLess;
import org.assertj.db.error.ShouldHaveChangesSizeLessOrEqual;
import org.assertj.db.type.Change;
import org.assertj.db.type.Changes;

public class AssertionsOnNumberOfChanges {
    private static final Failures failures = Failures.instance();

    private AssertionsOnNumberOfChanges() {
    }

    public static <A extends AbstractAssert> A hasNumberOfChanges(A assertion, WritableAssertionInfo info, Changes changes, int expected) {
        List<Change> changesList = changes.getChangesList();
        int size = changesList.size();
        if (size != expected) {
            throw failures.failure((AssertionInfo)info, ShouldHaveChangesSize.shouldHaveChangesSize(size, expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasNumberOfChangesGreaterThan(A assertion, WritableAssertionInfo info, Changes changes, int expected) {
        List<Change> changesList = changes.getChangesList();
        int size = changesList.size();
        if (size <= expected) {
            throw failures.failure((AssertionInfo)info, ShouldHaveChangesSizeGreater.shouldHaveChangesSizeGreater(size, expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasNumberOfChangesLessThan(A assertion, WritableAssertionInfo info, Changes changes, int expected) {
        List<Change> changesList = changes.getChangesList();
        int size = changesList.size();
        if (size >= expected) {
            throw failures.failure((AssertionInfo)info, ShouldHaveChangesSizeLess.shouldHaveChangesSizeLess(size, expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasNumberOfChangesGreaterThanOrEqualTo(A assertion, WritableAssertionInfo info, Changes changes, int expected) {
        List<Change> changesList = changes.getChangesList();
        int size = changesList.size();
        if (size < expected) {
            throw failures.failure((AssertionInfo)info, ShouldHaveChangesSizeGreaterOrEqual.shouldHaveChangesSizeGreaterOrEqual(size, expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasNumberOfChangesLessThanOrEqualTo(A assertion, WritableAssertionInfo info, Changes changes, int expected) {
        List<Change> changesList = changes.getChangesList();
        int size = changesList.size();
        if (size > expected) {
            throw failures.failure((AssertionInfo)info, ShouldHaveChangesSizeLessOrEqual.shouldHaveChangesSizeLessOrEqual(size, expected));
        }
        return assertion;
    }
}

