/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.error;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.db.type.Value;
import org.assertj.db.type.ValueType;

public class ShouldBeValueType
extends BasicErrorMessageFactory {
    private static final String EXPECTED_MESSAGE = "%nExpecting:%n  <%s>%nto be of type%n  <%s>%nbut was of type%n  <%s>";
    private static final String EXPECTED_MESSAGE_WITH_INDEX = "%nExpecting that the value at index %s:%n  <%s>%nto be of type%n  <%s>%nbut was of type%n  <%s>";
    private static final String EXPECTED_MESSAGE_NOT_IDENTIFIED = "%nExpecting:%n  <%s>%nto be of type%n  <%s>%nbut was of type%n  <%s> (%s)";
    private static final String EXPECTED_MESSAGE_NOT_IDENTIFIED_WITH_INDEX = "%nExpecting that the value at index %s:%n  <%s>%nto be of type%n  <%s>%nbut was of type%n  <%s> (%s)";

    public static ErrorMessageFactory shouldBeValueType(Value actual, ValueType tested, ValueType expected) {
        if (actual.getValue() != null && tested == ValueType.NOT_IDENTIFIED) {
            return new ShouldBeValueType(actual, actual.getValue().getClass(), tested, expected);
        }
        return new ShouldBeValueType(actual, tested, expected);
    }

    public static ErrorMessageFactory shouldBeValueType(int index, Value actual, ValueType tested, ValueType expected) {
        if (actual.getValue() != null && tested == ValueType.NOT_IDENTIFIED) {
            return new ShouldBeValueType(index, actual, actual.getValue().getClass(), tested, expected);
        }
        return new ShouldBeValueType(index, actual, tested, expected);
    }

    private ShouldBeValueType(Value actual, ValueType tested, ValueType expected) {
        super(EXPECTED_MESSAGE, new Object[]{actual.getValue(), expected, tested});
    }

    private ShouldBeValueType(int index, Value actual, ValueType tested, ValueType expected) {
        super(EXPECTED_MESSAGE_WITH_INDEX, new Object[]{index, actual.getValue(), expected, tested});
    }

    private ShouldBeValueType(Value actual, Class classOfActual, ValueType tested, ValueType expected) {
        super(EXPECTED_MESSAGE_NOT_IDENTIFIED, new Object[]{actual.getValue(), expected, tested, classOfActual});
    }

    private ShouldBeValueType(int index, Value actual, Class classOfActual, ValueType tested, ValueType expected) {
        super(EXPECTED_MESSAGE_NOT_IDENTIFIED_WITH_INDEX, new Object[]{index, actual.getValue(), expected, tested, classOfActual});
    }
}

