/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.output;

import java.util.List;
import org.assertj.db.global.AbstractElement;
import org.assertj.db.navigation.Position;
import org.assertj.db.navigation.PositionWithColumns;
import org.assertj.db.navigation.origin.OriginWithColumnsAndRows;
import org.assertj.db.output.AbstractColumnOutputter;
import org.assertj.db.output.AbstractColumnValueOutputter;
import org.assertj.db.output.AbstractOutputter;
import org.assertj.db.output.AbstractRowOutputter;
import org.assertj.db.output.AbstractRowValueOutputter;
import org.assertj.db.output.impl.OutputType;
import org.assertj.db.type.AbstractDbData;
import org.assertj.db.type.AbstractDbElement;
import org.assertj.db.type.Column;
import org.assertj.db.type.Row;
import org.assertj.db.util.Descriptions;

public abstract class AbstractDbOutputter<D extends AbstractDbData<D>, A extends AbstractDbOutputter<D, A, C, CV, R, RV>, C extends AbstractColumnOutputter<D, A, C, CV, R, RV>, CV extends AbstractColumnValueOutputter<D, A, C, CV, R, RV>, R extends AbstractRowOutputter<D, A, C, CV, R, RV>, RV extends AbstractRowValueOutputter<D, A, C, CV, R, RV>>
extends AbstractOutputter<A>
implements OriginWithColumnsAndRows<C, R> {
    protected final D actual;
    private final PositionWithColumns<A, C, Column> columnPosition;
    private final Position<A, R, Row> rowPosition;

    AbstractDbOutputter(D actualValue, Class<A> selfType, Class<C> columnAssertType, Class<R> rowAssertType) {
        super(selfType);
        this.actual = actualValue;
        this.columnPosition = new PositionWithColumns((AbstractElement)selfType.cast(this), columnAssertType){

            @Override
            protected String getDescription(int index) {
                List<String> columnsNameList = ((AbstractDbData)AbstractDbOutputter.this.actual).getColumnsNameList();
                String columnName = columnsNameList.get(index);
                return Descriptions.getColumnDescription(((AbstractDbOutputter)AbstractDbOutputter.this.myself).getInfo(), index, columnName);
            }
        };
        this.rowPosition = new Position((AbstractElement)selfType.cast(this), rowAssertType){

            @Override
            protected String getDescription(int index) {
                return Descriptions.getRowDescription(((AbstractDbOutputter)AbstractDbOutputter.this.myself).getInfo(), index);
            }
        };
        this.withType(OutputType.PLAIN);
    }

    @Override
    public R row() {
        return (R)((AbstractRowOutputter)((AbstractRowOutputter)this.rowPosition.getInstance(((AbstractDbData)this.actual).getRowsList())).withType(this.outputType));
    }

    @Override
    public R row(int index) {
        return (R)((AbstractRowOutputter)((AbstractRowOutputter)this.rowPosition.getInstance(((AbstractDbData)this.actual).getRowsList(), index)).withType(this.outputType));
    }

    @Override
    public C column() {
        return (C)((AbstractColumnOutputter)((AbstractColumnOutputter)this.columnPosition.getInstance(((AbstractDbData)this.actual).getColumnsList())).withType(this.outputType));
    }

    @Override
    public C column(int index) {
        return (C)((AbstractColumnOutputter)((AbstractColumnOutputter)this.columnPosition.getInstance(((AbstractDbData)this.actual).getColumnsList(), index)).withType(this.outputType));
    }

    @Override
    public C column(String columnName) {
        return (C)((AbstractColumnOutputter)((AbstractColumnOutputter)this.columnPosition.getInstance(((AbstractDbData)this.actual).getColumnsList(), ((AbstractDbData)this.actual).getColumnsNameList(), columnName, ((AbstractDbElement)this.actual).getColumnLetterCase())).withType(this.outputType));
    }
}

