/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.output.impl;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.db.output.impl.Output;
import org.assertj.db.output.impl.OutputType;
import org.assertj.db.type.Change;
import org.assertj.db.type.ChangeType;
import org.assertj.db.type.Changes;
import org.assertj.db.type.Column;
import org.assertj.db.type.DataType;
import org.assertj.db.type.Request;
import org.assertj.db.type.Row;
import org.assertj.db.type.Table;
import org.assertj.db.type.Value;

enum PlainOutput implements Output
{
    INSTANCE;


    private static String getText(Object object) {
        return "" + object;
    }

    private static int getColumnSize(String columnName, String type, Integer index, Value ... values) {
        int indexSize;
        int typeSize;
        int size = ("" + columnName).length();
        if (type != null && (typeSize = type.length()) > size) {
            size = typeSize;
        }
        if (index != null && (indexSize = ("Index : " + index).length()) > size) {
            size = indexSize;
        }
        for (Value value : values) {
            int valueSize = OutputType.getText(value).length();
            if (valueSize <= size) continue;
            size = valueSize;
        }
        return size + 2;
    }

    private static int getColumnSize(String columnName, Object ... objects) {
        int size = ("" + columnName).length();
        for (Object object : objects) {
            int valueSize = PlainOutput.getText(object).length();
            if (valueSize <= size) continue;
            size = valueSize;
        }
        return size + 2;
    }

    private static StringBuilder getFilledText(String text, int size) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" ").append(text);
        while (stringBuilder.length() < size) {
            stringBuilder.append(" ");
        }
        return stringBuilder;
    }

    private static StringBuilder getCellLine(int size) {
        StringBuilder stringBuilder = new StringBuilder();
        while (stringBuilder.length() < size) {
            stringBuilder.append('-');
        }
        return stringBuilder;
    }

    private static StringBuilder getCompleteRow(List<Integer> sizesList, Row row, Object ... otherColumnsContent) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("|");
        int index = 0;
        for (Integer size : sizesList) {
            if (index < otherColumnsContent.length) {
                stringBuilder.append((CharSequence)PlainOutput.getFilledText("" + otherColumnsContent[index], size));
                stringBuilder.append("|");
            } else if (row != null) {
                Value value = row.getValuesList().get(index - otherColumnsContent.length);
                stringBuilder.append((CharSequence)PlainOutput.getFilledText(OutputType.getText(value), size)).append("|");
            } else {
                stringBuilder.append((CharSequence)PlainOutput.getFilledText("", size)).append("|");
            }
            ++index;
        }
        stringBuilder.append("%n");
        return stringBuilder;
    }

    private static StringBuilder getCompleteLine(List<Integer> sizesList, Object ... otherColumnsContent) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("|");
        int index = 0;
        for (int size : sizesList) {
            if (index < otherColumnsContent.length) {
                stringBuilder.append((CharSequence)PlainOutput.getFilledText("" + otherColumnsContent[index], size));
            } else {
                stringBuilder.append((CharSequence)PlainOutput.getCellLine(size));
            }
            stringBuilder.append("|");
            ++index;
        }
        stringBuilder.append("%n");
        return stringBuilder;
    }

    private List<Integer> getSizesList(List<Integer> columnSizesList, Integer ... sizes) {
        ArrayList<Integer> sizesList = new ArrayList<Integer>();
        for (Integer size : sizes) {
            sizesList.add(size);
        }
        if (columnSizesList != null) {
            for (Integer size : columnSizesList) {
                sizesList.add(size);
            }
        }
        return sizesList;
    }

    private static StringBuilder getCompletePrimaryKey(List<Integer> sizesList, List<String> pksNameList, List<String> columnsNameList) {
        int index;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("|");
        for (index = 0; index < sizesList.size() - columnsNameList.size(); ++index) {
            Integer columnSize = sizesList.get(index);
            stringBuilder.append((CharSequence)PlainOutput.getFilledText("", columnSize));
            stringBuilder.append("|");
        }
        for (String columnName : columnsNameList) {
            Integer columnSize = sizesList.get(index);
            String pk = "";
            if (pksNameList != null && pksNameList.contains(columnName)) {
                pk = "*";
            }
            stringBuilder.append((CharSequence)PlainOutput.getFilledText(pk, columnSize)).append("|");
            ++index;
        }
        stringBuilder.append("%n");
        return stringBuilder;
    }

    private static StringBuilder getCompleteColumnName(List<Integer> sizesList, List<String> columnsNameList, String ... otherColumnsContent) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("|");
        int index = 0;
        for (String content : otherColumnsContent) {
            Integer columnSize = sizesList.get(index);
            stringBuilder.append((CharSequence)PlainOutput.getFilledText(content, columnSize));
            stringBuilder.append("|");
            ++index;
        }
        for (String columnName : columnsNameList) {
            Integer columnSize = sizesList.get(index);
            stringBuilder.append((CharSequence)PlainOutput.getFilledText(columnName, columnSize)).append("|");
            ++index;
        }
        stringBuilder.append("%n");
        return stringBuilder;
    }

    private static StringBuilder getCompleteType(List<Integer> sizesList, List<String> typesList, String ... otherColumnsContent) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("|");
        int index = 0;
        for (String content : otherColumnsContent) {
            Integer columnSize = sizesList.get(index);
            stringBuilder.append((CharSequence)PlainOutput.getFilledText(content, columnSize));
            stringBuilder.append("|");
            ++index;
        }
        while (index < sizesList.size()) {
            int index1 = index - otherColumnsContent.length;
            Integer columnSize = sizesList.get(index);
            String type = index1 < typesList.size() ? typesList.get(index1) : "";
            stringBuilder.append((CharSequence)PlainOutput.getFilledText(type, columnSize)).append("|");
            ++index;
        }
        stringBuilder.append("%n");
        return stringBuilder;
    }

    private static StringBuilder getCompleteIndex(List<Integer> sizesList, int numberOfAdditionalColumns) {
        Integer columnSize;
        int index;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("|");
        for (index = 0; index < numberOfAdditionalColumns; ++index) {
            columnSize = sizesList.get(index);
            stringBuilder.append((CharSequence)PlainOutput.getFilledText("", columnSize));
            stringBuilder.append("|");
        }
        while (index < sizesList.size()) {
            columnSize = sizesList.get(index);
            stringBuilder.append((CharSequence)PlainOutput.getFilledText("Index : " + (index - numberOfAdditionalColumns), columnSize)).append("|");
            ++index;
        }
        stringBuilder.append("%n");
        return stringBuilder;
    }

    private static Integer getIndexColumnSize(int size) {
        return PlainOutput.getColumnSize("", "Index : " + (size - 1));
    }

    private static Integer getChangeTypeColumnSize(Change ... changes) {
        int size = 0;
        for (Change change : changes) {
            ChangeType changeType = change.getChangeType();
            int changeTypeColumnSize = PlainOutput.getColumnSize("TYPE", new Object[]{changeType});
            if (size >= changeTypeColumnSize) continue;
            size = changeTypeColumnSize;
        }
        return size;
    }

    private static Integer getDataTypeColumnSize(Change ... changes) {
        int size = 0;
        for (Change change : changes) {
            DataType dataType = change.getDataType();
            String dataName = OutputType.getDataName(change);
            int dataTypeColumnSize = PlainOutput.getColumnSize("" + (Object)((Object)dataType), dataName);
            if (size >= dataTypeColumnSize) continue;
            size = dataTypeColumnSize;
        }
        return size;
    }

    private static List<Integer> getColumnSizesList(List<String> columnsNameList) {
        ArrayList<Integer> columnSizesList = new ArrayList<Integer>();
        int index = 0;
        for (String columnName : columnsNameList) {
            int columnSize = PlainOutput.getColumnSize(columnName, "", index, new Value[0]);
            columnSizesList.add(columnSize);
            ++index;
        }
        return columnSizesList;
    }

    private static List<Integer> getColumnSizesList(Row ... rows) {
        ArrayList<Integer> columnSizesList = new ArrayList<Integer>();
        Row row0 = null;
        for (Row row : rows) {
            if (row == null) continue;
            row0 = row;
            break;
        }
        if (row0 != null) {
            List<String> columnsNameList = row0.getColumnsNameList();
            int index = 0;
            for (String columnName : columnsNameList) {
                ArrayList<Value> valuesList = new ArrayList<Value>();
                for (Row row : rows) {
                    if (row == null) continue;
                    Value value = row.getValuesList().get(index);
                    valuesList.add(value);
                }
                String type = OutputType.getType(valuesList.toArray(new Value[valuesList.size()]));
                int columnSize = PlainOutput.getColumnSize(columnName, type, index, valuesList.toArray(new Value[valuesList.size()]));
                columnSizesList.add(columnSize);
                ++index;
            }
        }
        return columnSizesList;
    }

    @Override
    public String getTableOutput(WritableAssertionInfo info, Table table) {
        List<String> pksNameList = table.getPksNameList();
        List<String> columnsNameList = table.getColumnsNameList();
        List<Row> rowsList = table.getRowsList();
        Row[] rows = rowsList.toArray(new Row[rowsList.size()]);
        List<String> typesList = OutputType.getTypesList(rows);
        int indexColumnSize = PlainOutput.getIndexColumnSize(rows.length);
        Object[] pksValueStringBuilders = OutputType.getPksValueStringBuilder(rows);
        int primaryKeyColumnSize = PlainOutput.getColumnSize("PRIMARY", pksValueStringBuilders);
        List<Integer> sizesList = this.getSizesList(rows.length == 0 ? PlainOutput.getColumnSizesList(columnsNameList) : PlainOutput.getColumnSizesList(rows), indexColumnSize, primaryKeyColumnSize);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(info.descriptionText()).append("]%n");
        stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[0]));
        stringBuilder.append((CharSequence)PlainOutput.getCompletePrimaryKey(sizesList, pksNameList, columnsNameList));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteColumnName(sizesList, columnsNameList, "", "PRIMARY"));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteType(sizesList, typesList, "", "KEY"));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteIndex(sizesList, 2));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[0]));
        int index = 0;
        for (Row row : rows) {
            stringBuilder.append((CharSequence)PlainOutput.getCompleteRow(sizesList, row, "Index : " + index, pksValueStringBuilders[index]));
            ++index;
        }
        stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[0]));
        return String.format(stringBuilder.toString(), new Object[0]);
    }

    @Override
    public String getRequestOutput(WritableAssertionInfo info, Request request) {
        List<String> pksNameList = request.getPksNameList();
        List<String> columnsNameList = request.getColumnsNameList();
        List<Row> rowsList = request.getRowsList();
        Row[] rows = rowsList.toArray(new Row[rowsList.size()]);
        List<String> typesList = OutputType.getTypesList(rows);
        int indexColumnSize = PlainOutput.getIndexColumnSize(rows.length);
        Object[] pksValueStringBuilders = OutputType.getPksValueStringBuilder(rows);
        int primaryKeyColumnSize = PlainOutput.getColumnSize("PRIMARY", pksValueStringBuilders);
        List<Integer> sizesList = this.getSizesList(rows.length == 0 ? PlainOutput.getColumnSizesList(columnsNameList) : PlainOutput.getColumnSizesList(rows), indexColumnSize, primaryKeyColumnSize);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(info.descriptionText()).append("]%n");
        stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[0]));
        stringBuilder.append((CharSequence)PlainOutput.getCompletePrimaryKey(sizesList, pksNameList, columnsNameList));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteColumnName(sizesList, columnsNameList, "", "PRIMARY"));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteType(sizesList, typesList, "", "KEY"));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteIndex(sizesList, 2));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[0]));
        int index = 0;
        for (Row row : rows) {
            stringBuilder.append((CharSequence)PlainOutput.getCompleteRow(sizesList, row, "Index : " + index, pksValueStringBuilders[index]));
            ++index;
        }
        stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[0]));
        return String.format(stringBuilder.toString(), new Object[0]);
    }

    @Override
    public String getChangesOutput(WritableAssertionInfo info, Changes changes) {
        List<Change> changesList = changes.getChangesList();
        Change[] changesArray = changesList.toArray(new Change[changesList.size()]);
        int indexColumnSize = PlainOutput.getIndexColumnSize(changesList.size());
        int changeTypeColumnSize = PlainOutput.getChangeTypeColumnSize(changesArray);
        int dataTypeColumnSize = PlainOutput.getDataTypeColumnSize(changesArray);
        Object[] pksValueStringBuilders = OutputType.getPksValueStringBuilder(changesArray);
        int primaryKeyColumnSize = PlainOutput.getColumnSize("PRIMARY", pksValueStringBuilders);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(info.descriptionText()).append("]%n");
        int index = 0;
        for (Change change : changesList) {
            ChangeType changeType = change.getChangeType();
            DataType dataType = change.getDataType();
            String dataName = OutputType.getDataName(change);
            List<String> columnsNameList = change.getColumnsNameList();
            Row rowAtStartPoint = change.getRowAtStartPoint();
            Row rowAtEndPoint = change.getRowAtEndPoint();
            List<String> typesList = OutputType.getTypesList(rowAtStartPoint, rowAtEndPoint);
            List<Integer> sizesList = this.getSizesList(PlainOutput.getColumnSizesList(rowAtStartPoint, rowAtEndPoint), indexColumnSize, changeTypeColumnSize, dataTypeColumnSize, primaryKeyColumnSize, 16);
            stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[0]));
            stringBuilder.append((CharSequence)PlainOutput.getCompletePrimaryKey(sizesList, change.getPksNameList(), columnsNameList));
            stringBuilder.append((CharSequence)PlainOutput.getCompleteColumnName(sizesList, columnsNameList, "", "TYPE", "" + (Object)((Object)dataType), "PRIMARY", ""));
            stringBuilder.append((CharSequence)PlainOutput.getCompleteType(sizesList, typesList, "", "", "", "KEY", ""));
            stringBuilder.append((CharSequence)PlainOutput.getCompleteIndex(sizesList, 5));
            stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[0]));
            stringBuilder.append((CharSequence)PlainOutput.getCompleteRow(sizesList, rowAtStartPoint, "", "", "", "", "At start point"));
            stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[]{"Index : " + index, changeType, dataName, pksValueStringBuilders[index]}));
            stringBuilder.append((CharSequence)PlainOutput.getCompleteRow(sizesList, rowAtEndPoint, "", "", "", "", "At end point"));
            stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[0]));
            ++index;
        }
        return String.format(stringBuilder.toString(), new Object[0]);
    }

    @Override
    public String getChangeOutput(WritableAssertionInfo info, Change change) {
        ChangeType changeType = change.getChangeType();
        DataType dataType = change.getDataType();
        String dataName = OutputType.getDataName(change);
        List<String> columnsNameList = change.getColumnsNameList();
        Row rowAtStartPoint = change.getRowAtStartPoint();
        Row rowAtEndPoint = change.getRowAtEndPoint();
        Object[] pksValueStringBuilders = OutputType.getPksValueStringBuilder(change);
        List<String> typesList = OutputType.getTypesList(rowAtStartPoint, rowAtEndPoint);
        int changeTypeColumnSize = PlainOutput.getColumnSize("TYPE", new Object[]{changeType});
        int dataTypeColumnSize = PlainOutput.getColumnSize("" + (Object)((Object)dataType), dataName);
        int primaryKeyColumnSize = PlainOutput.getColumnSize("PRIMARY", pksValueStringBuilders);
        List<Integer> sizesList = this.getSizesList(PlainOutput.getColumnSizesList(rowAtStartPoint, rowAtEndPoint), changeTypeColumnSize, dataTypeColumnSize, primaryKeyColumnSize, 16);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(info.descriptionText()).append("]%n");
        stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[0]));
        stringBuilder.append((CharSequence)PlainOutput.getCompletePrimaryKey(sizesList, change.getPksNameList(), columnsNameList));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteColumnName(sizesList, columnsNameList, "TYPE", "" + (Object)((Object)dataType), "PRIMARY", ""));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteType(sizesList, typesList, "", "", "KEY", ""));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteIndex(sizesList, 4));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[0]));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteRow(sizesList, rowAtStartPoint, "", "", "", "At start point"));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[]{changeType, dataName, pksValueStringBuilders[0]}));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteRow(sizesList, rowAtEndPoint, "", "", "", "At end point"));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[0]));
        return String.format(stringBuilder.toString(), new Object[0]);
    }

    @Override
    public String getRowOutput(WritableAssertionInfo info, Row row) {
        if (row == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[").append(info.descriptionText()).append("]%n");
            stringBuilder.append("Row does not exist%n");
            return String.format(stringBuilder.toString(), new Object[0]);
        }
        List<String> columnsNameList = row.getColumnsNameList();
        List<String> typesList = OutputType.getTypesList(row);
        Object[] pksValueStringBuilders = OutputType.getPksValueStringBuilder(row);
        int primaryKeyColumnSize = PlainOutput.getColumnSize("PRIMARY", pksValueStringBuilders);
        List<Integer> sizesList = this.getSizesList(PlainOutput.getColumnSizesList(row), primaryKeyColumnSize);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(info.descriptionText()).append("]%n");
        stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[0]));
        stringBuilder.append((CharSequence)PlainOutput.getCompletePrimaryKey(sizesList, row.getPksNameList(), columnsNameList));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteColumnName(sizesList, columnsNameList, "PRIMARY"));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteType(sizesList, typesList, "KEY"));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteIndex(sizesList, 1));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[0]));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteRow(sizesList, row, pksValueStringBuilders[0]));
        stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[0]));
        return String.format(stringBuilder.toString(), new Object[0]);
    }

    @Override
    public String getColumnOutput(WritableAssertionInfo info, Column column) {
        String columnName = column.getName();
        List<Value> valuesList = column.getValuesList();
        Value[] values = valuesList.toArray(new Value[valuesList.size()]);
        int indexColumnSize = PlainOutput.getIndexColumnSize(values.length);
        String type = OutputType.getType(values);
        int columnSize = PlainOutput.getColumnSize(columnName, type, null, values);
        List<Integer> sizesList = this.getSizesList(null, indexColumnSize, columnSize);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(info.descriptionText()).append("]%n");
        stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[0]));
        stringBuilder.append("|").append((CharSequence)PlainOutput.getFilledText("", indexColumnSize)).append("|").append((CharSequence)PlainOutput.getFilledText(columnName, columnSize)).append("|%n");
        stringBuilder.append("|").append((CharSequence)PlainOutput.getFilledText("", indexColumnSize)).append("|").append((CharSequence)PlainOutput.getFilledText(type, columnSize)).append("|%n");
        stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[0]));
        int index = 0;
        for (Value value : values) {
            stringBuilder.append("|").append((CharSequence)PlainOutput.getFilledText(PlainOutput.getText("Index : " + index), indexColumnSize)).append("|").append((CharSequence)PlainOutput.getFilledText(OutputType.getText(value), columnSize)).append("|%n");
            ++index;
        }
        stringBuilder.append((CharSequence)PlainOutput.getCompleteLine(sizesList, new Object[0]));
        return String.format(stringBuilder.toString(), new Object[0]);
    }

    @Override
    public String getChangeColumnOutput(WritableAssertionInfo info, String columnName, Value valueAtStartPoint, Value valueAtEndPoint) {
        String typeAtStartPoint = OutputType.getType(valueAtStartPoint);
        String typeAtEndPoint = OutputType.getType(valueAtEndPoint);
        String type = valueAtStartPoint.getValue() != null ? typeAtStartPoint : typeAtEndPoint;
        int columnSize = PlainOutput.getColumnSize(columnName, type, null, valueAtStartPoint, valueAtEndPoint);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(info.descriptionText()).append("]%n");
        stringBuilder.append("|----------------|").append((CharSequence)PlainOutput.getCellLine(columnSize)).append("|%n");
        stringBuilder.append("|                |").append((CharSequence)PlainOutput.getFilledText(columnName, columnSize)).append("|%n");
        stringBuilder.append("|                |").append((CharSequence)PlainOutput.getFilledText(type, columnSize)).append("|%n");
        stringBuilder.append("|----------------|").append((CharSequence)PlainOutput.getCellLine(columnSize)).append("|%n");
        stringBuilder.append("| At start point |").append((CharSequence)PlainOutput.getFilledText(OutputType.getText(valueAtStartPoint), columnSize)).append("|%n");
        stringBuilder.append("|----------------|").append((CharSequence)PlainOutput.getCellLine(columnSize)).append("|%n");
        stringBuilder.append("| At end point   |").append((CharSequence)PlainOutput.getFilledText(OutputType.getText(valueAtEndPoint), columnSize)).append("|%n");
        stringBuilder.append("|----------------|").append((CharSequence)PlainOutput.getCellLine(columnSize)).append("|%n");
        return String.format(stringBuilder.toString(), new Object[0]);
    }

    @Override
    public String getValueOutput(WritableAssertionInfo info, Value value) {
        String columnName = value.getColumnName();
        String type = OutputType.getType(value);
        int columnSize = PlainOutput.getColumnSize(columnName, type, null, value);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(info.descriptionText()).append("]%n");
        stringBuilder.append("|").append((CharSequence)PlainOutput.getCellLine(columnSize)).append("|%n");
        stringBuilder.append("|").append((CharSequence)PlainOutput.getFilledText(columnName, columnSize)).append("|%n");
        stringBuilder.append("|").append((CharSequence)PlainOutput.getFilledText(type, columnSize)).append("|%n");
        stringBuilder.append("|").append((CharSequence)PlainOutput.getCellLine(columnSize)).append("|%n");
        stringBuilder.append("|").append((CharSequence)PlainOutput.getFilledText(OutputType.getText(value), columnSize)).append("|%n");
        stringBuilder.append("|").append((CharSequence)PlainOutput.getCellLine(columnSize)).append("|%n");
        return String.format(stringBuilder.toString(), new Object[0]);
    }
}

