/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.DateValueContainer;
import org.assertj.db.type.TimeValue;

public class DateTimeValue
implements Comparable<DateTimeValue>,
DateValueContainer {
    private final DateValue date;
    private final TimeValue time;
    private static final String DATE_FORMAT = "\\d\\d\\d\\d-\\d\\d-\\d\\d";
    private static final String TIME_FORMAT = "\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d";
    private static final String TIME_FORMAT_WITH_SECONDS = "\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\d";
    private static final String TIME_FORMAT_WITH_NANO = "\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d\\d\\d\\d\\d\\d\\d";

    public static DateTimeValue of(DateValue date) {
        return new DateTimeValue(date, TimeValue.of(0, 0));
    }

    public static DateTimeValue of(DateValue date, TimeValue time) {
        return new DateTimeValue(date, time);
    }

    public static DateTimeValue parse(String dateTime) throws ParseException {
        return new DateTimeValue(dateTime);
    }

    public static DateTimeValue from(Timestamp timestamp) {
        return new DateTimeValue(timestamp);
    }

    public static DateTimeValue from(Calendar calendar) {
        return new DateTimeValue(calendar);
    }

    public static DateTimeValue now() {
        return DateTimeValue.from(Calendar.getInstance());
    }

    public DateTimeValue(DateValue date, TimeValue time) {
        if (date == null) {
            throw new NullPointerException("date should be not null");
        }
        if (time == null) {
            throw new NullPointerException("time should be not null");
        }
        this.date = date;
        this.time = time;
    }

    public DateTimeValue(String dateTime) throws ParseException {
        if (dateTime == null) {
            throw new NullPointerException("date/time should be not null");
        }
        if (dateTime.matches(DATE_FORMAT)) {
            this.date = DateValue.parse(dateTime);
            this.time = new TimeValue(0, 0);
        } else if (dateTime.matches(TIME_FORMAT) || dateTime.matches(TIME_FORMAT_WITH_SECONDS) || dateTime.matches(TIME_FORMAT_WITH_NANO)) {
            this.date = DateValue.parse(dateTime.substring(0, 10));
            this.time = TimeValue.parse(dateTime.substring(11));
        } else {
            throw new ParseException("date/time must respect yyyy-mm-dd, yyyy-mm-ddThh:mm, yyyy-mm-ddThh:mm:ss or yyyy-mm-ddThh:mm:ss.nnnnnnnnn format", dateTime.length());
        }
    }

    public DateTimeValue(Timestamp timestamp) {
        if (timestamp == null) {
            throw new NullPointerException("date/time should be not null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp.getTime());
        this.date = DateValue.of(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        this.time = TimeValue.of(calendar.get(11), calendar.get(12), calendar.get(13), timestamp.getNanos());
    }

    public DateTimeValue(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("date/time should be not null");
        }
        this.date = DateValue.from(calendar);
        this.time = TimeValue.from(calendar);
    }

    @Override
    public DateValue getDate() {
        return this.date;
    }

    @Override
    public boolean isMidnight() {
        return this.time.getHours() == 0 && this.time.getMinutes() == 0 && this.time.getSeconds() == 0 && this.time.getNanoSeconds() == 0;
    }

    public TimeValue getTime() {
        return this.time;
    }

    public String toString() {
        return String.format("%4d-%02d-%02dT%02d:%02d:%02d.%09d", this.date.getYear(), this.date.getMonth(), this.date.getDayOfTheMonth(), this.time.getHours(), this.time.getMinutes(), this.time.getSeconds(), this.time.getNanoSeconds());
    }

    public boolean equals(Object obj) {
        if (obj instanceof DateTimeValue) {
            DateTimeValue dateTimeValue = (DateTimeValue)obj;
            return this.date.equals(dateTimeValue.date) && this.time.equals(dateTimeValue.time);
        }
        if (obj instanceof DateValueContainer) {
            DateValueContainer value = (DateValueContainer)obj;
            return this.date.equals(value.getDate()) && this.isMidnight();
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.date.hashCode();
        result = 31 * result + this.time.hashCode();
        return result;
    }

    @Override
    public int compareTo(DateTimeValue other) {
        int compareDate = this.date.compareTo(other.date);
        if (compareDate != 0) {
            return compareDate;
        }
        return this.time.compareTo(other.time);
    }

    public boolean isBefore(DateTimeValue dateTime) {
        return this.compareTo(dateTime) == -1;
    }

    public boolean isAfter(DateTimeValue dateTime) {
        return this.compareTo(dateTime) == 1;
    }

    public DateTimeValue move(DateValue date) {
        TimeValue timeValue = this.getTime();
        DateValue dateValue = this.getDate();
        DateValue movedDateValue = dateValue.move(date);
        return DateTimeValue.of(movedDateValue, timeValue);
    }

    public DateTimeValue move(TimeValue time) {
        TimeValue timeValue = this.getTime();
        TimeValue movedTimeValue = timeValue.move(time);
        int hours = movedTimeValue.getHours();
        int days = hours / 24;
        hours = hours > 0 ? (hours -= days * 24) : (hours += days * 24);
        if (hours < 0) {
            --days;
            hours += 24;
        }
        DateValue dateValue = this.getDate();
        DateValue movedDateValue = dateValue.move(DateValue.of(0, 0, days));
        return DateTimeValue.of(movedDateValue, TimeValue.of(hours, movedTimeValue.getMinutes(), movedTimeValue.getSeconds(), movedTimeValue.getNanoSeconds()));
    }

    public DateTimeValue move(DateTimeValue dateTime) {
        DateTimeValue aDateTime = this.move(dateTime.getDate());
        return aDateTime.move(dateTime.getTime());
    }

    public DateTimeValue reverse() {
        return DateTimeValue.of(this.date.reverse(), this.time.reverse());
    }
}

