/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.UUID;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.TimeValue;
import org.assertj.db.type.Value;
import org.assertj.db.type.ValueType;

public class Values {
    private Values() {
    }

    public static boolean areEqual(Value value, Object expected) {
        ValueType valueType = value.getValueType();
        switch (valueType) {
            case BOOLEAN: {
                if (!(expected instanceof Boolean)) break;
                return Values.areEqual(value, (Boolean)expected);
            }
            case NUMBER: {
                if (expected instanceof Number) {
                    return Values.areEqual(value, (Number)expected);
                }
                if (!(expected instanceof String)) break;
                return Values.areEqual(value, (String)expected);
            }
            case BYTES: {
                if (!(expected instanceof byte[])) break;
                return Values.areEqual(value, (byte[])expected);
            }
            case TEXT: {
                if (!(expected instanceof String)) break;
                return Values.areEqual(value, (String)expected);
            }
            case UUID: {
                if (expected instanceof UUID) {
                    return Values.areEqual(value, (UUID)expected);
                }
                if (!(expected instanceof String)) break;
                return Values.areEqual(value, (String)expected);
            }
            case DATE: {
                if (expected instanceof DateValue) {
                    return Values.areEqual(value, (DateValue)expected);
                }
                if (expected instanceof String) {
                    return Values.areEqual(value, (String)expected);
                }
                if (!(expected instanceof Date)) break;
                return Values.areEqual(value, DateValue.from((Date)expected));
            }
            case TIME: {
                if (expected instanceof TimeValue) {
                    return Values.areEqual(value, (TimeValue)expected);
                }
                if (expected instanceof String) {
                    return Values.areEqual(value, (String)expected);
                }
                if (!(expected instanceof Time)) break;
                return Values.areEqual(value, TimeValue.from((Time)expected));
            }
            case DATE_TIME: {
                if (expected instanceof DateTimeValue) {
                    return Values.areEqual(value, (DateTimeValue)expected);
                }
                if (expected instanceof DateValue) {
                    return Values.areEqual(value, (DateValue)expected);
                }
                if (expected instanceof String) {
                    return Values.areEqual(value, (String)expected);
                }
                if (!(expected instanceof Timestamp)) break;
                return Values.areEqual(value, DateTimeValue.from((Timestamp)expected));
            }
            default: {
                Object object = value.getValue();
                if (expected == null && object == null) {
                    return true;
                }
                if (object == null) break;
                return object.equals(expected);
            }
        }
        return false;
    }

    public static boolean areEqual(Value value, Boolean expected) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        return expected.equals(object);
    }

    public static boolean areEqual(Value value, Number expected) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (expected instanceof BigInteger) {
            BigInteger bi;
            if (object instanceof BigInteger) {
                bi = (BigInteger)object;
            } else {
                try {
                    bi = new BigInteger("" + object);
                }
                catch (NumberFormatException e) {
                    throw new AssertJDBException("Expected <%s> can not be compared to a BigInteger (<%s>)", expected, object);
                }
            }
            if (bi.compareTo((BigInteger)expected) == 0) {
                return true;
            }
        } else if (expected instanceof BigDecimal) {
            BigDecimal bd;
            if (object instanceof BigDecimal) {
                bd = (BigDecimal)object;
            } else {
                try {
                    bd = new BigDecimal("" + object);
                }
                catch (NumberFormatException e) {
                    throw new AssertJDBException("Expected <%s> can not be compared to a BigDecimal (<%s>)", expected, object);
                }
            }
            if (bd.compareTo((BigDecimal)expected) == 0) {
                return true;
            }
        } else {
            Long actualValue = null;
            if (object instanceof Float) {
                if (((Float)object).floatValue() == expected.floatValue()) {
                    return true;
                }
            } else if (object instanceof Double) {
                if (((Double)object).doubleValue() == expected.doubleValue()) {
                    return true;
                }
            } else if (object instanceof BigInteger) {
                BigInteger bi = new BigInteger("" + expected);
                if (((BigInteger)object).compareTo(bi) == 0) {
                    return true;
                }
            } else if (object instanceof BigDecimal) {
                BigDecimal bd = new BigDecimal("" + expected);
                if (((BigDecimal)object).compareTo(bd) == 0) {
                    return true;
                }
            } else if (object instanceof Byte) {
                actualValue = ((Byte)object).longValue();
            } else if (object instanceof Short) {
                actualValue = ((Short)object).longValue();
            } else if (object instanceof Integer) {
                actualValue = ((Integer)object).longValue();
            } else if (object instanceof Long) {
                actualValue = (Long)object;
            }
            if (actualValue != null && (expected instanceof Float ? (float)actualValue.longValue() == expected.floatValue() : (expected instanceof Double ? (double)actualValue.longValue() == expected.doubleValue() : actualValue.longValue() == expected.longValue()))) {
                return true;
            }
        }
        return false;
    }

    public static boolean areEqual(Value value, byte[] expected) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            if (bytes.length != expected.length) {
                return false;
            }
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] == expected[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean areEqual(Date date, String expected) {
        try {
            DateTimeValue dateTimeValue = DateTimeValue.of(DateValue.from(date));
            DateTimeValue expectedDateTimeValue = DateTimeValue.parse(expected);
            if (dateTimeValue.equals(expectedDateTimeValue)) {
                return true;
            }
        }
        catch (ParseException e) {
            throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, date);
        }
        return false;
    }

    private static boolean areEqual(Time time, String expected) {
        try {
            TimeValue timeValue = TimeValue.from(time);
            TimeValue expectedTimeValue = TimeValue.parse(expected);
            if (timeValue.equals(expectedTimeValue)) {
                return true;
            }
        }
        catch (ParseException e) {
            throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, time);
        }
        return false;
    }

    private static boolean areEqual(Timestamp timestamp, String expected) {
        try {
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            DateTimeValue expectedDateTimeValue = DateTimeValue.parse(expected);
            if (dateTimeValue.equals(expectedDateTimeValue)) {
                return true;
            }
        }
        catch (ParseException e) {
            throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, timestamp);
        }
        return false;
    }

    private static boolean areEqual(Number number, String expected) {
        try {
            if (number instanceof Float) {
                if (number.floatValue() == Float.parseFloat(expected)) {
                    return true;
                }
            } else if (number instanceof Double) {
                if (number.doubleValue() == Double.parseDouble(expected)) {
                    return true;
                }
            } else if (number instanceof BigInteger) {
                BigInteger bi = new BigInteger("" + expected);
                if (((BigInteger)number).compareTo(bi) == 0) {
                    return true;
                }
            } else if (number instanceof BigDecimal) {
                BigDecimal bd = new BigDecimal("" + expected);
                if (((BigDecimal)number).compareTo(bd) == 0) {
                    return true;
                }
            } else {
                Long actual = null;
                if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
                    actual = number.longValue();
                } else if (number instanceof Long) {
                    actual = (Long)number;
                }
                if (actual != null && actual == Long.parseLong(expected)) {
                    return true;
                }
            }
        }
        catch (NumberFormatException e) {
            throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, number);
        }
        return false;
    }

    public static boolean areEqual(Value value, String expected) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Number) {
            return Values.areEqual((Number)object, expected);
        }
        if (object instanceof Date) {
            return Values.areEqual((Date)object, expected);
        }
        if (object instanceof Time) {
            return Values.areEqual((Time)object, expected);
        }
        if (object instanceof Timestamp) {
            return Values.areEqual((Timestamp)object, expected);
        }
        if (object instanceof UUID) {
            return Values.areEqual((UUID)object, expected);
        }
        return expected.equals(object);
    }

    public static boolean areEqual(Value value, UUID expected) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        return expected.equals(object);
    }

    public static boolean areEqual(UUID value, String expected) {
        if (expected == null) {
            return value == null;
        }
        try {
            return UUID.fromString(expected).equals(value);
        }
        catch (IllegalArgumentException e) {
            throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, value);
        }
    }

    public static boolean areEqual(Value value, DateValue expected) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            DateValue dateValue = DateValue.from(date);
            return dateValue.equals(expected);
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            return dateTimeValue.equals(DateTimeValue.of(expected));
        }
        return false;
    }

    public static boolean areEqual(Value value, TimeValue expected) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Time) {
            Time time = (Time)object;
            TimeValue timeValue = TimeValue.from(time);
            return timeValue.equals(expected);
        }
        return false;
    }

    public static boolean areEqual(Value value, DateTimeValue expected) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            DateTimeValue dateTimeValue = DateTimeValue.of(DateValue.from(date));
            return dateTimeValue.equals(expected);
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            return dateTimeValue.equals(expected);
        }
        return false;
    }

    public static int compare(Value value, Number expected) {
        Object object = value.getValue();
        if (expected instanceof BigInteger) {
            BigInteger bi;
            if (object instanceof BigInteger) {
                bi = (BigInteger)object;
            } else {
                try {
                    bi = new BigInteger("" + object);
                }
                catch (NumberFormatException e) {
                    throw new AssertJDBException("Expected <%s> can not be compared to a BigInteger (<%s>)", expected, object);
                }
            }
            return bi.compareTo((BigInteger)expected);
        }
        if (expected instanceof BigDecimal) {
            BigDecimal bd;
            if (object instanceof BigDecimal) {
                bd = (BigDecimal)object;
            } else {
                try {
                    bd = new BigDecimal("" + object);
                }
                catch (NumberFormatException e) {
                    throw new AssertJDBException("Expected <%s> can not be compared to a BigDecimal (<%s>)", expected, object);
                }
            }
            return bd.compareTo((BigDecimal)expected);
        }
        Long actualValue = null;
        if (object instanceof Float) {
            float expectedF;
            float f = ((Float)object).floatValue();
            if (f > (expectedF = expected.floatValue())) {
                return 1;
            }
            if (f < expectedF) {
                return -1;
            }
            return 0;
        }
        if (object instanceof Double) {
            double expectedD;
            double d = (Double)object;
            if (d > (expectedD = expected.doubleValue())) {
                return 1;
            }
            if (d < expectedD) {
                return -1;
            }
            return 0;
        }
        if (object instanceof BigInteger) {
            BigInteger bi = new BigInteger("" + expected);
            return ((BigInteger)object).compareTo(bi);
        }
        if (object instanceof BigDecimal) {
            BigDecimal bd = new BigDecimal("" + expected);
            return ((BigDecimal)object).compareTo(bd);
        }
        if (object instanceof Byte) {
            actualValue = ((Byte)object).longValue();
        } else if (object instanceof Short) {
            actualValue = ((Short)object).longValue();
        } else if (object instanceof Integer) {
            actualValue = ((Integer)object).longValue();
        } else if (object instanceof Long) {
            actualValue = (Long)object;
        }
        if (actualValue != null) {
            if (expected instanceof Float) {
                float expectedF = expected.floatValue();
                if ((float)actualValue.longValue() > expectedF) {
                    return 1;
                }
                if ((float)actualValue.longValue() < expectedF) {
                    return -1;
                }
                return 0;
            }
            if (expected instanceof Double) {
                double expectedD = expected.doubleValue();
                if ((double)actualValue.longValue() > expectedD) {
                    return 1;
                }
                if ((double)actualValue.longValue() < expectedD) {
                    return -1;
                }
                return 0;
            }
            double expectedL = expected.longValue();
            if ((double)actualValue.longValue() > expectedL) {
                return 1;
            }
            if ((double)actualValue.longValue() < expectedL) {
                return -1;
            }
            return 0;
        }
        throw new AssertJDBException("Expected <%s> can not be compared to a Number (<%s>)", expected, object);
    }

    public static Object[] getRepresentationsFromValuesInFrontOfExpected(Value[] values, Object[] expected) {
        Object[] representationsValues = new Object[values.length];
        int i = 0;
        for (Value obj : values) {
            representationsValues[i] = i >= expected.length ? obj.getValue() : Values.getRepresentationFromValueInFrontOfExpected(obj, expected[i]);
            ++i;
        }
        return representationsValues;
    }

    public static Object getRepresentationFromValueInFrontOfExpected(Value value, Object expected) {
        Object object = value.getValue();
        switch (value.getValueType()) {
            case DATE: {
                if (!(expected instanceof String)) break;
                if (((String)expected).contains("T")) {
                    return DateTimeValue.of(DateValue.from((Date)object)).toString();
                }
                return DateValue.from((Date)object).toString();
            }
        }
        return Values.getRepresentationFromValueInFrontOfClass(value, expected == null ? null : expected.getClass());
    }

    public static Object getRepresentationFromValueInFrontOfClass(Value value, Class clazz) {
        Object object = value.getValue();
        switch (value.getValueType()) {
            case DATE: {
                if (clazz == DateValue.class) {
                    return DateValue.from((Date)object);
                }
                if (clazz == DateTimeValue.class) {
                    return DateTimeValue.of(DateValue.from((Date)object));
                }
                if (clazz == String.class) {
                    return DateTimeValue.of(DateValue.from((Date)object)).toString();
                }
                return object;
            }
            case TIME: {
                if (clazz == String.class) {
                    return TimeValue.from((Time)object).toString();
                }
                return TimeValue.from((Time)object);
            }
            case DATE_TIME: {
                if (clazz == String.class) {
                    return DateTimeValue.from((Timestamp)object).toString();
                }
                return DateTimeValue.from((Timestamp)object);
            }
            case NUMBER: 
            case UUID: {
                if (clazz == String.class) {
                    return object.toString();
                }
                return object;
            }
        }
        return object;
    }

    public static boolean areClose(Value value, Number expected, Number tolerance) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (expected instanceof BigInteger) {
            BigInteger bi;
            if (object instanceof BigInteger) {
                bi = (BigInteger)object;
            } else {
                try {
                    bi = new BigInteger("" + object);
                }
                catch (NumberFormatException e) {
                    throw new AssertJDBException("Expected <%s> can not be compared to a BigInteger (<%s>)", expected, object);
                }
            }
            BigInteger bigExpected = (BigInteger)expected;
            BigInteger bigTolerance = new BigInteger("" + tolerance);
            BigInteger bigMin = bigExpected.subtract(bigTolerance);
            BigInteger bigMax = bigExpected.add(bigTolerance);
            if (bi.compareTo(bigMin) >= 0 && bi.compareTo(bigMax) <= 0) {
                return true;
            }
        } else if (expected instanceof BigDecimal) {
            BigDecimal bd;
            if (object instanceof BigDecimal) {
                bd = (BigDecimal)object;
            } else {
                try {
                    bd = new BigDecimal("" + object);
                }
                catch (NumberFormatException e) {
                    throw new AssertJDBException("Expected <%s> can not be compared to a BigDecimal (<%s>)", expected, object);
                }
            }
            BigDecimal bigExpected = (BigDecimal)expected;
            BigDecimal bigTolerance = new BigDecimal("" + tolerance);
            BigDecimal bigMin = bigExpected.subtract(bigTolerance);
            BigDecimal bigMax = bigExpected.add(bigTolerance);
            if (bd.compareTo(bigMin) >= 0 && bd.compareTo(bigMax) <= 0) {
                return true;
            }
        } else {
            Long actualValue = null;
            if (object instanceof Float) {
                Float f = (Float)object;
                float fMin = expected.floatValue() - tolerance.floatValue();
                float fMax = expected.floatValue() + tolerance.floatValue();
                if (f.floatValue() >= fMin && f.floatValue() <= fMax) {
                    return true;
                }
            } else if (object instanceof Double) {
                Double d = (Double)object;
                double dMin = expected.doubleValue() - tolerance.doubleValue();
                double dMax = expected.doubleValue() + tolerance.doubleValue();
                if (d >= dMin && d <= dMax) {
                    return true;
                }
            } else if (object instanceof BigInteger) {
                BigInteger bi = (BigInteger)object;
                BigInteger bigExpected = new BigInteger("" + expected);
                BigInteger bigTolerance = new BigInteger("" + tolerance);
                BigInteger bigMin = bigExpected.subtract(bigTolerance);
                BigInteger bigMax = bigExpected.add(bigTolerance);
                if (bi.compareTo(bigMin) >= 0 && bi.compareTo(bigMax) <= 0) {
                    return true;
                }
            } else if (object instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)object;
                BigDecimal bigExpected = new BigDecimal("" + expected);
                BigDecimal bigTolerance = new BigDecimal("" + tolerance);
                BigDecimal bigMin = bigExpected.subtract(bigTolerance);
                BigDecimal bigMax = bigExpected.add(bigTolerance);
                if (bd.compareTo(bigMin) >= 0 && bd.compareTo(bigMax) <= 0) {
                    return true;
                }
            } else if (object instanceof Byte) {
                actualValue = ((Byte)object).longValue();
            } else if (object instanceof Short) {
                actualValue = ((Short)object).longValue();
            } else if (object instanceof Integer) {
                actualValue = ((Integer)object).longValue();
            } else if (object instanceof Long) {
                actualValue = (Long)object;
            }
            if (actualValue != null && (expected instanceof Float ? (tolerance instanceof Float ? (float)actualValue.longValue() >= expected.floatValue() - tolerance.floatValue() && (float)actualValue.longValue() <= expected.floatValue() + tolerance.floatValue() : (tolerance instanceof Double ? (double)actualValue.longValue() >= (double)expected.floatValue() - tolerance.doubleValue() && (double)actualValue.longValue() <= (double)expected.floatValue() + tolerance.doubleValue() : (float)actualValue.longValue() >= expected.floatValue() - (float)tolerance.longValue() && (float)actualValue.longValue() <= expected.floatValue() + (float)tolerance.longValue())) : (expected instanceof Double ? (tolerance instanceof Float ? (double)actualValue.longValue() >= expected.doubleValue() - (double)tolerance.floatValue() && (double)actualValue.longValue() <= expected.doubleValue() + (double)tolerance.floatValue() : (tolerance instanceof Double ? (double)actualValue.longValue() >= expected.doubleValue() - tolerance.doubleValue() && (double)actualValue.longValue() <= expected.doubleValue() + tolerance.doubleValue() : (double)actualValue.longValue() >= expected.doubleValue() - (double)tolerance.longValue() && (double)actualValue.longValue() <= expected.doubleValue() + (double)tolerance.longValue())) : (tolerance instanceof Float ? (float)actualValue.longValue() >= (float)expected.longValue() - tolerance.floatValue() && (float)actualValue.longValue() <= (float)expected.longValue() + tolerance.floatValue() : (tolerance instanceof Double ? (double)actualValue.longValue() >= (double)expected.longValue() - tolerance.doubleValue() && (double)actualValue.longValue() <= (double)expected.longValue() + tolerance.doubleValue() : actualValue >= expected.longValue() - tolerance.longValue() && actualValue <= expected.longValue() + tolerance.longValue()))))) {
                return true;
            }
        }
        return false;
    }

    public static boolean areClose(Value value, DateValue expected, DateValue tolerance) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            DateValue dateValue = DateValue.from(date);
            DateValue dateValueMin = expected.move(tolerance.reverse());
            DateValue dateValueMax = expected.move(tolerance);
            return dateValue.compareTo(dateValueMin) >= 0 && dateValue.compareTo(dateValueMax) <= 0;
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            DateTimeValue dateTimeValueMin = DateTimeValue.of(expected).move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = DateTimeValue.of(expected).move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        return false;
    }

    public static boolean areClose(Value value, DateValue expected, TimeValue tolerance) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            DateTimeValue dateTimeValue = DateTimeValue.of(DateValue.from(date));
            DateTimeValue dateTimeValueMin = expected.move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = expected.move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            DateTimeValue dateTimeValueMin = DateTimeValue.of(expected).move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = DateTimeValue.of(expected).move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        return false;
    }

    public static boolean areClose(Value value, DateValue expected, DateTimeValue tolerance) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            DateTimeValue dateTimeValue = DateTimeValue.of(DateValue.from(date));
            DateTimeValue dateTimeValueMin = expected.move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = expected.move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            DateTimeValue dateTimeValueMin = DateTimeValue.of(expected).move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = DateTimeValue.of(expected).move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        return false;
    }

    public static boolean areClose(Value value, TimeValue expected, TimeValue tolerance) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Time) {
            Time time = (Time)object;
            TimeValue timeValue = TimeValue.from(time);
            TimeValue timeValueMin = expected.move(tolerance.reverse());
            TimeValue timeValueMax = expected.move(tolerance);
            return timeValue.compareTo(timeValueMin) >= 0 && timeValue.compareTo(timeValueMax) <= 0;
        }
        return false;
    }

    public static boolean areClose(Value value, DateTimeValue expected, DateValue tolerance) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            DateTimeValue dateTimeValue = DateTimeValue.of(DateValue.from(date));
            DateTimeValue dateTimeValueMin = expected.move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = expected.move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            DateTimeValue dateTimeValueMin = expected.move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = expected.move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        return false;
    }

    public static boolean areClose(Value value, DateTimeValue expected, TimeValue tolerance) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            DateTimeValue dateTimeValue = DateTimeValue.of(DateValue.from(date));
            DateTimeValue dateTimeValueMin = expected.move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = expected.move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            DateTimeValue dateTimeValueMin = expected.move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = expected.move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        return false;
    }

    public static boolean areClose(Value value, DateTimeValue expected, DateTimeValue tolerance) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            DateTimeValue dateTimeValue = DateTimeValue.of(DateValue.from(date));
            DateTimeValue dateTimeValueMin = expected.move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = expected.move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            DateTimeValue dateTimeValueMin = expected.move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = expected.move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        return false;
    }
}

