/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import java.util.List;
import java.util.UUID;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.api.AbstractColumnValueAssert;
import org.assertj.db.api.AbstractDbAssert;
import org.assertj.db.api.AbstractRowAssert;
import org.assertj.db.api.AbstractRowValueAssert;
import org.assertj.db.api.AbstractSubAssert;
import org.assertj.db.api.assertions.AssertOnColumnClass;
import org.assertj.db.api.assertions.AssertOnColumnContent;
import org.assertj.db.api.assertions.AssertOnColumnEquality;
import org.assertj.db.api.assertions.AssertOnColumnName;
import org.assertj.db.api.assertions.AssertOnColumnNullity;
import org.assertj.db.api.assertions.AssertOnColumnType;
import org.assertj.db.api.assertions.AssertOnNumberOfRows;
import org.assertj.db.api.assertions.impl.AssertionsOnColumnClass;
import org.assertj.db.api.assertions.impl.AssertionsOnColumnContent;
import org.assertj.db.api.assertions.impl.AssertionsOnColumnEquality;
import org.assertj.db.api.assertions.impl.AssertionsOnColumnName;
import org.assertj.db.api.assertions.impl.AssertionsOnColumnNullity;
import org.assertj.db.api.assertions.impl.AssertionsOnColumnType;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfRows;
import org.assertj.db.navigation.Position;
import org.assertj.db.navigation.element.ColumnElement;
import org.assertj.db.type.AbstractDbData;
import org.assertj.db.type.Column;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.TimeValue;
import org.assertj.db.type.Value;
import org.assertj.db.type.ValueType;
import org.assertj.db.util.Descriptions;

public abstract class AbstractColumnAssert<D extends AbstractDbData<D>, A extends AbstractDbAssert<D, A, C, CV, R, RV>, C extends AbstractColumnAssert<D, A, C, CV, R, RV>, CV extends AbstractColumnValueAssert<D, A, C, CV, R, RV>, R extends AbstractRowAssert<D, A, C, CV, R, RV>, RV extends AbstractRowValueAssert<D, A, C, CV, R, RV>>
extends AbstractSubAssert<D, A, C, CV, C, CV, R, RV>
implements ColumnElement,
AssertOnColumnClass<C>,
AssertOnColumnEquality<C>,
AssertOnColumnContent<C>,
AssertOnNumberOfRows<C>,
AssertOnColumnName<C>,
AssertOnColumnType<C>,
AssertOnColumnNullity<C> {
    protected final Position<C, CV, Value> valuePosition;
    private final Column column;

    AbstractColumnAssert(A originalDbAssert, Class<C> selfType, Class<CV> valueType, Column column) {
        super(originalDbAssert, selfType);
        this.column = column;
        this.valuePosition = new Position<C, CV, Value>((AbstractColumnAssert)selfType.cast(this), valueType){

            @Override
            protected String getDescription(int index) {
                return AbstractColumnAssert.this.getValueDescription(index);
            }
        };
    }

    @Override
    protected String getValueDescription(int index) {
        return Descriptions.getColumnValueDescription(this.info, index);
    }

    @Override
    protected Position<C, CV, Value> getValuePosition() {
        return this.valuePosition;
    }

    @Override
    protected List<Value> getValuesList() {
        return this.column.getValuesList();
    }

    @Override
    public C hasNumberOfRows(int expected) {
        return (C)((AbstractColumnAssert)AssertionsOnNumberOfRows.hasNumberOfRows((AbstractAssert)this.myself, this.info, this.column.getValuesList().size(), expected));
    }

    @Override
    public C hasNumberOfRowsGreaterThan(int expected) {
        return (C)((AbstractColumnAssert)AssertionsOnNumberOfRows.hasNumberOfRowsGreaterThan((AbstractAssert)this.myself, this.info, this.column.getValuesList().size(), expected));
    }

    @Override
    public C hasNumberOfRowsLessThan(int expected) {
        return (C)((AbstractColumnAssert)AssertionsOnNumberOfRows.hasNumberOfRowsLessThan((AbstractAssert)this.myself, this.info, this.column.getValuesList().size(), expected));
    }

    @Override
    public C hasNumberOfRowsGreaterThanOrEqualTo(int expected) {
        return (C)((AbstractColumnAssert)AssertionsOnNumberOfRows.hasNumberOfRowsGreaterThanOrEqualTo((AbstractAssert)this.myself, this.info, this.column.getValuesList().size(), expected));
    }

    @Override
    public C hasNumberOfRowsLessThanOrEqualTo(int expected) {
        return (C)((AbstractColumnAssert)AssertionsOnNumberOfRows.hasNumberOfRowsLessThanOrEqualTo((AbstractAssert)this.myself, this.info, this.column.getValuesList().size(), expected));
    }

    @Override
    public C isOfClass(Class<?> expected, boolean lenient) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnClass.isOfClass((AbstractAssert)this.myself, this.info, this.getValuesList(), expected, lenient));
    }

    @Override
    public C isOfType(ValueType expected, boolean lenient) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnType.isOfType((AbstractAssert)this.myself, this.info, this.getValuesList(), expected, lenient));
    }

    @Override
    public C isOfAnyTypeIn(ValueType ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnType.isOfAnyTypeIn((AbstractAssert)this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C isNumber(boolean lenient) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnType.isNumber((AbstractAssert)this.myself, this.info, this.getValuesList(), lenient));
    }

    @Override
    public C isBoolean(boolean lenient) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnType.isBoolean((AbstractAssert)this.myself, this.info, this.getValuesList(), lenient));
    }

    @Override
    public C isDate(boolean lenient) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnType.isDate((AbstractAssert)this.myself, this.info, this.getValuesList(), lenient));
    }

    @Override
    public C isTime(boolean lenient) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnType.isTime((AbstractAssert)this.myself, this.info, this.getValuesList(), lenient));
    }

    @Override
    public C isDateTime(boolean lenient) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnType.isDateTime((AbstractAssert)this.myself, this.info, this.getValuesList(), lenient));
    }

    @Override
    public C isBytes(boolean lenient) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnType.isBytes((AbstractAssert)this.myself, this.info, this.getValuesList(), lenient));
    }

    @Override
    public C isText(boolean lenient) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnType.isText((AbstractAssert)this.myself, this.info, this.getValuesList(), lenient));
    }

    @Override
    public C isUUID(boolean lenient) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnType.isUUID((AbstractAssert)this.myself, this.info, this.getValuesList(), lenient));
    }

    @Override
    public C hasOnlyNullValues() {
        return (C)((AbstractColumnAssert)AssertionsOnColumnNullity.hasOnlyNullValues((AbstractAssert)this.myself, this.info, this.getValuesList()));
    }

    @Override
    public C hasOnlyNotNullValues() {
        return (C)((AbstractColumnAssert)AssertionsOnColumnNullity.hasOnlyNotNullValues((AbstractAssert)this.myself, this.info, this.getValuesList()));
    }

    @Override
    public C hasValues(Object ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnEquality.hasValues((AbstractAssert)this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C hasValues(Boolean ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnEquality.hasValues((AbstractAssert)this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C hasValues(Number ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnEquality.hasValues((AbstractAssert)this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C hasValues(byte[] ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnEquality.hasValues((AbstractAssert)this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C hasValues(String ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnEquality.hasValues((AbstractAssert)this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C hasValues(UUID ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnEquality.hasValues((AbstractAssert)this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C hasValues(DateValue ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnEquality.hasValues((AbstractAssert)this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C hasValues(TimeValue ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnEquality.hasValues((AbstractAssert)this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C hasValues(DateTimeValue ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnEquality.hasValues((AbstractAssert)this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C containsValues(Object ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnContent.containsValues((AbstractAssert)this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C containsValues(Boolean ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnContent.containsValues((AbstractAssert)this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C containsValues(Number ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnContent.containsValues((AbstractAssert)this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C containsValues(byte[] ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnContent.containsValues((AbstractAssert)this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C containsValues(String ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnContent.containsValues((AbstractAssert)this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C containsValues(UUID ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnContent.containsValues((AbstractAssert)this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C containsValues(DateValue ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnContent.containsValues((AbstractAssert)this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C containsValues(TimeValue ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnContent.containsValues((AbstractAssert)this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C containsValues(DateTimeValue ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnContent.containsValues((AbstractAssert)this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C hasColumnName(String columnName) {
        String name = this.column.getName();
        return (C)((AbstractColumnAssert)AssertionsOnColumnName.hasColumnName((AbstractAssert)this.myself, this.info, name, columnName, this.column.getColumnLetterCase()));
    }
}

