/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import org.assertj.db.api.AbstractAssert;
import org.assertj.db.api.AbstractAssertWithOrigin;
import org.assertj.db.api.ChangeAssert;
import org.assertj.db.api.assertions.AssertOnNumberOfChanges;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfChanges;
import org.assertj.db.navigation.PositionWithChanges;
import org.assertj.db.navigation.element.ChangesElement;
import org.assertj.db.navigation.origin.OriginWithChanges;
import org.assertj.db.type.Change;
import org.assertj.db.type.ChangeType;
import org.assertj.db.type.Changes;
import org.assertj.db.util.Descriptions;

public class ChangesAssert
extends AbstractAssertWithOrigin<ChangesAssert, ChangesAssert>
implements ChangesElement,
OriginWithChanges<ChangesAssert, ChangeAssert>,
AssertOnNumberOfChanges<ChangesAssert> {
    private final Changes changes;
    private final PositionWithChanges<ChangesAssert, ChangeAssert> changesPosition;

    ChangesAssert(Changes changes) {
        this((ChangesAssert)null, changes);
    }

    public ChangesAssert(ChangesAssert origin, Changes changes) {
        super(ChangesAssert.class, origin);
        this.changes = changes;
        this.changesPosition = new PositionWithChanges(this, ChangesAssert.class, ChangeAssert.class){

            @Override
            protected String getChangesDescription(ChangeType changeType, String tableName) {
                return Descriptions.getChangesDescription(ChangesAssert.this.info, changeType, tableName);
            }

            @Override
            protected String getChangeDescription(Changes changes, Change change, int index, ChangeType changeType, String tableName) {
                return Descriptions.getChangeDescription(ChangesAssert.this.info, changes, change, index, changeType, tableName);
            }
        };
    }

    @Override
    public ChangesAssert ofAll() {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).ofAll();
        }
        return this;
    }

    @Override
    public ChangesAssert ofCreation() {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).ofCreation();
        }
        return this.changesPosition.getChangesInstance(this.changes, ChangeType.CREATION, null);
    }

    @Override
    public ChangesAssert ofModification() {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).ofModification();
        }
        return this.changesPosition.getChangesInstance(this.changes, ChangeType.MODIFICATION, null);
    }

    @Override
    public ChangesAssert ofDeletion() {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).ofDeletion();
        }
        return this.changesPosition.getChangesInstance(this.changes, ChangeType.DELETION, null);
    }

    @Override
    public ChangesAssert ofCreationOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).ofCreationOnTable(tableName);
        }
        return this.changesPosition.getChangesInstance(this.changes, ChangeType.CREATION, tableName);
    }

    @Override
    public ChangesAssert ofModificationOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).ofModificationOnTable(tableName);
        }
        return this.changesPosition.getChangesInstance(this.changes, ChangeType.MODIFICATION, tableName);
    }

    @Override
    public ChangesAssert ofDeletionOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).ofDeletionOnTable(tableName);
        }
        return this.changesPosition.getChangesInstance(this.changes, ChangeType.DELETION, tableName);
    }

    @Override
    public ChangesAssert onTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).onTable(tableName);
        }
        return this.changesPosition.getChangesInstance(this.changes, null, tableName);
    }

    @Override
    public ChangeAssert change() {
        return this.changesPosition.getChangeInstance(this.changes, null, null);
    }

    @Override
    public ChangeAssert change(int index) {
        return this.changesPosition.getChangeInstance(this.changes, null, null, index);
    }

    @Override
    public ChangeAssert changeOfCreation() {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfCreation();
        }
        return this.changesPosition.getChangeInstance(this.changes, ChangeType.CREATION, null);
    }

    @Override
    public ChangeAssert changeOfCreation(int index) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfCreation(index);
        }
        return this.changesPosition.getChangeInstance(this.changes, ChangeType.CREATION, null, index);
    }

    @Override
    public ChangeAssert changeOfModification() {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfModification();
        }
        return this.changesPosition.getChangeInstance(this.changes, ChangeType.MODIFICATION, null);
    }

    @Override
    public ChangeAssert changeOfModification(int index) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfModification(index);
        }
        return this.changesPosition.getChangeInstance(this.changes, ChangeType.MODIFICATION, null, index);
    }

    @Override
    public ChangeAssert changeOfDeletion() {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfDeletion();
        }
        return this.changesPosition.getChangeInstance(this.changes, ChangeType.DELETION, null);
    }

    @Override
    public ChangeAssert changeOfDeletion(int index) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfDeletion(index);
        }
        return this.changesPosition.getChangeInstance(this.changes, ChangeType.DELETION, null, index);
    }

    @Override
    public ChangeAssert changeOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOnTable(tableName);
        }
        return this.changesPosition.getChangeInstance(this.changes, null, tableName);
    }

    @Override
    public ChangeAssert changeOnTable(String tableName, int index) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOnTable(tableName, index);
        }
        return this.changesPosition.getChangeInstance(this.changes, null, tableName, index);
    }

    @Override
    public ChangeAssert changeOnTableWithPks(String tableName, Object ... pksValues) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOnTableWithPks(tableName, pksValues);
        }
        return this.changesPosition.getChangeInstanceWithPK(this.changes, tableName, pksValues);
    }

    @Override
    public ChangeAssert changeOfCreationOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfCreationOnTable(tableName);
        }
        return this.changesPosition.getChangeInstance(this.changes, ChangeType.CREATION, tableName);
    }

    @Override
    public ChangeAssert changeOfCreationOnTable(String tableName, int index) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfCreationOnTable(tableName, index);
        }
        return this.changesPosition.getChangeInstance(this.changes, ChangeType.CREATION, tableName, index);
    }

    @Override
    public ChangeAssert changeOfModificationOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfModificationOnTable(tableName);
        }
        return this.changesPosition.getChangeInstance(this.changes, ChangeType.MODIFICATION, tableName);
    }

    @Override
    public ChangeAssert changeOfModificationOnTable(String tableName, int index) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfModificationOnTable(tableName, index);
        }
        return this.changesPosition.getChangeInstance(this.changes, ChangeType.MODIFICATION, tableName, index);
    }

    @Override
    public ChangeAssert changeOfDeletionOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfDeletionOnTable(tableName);
        }
        return this.changesPosition.getChangeInstance(this.changes, ChangeType.DELETION, tableName);
    }

    @Override
    public ChangeAssert changeOfDeletionOnTable(String tableName, int index) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfDeletionOnTable(tableName, index);
        }
        return this.changesPosition.getChangeInstance(this.changes, ChangeType.DELETION, tableName, index);
    }

    @Override
    public ChangesAssert hasNumberOfChanges(int expected) {
        return (ChangesAssert)AssertionsOnNumberOfChanges.hasNumberOfChanges((AbstractAssert)this.myself, this.info, this.changes, expected);
    }

    @Override
    public ChangesAssert hasNumberOfChangesGreaterThan(int expected) {
        return (ChangesAssert)AssertionsOnNumberOfChanges.hasNumberOfChangesGreaterThan((AbstractAssert)this.myself, this.info, this.changes, expected);
    }

    @Override
    public ChangesAssert hasNumberOfChangesLessThan(int expected) {
        return (ChangesAssert)AssertionsOnNumberOfChanges.hasNumberOfChangesLessThan((AbstractAssert)this.myself, this.info, this.changes, expected);
    }

    @Override
    public ChangesAssert hasNumberOfChangesGreaterThanOrEqualTo(int expected) {
        return (ChangesAssert)AssertionsOnNumberOfChanges.hasNumberOfChangesGreaterThanOrEqualTo((AbstractAssert)this.myself, this.info, this.changes, expected);
    }

    @Override
    public ChangesAssert hasNumberOfChangesLessThanOrEqualTo(int expected) {
        return (ChangesAssert)AssertionsOnNumberOfChanges.hasNumberOfChangesLessThanOrEqualTo((AbstractAssert)this.myself, this.info, this.changes, expected);
    }
}

