/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.api.assertions.impl.AssertionsOnColumnType;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfRows;
import org.assertj.db.error.ShouldContainsValue;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.TimeValue;
import org.assertj.db.type.Value;
import org.assertj.db.type.ValueType;
import org.assertj.db.util.Values;

public class AssertionsOnColumnContent {
    private static final Failures failures = Failures.instance();

    private AssertionsOnColumnContent() {
    }

    public static <A extends AbstractAssert> A containsValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, Object ... expected) {
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        ArrayList<Value> list = new ArrayList<Value>(valuesList);
        int index = 0;
        for (Object val : expected) {
            boolean found = false;
            ArrayList<Value> newList = new ArrayList<Value>();
            for (Value obj : list) {
                if (found || !Values.areEqual(obj, val)) {
                    newList.add(obj);
                    continue;
                }
                found = true;
            }
            if (!found) {
                ArrayList<Object> listForError = new ArrayList<Object>();
                for (Value obj : valuesList) {
                    listForError.add(Values.getRepresentationFromValueInFrontOfExpected(obj, Object.class));
                }
                throw failures.failure((AssertionInfo)info, ShouldContainsValue.shouldContainsValue(listForError, expected, val, index));
            }
            list = newList;
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A containsValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, Boolean ... expected) {
        AssertionsOnColumnType.isBoolean(assertion, info, valuesList, true);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        ArrayList<Value> list = new ArrayList<Value>(valuesList);
        int index = 0;
        for (Boolean val : expected) {
            boolean found = false;
            ArrayList<Value> newList = new ArrayList<Value>();
            for (Value obj : list) {
                if (found || !Values.areEqual(obj, val)) {
                    newList.add(obj);
                    continue;
                }
                found = true;
            }
            if (!found) {
                ArrayList<Object> listForError = new ArrayList<Object>();
                for (Value obj : valuesList) {
                    listForError.add(Values.getRepresentationFromValueInFrontOfExpected(obj, Boolean.class));
                }
                throw failures.failure((AssertionInfo)info, ShouldContainsValue.shouldContainsValue(listForError, expected, val, index));
            }
            list = newList;
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A containsValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, Number ... expected) {
        AssertionsOnColumnType.isNumber(assertion, info, valuesList, true);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        ArrayList<Value> list = new ArrayList<Value>(valuesList);
        int index = 0;
        for (Number val : expected) {
            boolean found = false;
            ArrayList<Value> newList = new ArrayList<Value>();
            for (Value obj : list) {
                if (found || !Values.areEqual(obj, val)) {
                    newList.add(obj);
                    continue;
                }
                found = true;
            }
            if (!found) {
                ArrayList<Object> listForError = new ArrayList<Object>();
                for (Value obj : valuesList) {
                    listForError.add(Values.getRepresentationFromValueInFrontOfExpected(obj, Number.class));
                }
                throw failures.failure((AssertionInfo)info, ShouldContainsValue.shouldContainsValue(listForError, expected, val, index));
            }
            list = newList;
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A containsValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, byte[] ... expected) {
        AssertionsOnColumnType.isBytes(assertion, info, valuesList, true);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        ArrayList<Value> list = new ArrayList<Value>(valuesList);
        int index = 0;
        for (byte[] val : expected) {
            boolean found = false;
            ArrayList<Value> newList = new ArrayList<Value>();
            for (Value obj : list) {
                if (found || !Values.areEqual(obj, val)) {
                    newList.add(obj);
                    continue;
                }
                found = true;
            }
            if (!found) {
                ArrayList<Object> listForError = new ArrayList<Object>();
                for (Value obj : valuesList) {
                    listForError.add(Values.getRepresentationFromValueInFrontOfExpected(obj, byte[].class));
                }
                throw failures.failure((AssertionInfo)info, ShouldContainsValue.shouldContainsValue(index));
            }
            list = newList;
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A containsValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, String ... expected) {
        AssertionsOnColumnType.isOfAnyTypeIn(assertion, info, valuesList, ValueType.TEXT, ValueType.NUMBER, ValueType.DATE, ValueType.TIME, ValueType.DATE_TIME, ValueType.UUID, ValueType.NOT_IDENTIFIED);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        ArrayList<Value> list = new ArrayList<Value>(valuesList);
        int index = 0;
        for (String val : expected) {
            boolean found = false;
            ArrayList<Value> newList = new ArrayList<Value>();
            for (Value obj : list) {
                if (found || !Values.areEqual(obj, val)) {
                    newList.add(obj);
                    continue;
                }
                found = true;
            }
            if (!found) {
                ArrayList<Object> listForError = new ArrayList<Object>();
                for (Value obj : valuesList) {
                    listForError.add(Values.getRepresentationFromValueInFrontOfExpected(obj, String.class));
                }
                throw failures.failure((AssertionInfo)info, ShouldContainsValue.shouldContainsValue(listForError, expected, val, index));
            }
            list = newList;
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A containsValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, UUID ... expected) {
        AssertionsOnColumnType.isOfAnyTypeIn(assertion, info, valuesList, ValueType.UUID, ValueType.NOT_IDENTIFIED);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        ArrayList<Value> list = new ArrayList<Value>(valuesList);
        int index = 0;
        for (UUID val : expected) {
            boolean found = false;
            ArrayList<Value> newList = new ArrayList<Value>();
            for (Value obj : list) {
                if (found || !Values.areEqual(obj, val)) {
                    newList.add(obj);
                    continue;
                }
                found = true;
            }
            if (!found) {
                ArrayList<Object> listForError = new ArrayList<Object>();
                for (Value obj : valuesList) {
                    listForError.add(Values.getRepresentationFromValueInFrontOfExpected(obj, UUID.class));
                }
                throw failures.failure((AssertionInfo)info, ShouldContainsValue.shouldContainsValue(listForError, expected, val, index));
            }
            list = newList;
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A containsValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, DateValue ... expected) {
        AssertionsOnColumnType.isOfAnyTypeIn(assertion, info, valuesList, ValueType.DATE, ValueType.DATE_TIME, ValueType.NOT_IDENTIFIED);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        ArrayList<Value> list = new ArrayList<Value>(valuesList);
        int index = 0;
        for (DateValue val : expected) {
            boolean found = false;
            ArrayList<Value> newList = new ArrayList<Value>();
            for (Value obj : list) {
                if (found || !Values.areEqual(obj, val)) {
                    newList.add(obj);
                    continue;
                }
                found = true;
            }
            if (!found) {
                ArrayList<Object> listForError = new ArrayList<Object>();
                for (Value obj : valuesList) {
                    listForError.add(Values.getRepresentationFromValueInFrontOfExpected(obj, DateValue.class));
                }
                throw failures.failure((AssertionInfo)info, ShouldContainsValue.shouldContainsValue(listForError, expected, val, index));
            }
            list = newList;
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A containsValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, TimeValue ... expected) {
        AssertionsOnColumnType.isOfAnyTypeIn(assertion, info, valuesList, ValueType.TIME, ValueType.NOT_IDENTIFIED);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        ArrayList<Value> list = new ArrayList<Value>(valuesList);
        int index = 0;
        for (TimeValue val : expected) {
            boolean found = false;
            ArrayList<Value> newList = new ArrayList<Value>();
            for (Value obj : list) {
                if (found || !Values.areEqual(obj, val)) {
                    newList.add(obj);
                    continue;
                }
                found = true;
            }
            if (!found) {
                ArrayList<Object> listForError = new ArrayList<Object>();
                for (Value obj : valuesList) {
                    listForError.add(Values.getRepresentationFromValueInFrontOfExpected(obj, TimeValue.class));
                }
                throw failures.failure((AssertionInfo)info, ShouldContainsValue.shouldContainsValue(listForError, expected, val, index));
            }
            list = newList;
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A containsValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, DateTimeValue ... expected) {
        AssertionsOnColumnType.isOfAnyTypeIn(assertion, info, valuesList, ValueType.DATE, ValueType.DATE_TIME, ValueType.NOT_IDENTIFIED);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        ArrayList<Value> list = new ArrayList<Value>(valuesList);
        int index = 0;
        for (DateTimeValue val : expected) {
            boolean found = false;
            ArrayList<Value> newList = new ArrayList<Value>();
            for (Value obj : list) {
                if (found || !Values.areEqual(obj, val)) {
                    newList.add(obj);
                    continue;
                }
                found = true;
            }
            if (!found) {
                ArrayList<Object> listForError = new ArrayList<Object>();
                for (Value obj : valuesList) {
                    listForError.add(Values.getRepresentationFromValueInFrontOfExpected(obj, DateTimeValue.class));
                }
                throw failures.failure((AssertionInfo)info, ShouldContainsValue.shouldContainsValue(listForError, expected, val, index));
            }
            list = newList;
            ++index;
        }
        return assertion;
    }
}

