/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldContainsOnlyNotNull;
import org.assertj.db.error.ShouldContainsOnlyNull;
import org.assertj.db.type.Value;

public class AssertionsOnColumnNullity {
    private static final Failures failures = Failures.instance();

    private AssertionsOnColumnNullity() {
    }

    public static <A extends AbstractAssert> A hasOnlyNullValues(A assertion, WritableAssertionInfo info, List<Value> valuesList) {
        int index = 0;
        for (Value value : valuesList) {
            if (value.getValue() != null) {
                throw failures.failure((AssertionInfo)info, ShouldContainsOnlyNull.shouldContainsOnlyNull(index));
            }
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasOnlyNotNullValues(A assertion, WritableAssertionInfo info, List<Value> valuesList) {
        int index = 0;
        for (Value value : valuesList) {
            if (value.getValue() == null) {
                throw failures.failure((AssertionInfo)info, ShouldContainsOnlyNotNull.shouldContainsOnlyNotNull(index));
            }
            ++index;
        }
        return assertion;
    }
}

