/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldHaveColumnsSize;
import org.assertj.db.error.ShouldHaveColumnsSizeGreater;
import org.assertj.db.error.ShouldHaveColumnsSizeGreaterOrEqual;
import org.assertj.db.error.ShouldHaveColumnsSizeLess;
import org.assertj.db.error.ShouldHaveColumnsSizeLessOrEqual;

public class AssertionsOnNumberOfColumns {
    private static final Failures failures = Failures.instance();

    private AssertionsOnNumberOfColumns() {
    }

    public static <A extends AbstractAssert> A hasNumberOfColumns(A assertion, WritableAssertionInfo info, int size, int expected) {
        if (size != expected) {
            throw failures.failure((AssertionInfo)info, ShouldHaveColumnsSize.shouldHaveColumnsSize(size, expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasNumberOfColumnsGreaterThan(A assertion, WritableAssertionInfo info, int size, int expected) {
        if (size <= expected) {
            throw failures.failure((AssertionInfo)info, ShouldHaveColumnsSizeGreater.shouldHaveColumnsSizeGreater(size, expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasNumberOfColumnsLessThan(A assertion, WritableAssertionInfo info, int size, int expected) {
        if (size >= expected) {
            throw failures.failure((AssertionInfo)info, ShouldHaveColumnsSizeLess.shouldHaveColumnsSizeLess(size, expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasNumberOfColumnsGreaterThanOrEqualTo(A assertion, WritableAssertionInfo info, int size, int expected) {
        if (size < expected) {
            throw failures.failure((AssertionInfo)info, ShouldHaveColumnsSizeGreaterOrEqual.shouldHaveColumnsSizeGreaterOrEqual(size, expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasNumberOfColumnsLessThanOrEqualTo(A assertion, WritableAssertionInfo info, int size, int expected) {
        if (size > expected) {
            throw failures.failure((AssertionInfo)info, ShouldHaveColumnsSizeLessOrEqual.shouldHaveColumnsSizeLessOrEqual(size, expected));
        }
        return assertion;
    }
}

