/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldHaveRowsSize;
import org.assertj.db.error.ShouldHaveRowsSizeGreater;
import org.assertj.db.error.ShouldHaveRowsSizeGreaterOrEqual;
import org.assertj.db.error.ShouldHaveRowsSizeLess;
import org.assertj.db.error.ShouldHaveRowsSizeLessOrEqual;

public class AssertionsOnNumberOfRows {
    private static final Failures failures = Failures.instance();

    private AssertionsOnNumberOfRows() {
    }

    public static <A extends AbstractAssert> A hasNumberOfRows(A assertion, WritableAssertionInfo info, int size, int expected) {
        if (size != expected) {
            throw failures.failure((AssertionInfo)info, ShouldHaveRowsSize.shouldHaveRowsSize(size, expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasNumberOfRowsGreaterThan(A assertion, WritableAssertionInfo info, int size, int expected) {
        if (size <= expected) {
            throw failures.failure((AssertionInfo)info, ShouldHaveRowsSizeGreater.shouldHaveRowsSizeGreater(size, expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasNumberOfRowsLessThan(A assertion, WritableAssertionInfo info, int size, int expected) {
        if (size >= expected) {
            throw failures.failure((AssertionInfo)info, ShouldHaveRowsSizeLess.shouldHaveRowsSizeLess(size, expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasNumberOfRowsGreaterThanOrEqualTo(A assertion, WritableAssertionInfo info, int size, int expected) {
        if (size < expected) {
            throw failures.failure((AssertionInfo)info, ShouldHaveRowsSizeGreaterOrEqual.shouldHaveRowsSizeGreaterOrEqual(size, expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasNumberOfRowsLessThanOrEqualTo(A assertion, WritableAssertionInfo info, int size, int expected) {
        if (size > expected) {
            throw failures.failure((AssertionInfo)info, ShouldHaveRowsSizeLessOrEqual.shouldHaveRowsSizeLessOrEqual(size, expected));
        }
        return assertion;
    }
}

