/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.api.assertions.impl.AssertionsOnValueType;
import org.assertj.db.error.ShouldBeAfter;
import org.assertj.db.error.ShouldBeAfterOrEqual;
import org.assertj.db.error.ShouldBeBefore;
import org.assertj.db.error.ShouldBeBeforeOrEqual;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.TimeValue;
import org.assertj.db.type.Value;
import org.assertj.db.type.ValueType;
import org.assertj.db.util.Values;

public class AssertionsOnValueChronology {
    private static final Failures failures = Failures.instance();

    private AssertionsOnValueChronology() {
    }

    public static <A extends AbstractAssert> A isBefore(A assertion, WritableAssertionInfo info, Value value, DateValue date) {
        Object object = value.getValue();
        AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.DATE_TIME);
        if (object instanceof Date) {
            DateValue dateValue = DateValue.from((Date)object);
            if (dateValue.isBefore(date)) {
                return assertion;
            }
            throw failures.failure((AssertionInfo)info, ShouldBeBefore.shouldBeBefore(dateValue, date));
        }
        DateTimeValue dateTimeValue = DateTimeValue.of(date);
        if (DateTimeValue.from((Timestamp)object).isBefore(dateTimeValue)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeBefore.shouldBeBefore(DateTimeValue.from((Timestamp)object), dateTimeValue));
    }

    public static <A extends AbstractAssert> A isBefore(A assertion, WritableAssertionInfo info, Value value, TimeValue time) {
        Object object = value.getValue();
        AssertionsOnValueType.isTime(assertion, info, value);
        if (TimeValue.from((Time)object).isBefore(time)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeBefore.shouldBeBefore(TimeValue.from((Time)object), time));
    }

    public static <A extends AbstractAssert> A isBefore(A assertion, WritableAssertionInfo info, Value value, DateTimeValue dateTime) {
        Object object = value.getValue();
        AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.DATE_TIME);
        DateTimeValue dateTimeValue = object instanceof Date ? DateTimeValue.of(DateValue.from((Date)object)) : DateTimeValue.from((Timestamp)object);
        if (dateTimeValue.isBefore(dateTime)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeBefore.shouldBeBefore(dateTimeValue, dateTime));
    }

    public static <A extends AbstractAssert> A isBefore(A assertion, WritableAssertionInfo info, Value value, String expected) {
        Object object = value.getValue();
        AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.TIME, ValueType.DATE_TIME);
        if (object instanceof Time) {
            TimeValue timeValue = TimeValue.from((Time)object);
            try {
                TimeValue expectedTimeValue = TimeValue.parse(expected);
                if (timeValue.isBefore(expectedTimeValue)) {
                    return assertion;
                }
                throw failures.failure((AssertionInfo)info, ShouldBeBefore.shouldBeBefore(timeValue, expectedTimeValue));
            }
            catch (ParseException e) {
                throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, timeValue);
            }
        }
        DateTimeValue dateTimeValue = object instanceof Date ? DateTimeValue.of(DateValue.from((Date)object)) : DateTimeValue.from((Timestamp)object);
        try {
            DateTimeValue expectedDateTimeValue = DateTimeValue.parse(expected);
            if (dateTimeValue.isBefore(expectedDateTimeValue)) {
                return assertion;
            }
            throw failures.failure((AssertionInfo)info, ShouldBeBefore.shouldBeBefore(dateTimeValue, expectedDateTimeValue));
        }
        catch (ParseException e) {
            throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, dateTimeValue);
        }
    }

    public static <A extends AbstractAssert> A isBeforeOrEqualTo(A assertion, WritableAssertionInfo info, Value value, DateValue date) {
        Object object = value.getValue();
        AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.DATE_TIME);
        if (object instanceof Date) {
            if (DateValue.from((Date)object).isBefore(date) || Values.areEqual(value, date)) {
                return assertion;
            }
            throw failures.failure((AssertionInfo)info, ShouldBeBeforeOrEqual.shouldBeBeforeOrEqual(DateValue.from((Date)object), date));
        }
        DateTimeValue dateTimeValue = DateTimeValue.of(date);
        if (DateTimeValue.from((Timestamp)object).isBefore(dateTimeValue) || Values.areEqual(value, dateTimeValue)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeBeforeOrEqual.shouldBeBeforeOrEqual(DateTimeValue.from((Timestamp)object), dateTimeValue));
    }

    public static <A extends AbstractAssert> A isBeforeOrEqualTo(A assertion, WritableAssertionInfo info, Value value, TimeValue time) {
        Object object = value.getValue();
        AssertionsOnValueType.isTime(assertion, info, value);
        if (TimeValue.from((Time)object).isBefore(time) || Values.areEqual(value, time)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeBeforeOrEqual.shouldBeBeforeOrEqual(TimeValue.from((Time)object), time));
    }

    public static <A extends AbstractAssert> A isBeforeOrEqualTo(A assertion, WritableAssertionInfo info, Value value, DateTimeValue dateTime) {
        Object object = value.getValue();
        AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.DATE_TIME);
        DateTimeValue dateTimeValue = object instanceof Date ? DateTimeValue.of(DateValue.from((Date)object)) : DateTimeValue.from((Timestamp)object);
        if (dateTimeValue.isBefore(dateTime) || Values.areEqual(value, dateTime)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeBeforeOrEqual.shouldBeBeforeOrEqual(dateTimeValue, dateTime));
    }

    public static <A extends AbstractAssert> A isBeforeOrEqualTo(A assertion, WritableAssertionInfo info, Value value, String expected) {
        Object object = value.getValue();
        AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.TIME, ValueType.DATE_TIME);
        if (object instanceof Time) {
            TimeValue timeValue = TimeValue.from((Time)object);
            try {
                TimeValue expectedTimeValue = TimeValue.parse(expected);
                if (timeValue.isBefore(expectedTimeValue) || Values.areEqual(value, expected)) {
                    return assertion;
                }
                throw failures.failure((AssertionInfo)info, ShouldBeBeforeOrEqual.shouldBeBeforeOrEqual(timeValue, expectedTimeValue));
            }
            catch (ParseException e) {
                throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, timeValue);
            }
        }
        DateTimeValue dateTimeValue = object instanceof Date ? DateTimeValue.of(DateValue.from((Date)object)) : DateTimeValue.from((Timestamp)object);
        try {
            DateTimeValue expectedDateTimeValue = DateTimeValue.parse(expected);
            if (dateTimeValue.isBefore(expectedDateTimeValue) || Values.areEqual(value, expected)) {
                return assertion;
            }
            throw failures.failure((AssertionInfo)info, ShouldBeBeforeOrEqual.shouldBeBeforeOrEqual(dateTimeValue, expectedDateTimeValue));
        }
        catch (ParseException e) {
            throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, dateTimeValue);
        }
    }

    public static <A extends AbstractAssert> A isAfter(A assertion, WritableAssertionInfo info, Value value, DateValue date) {
        Object object = value.getValue();
        AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.DATE_TIME);
        if (object instanceof Date) {
            if (DateValue.from((Date)object).isAfter(date)) {
                return assertion;
            }
            throw failures.failure((AssertionInfo)info, ShouldBeAfter.shouldBeAfter(DateValue.from((Date)object), date));
        }
        DateTimeValue dateTimeValue = DateTimeValue.of(date);
        if (DateTimeValue.from((Timestamp)object).isAfter(dateTimeValue)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeAfter.shouldBeAfter(DateTimeValue.from((Timestamp)object), dateTimeValue));
    }

    public static <A extends AbstractAssert> A isAfter(A assertion, WritableAssertionInfo info, Value value, TimeValue time) {
        Object object = value.getValue();
        AssertionsOnValueType.isTime(assertion, info, value);
        if (TimeValue.from((Time)object).isAfter(time)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeAfter.shouldBeAfter(TimeValue.from((Time)object), time));
    }

    public static <A extends AbstractAssert> A isAfter(A assertion, WritableAssertionInfo info, Value value, DateTimeValue dateTime) {
        Object object = value.getValue();
        AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.DATE_TIME);
        DateTimeValue dateTimeValue = object instanceof Date ? DateTimeValue.of(DateValue.from((Date)object)) : DateTimeValue.from((Timestamp)object);
        if (dateTimeValue.isAfter(dateTime)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeAfter.shouldBeAfter(dateTimeValue, dateTime));
    }

    public static <A extends AbstractAssert> A isAfter(A assertion, WritableAssertionInfo info, Value value, String expected) {
        Object object = value.getValue();
        AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.TIME, ValueType.DATE_TIME);
        if (object instanceof Time) {
            TimeValue timeValue = TimeValue.from((Time)object);
            try {
                TimeValue expectedTimeValue = TimeValue.parse(expected);
                if (timeValue.isAfter(expectedTimeValue)) {
                    return assertion;
                }
                throw failures.failure((AssertionInfo)info, ShouldBeAfter.shouldBeAfter(timeValue, expectedTimeValue));
            }
            catch (ParseException e) {
                throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, timeValue);
            }
        }
        DateTimeValue dateTimeValue = object instanceof Date ? DateTimeValue.of(DateValue.from((Date)object)) : DateTimeValue.from((Timestamp)object);
        try {
            DateTimeValue expectedDateTimeValue = DateTimeValue.parse(expected);
            if (dateTimeValue.isAfter(expectedDateTimeValue)) {
                return assertion;
            }
            throw failures.failure((AssertionInfo)info, ShouldBeAfter.shouldBeAfter(dateTimeValue, expectedDateTimeValue));
        }
        catch (ParseException e) {
            throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, dateTimeValue);
        }
    }

    public static <A extends AbstractAssert> A isAfterOrEqualTo(A assertion, WritableAssertionInfo info, Value value, DateValue date) {
        Object object = value.getValue();
        AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.DATE_TIME);
        if (object instanceof Date) {
            if (DateValue.from((Date)object).isAfter(date) || Values.areEqual(value, date)) {
                return assertion;
            }
            throw failures.failure((AssertionInfo)info, ShouldBeAfterOrEqual.shouldBeAfterOrEqual(DateValue.from((Date)object), date));
        }
        DateTimeValue dateTimeValue = DateTimeValue.of(date);
        if (DateTimeValue.from((Timestamp)object).isAfter(dateTimeValue) || Values.areEqual(value, date)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeAfterOrEqual.shouldBeAfterOrEqual(DateTimeValue.from((Timestamp)object), dateTimeValue));
    }

    public static <A extends AbstractAssert> A isAfterOrEqualTo(A assertion, WritableAssertionInfo info, Value value, TimeValue time) {
        Object object = value.getValue();
        AssertionsOnValueType.isTime(assertion, info, value);
        if (TimeValue.from((Time)object).isAfter(time) || Values.areEqual(value, time)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeAfterOrEqual.shouldBeAfterOrEqual(TimeValue.from((Time)object), time));
    }

    public static <A extends AbstractAssert> A isAfterOrEqualTo(A assertion, WritableAssertionInfo info, Value value, DateTimeValue dateTime) {
        Object object = value.getValue();
        AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.DATE_TIME);
        DateTimeValue dateTimeValue = object instanceof Date ? DateTimeValue.of(DateValue.from((Date)object)) : DateTimeValue.from((Timestamp)object);
        if (dateTimeValue.isAfter(dateTime) || Values.areEqual(value, dateTime)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeAfterOrEqual.shouldBeAfterOrEqual(dateTimeValue, dateTime));
    }

    public static <A extends AbstractAssert> A isAfterOrEqualTo(A assertion, WritableAssertionInfo info, Value value, String expected) {
        Object object = value.getValue();
        AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.TIME, ValueType.DATE_TIME);
        if (object instanceof Time) {
            TimeValue timeValue = TimeValue.from((Time)object);
            try {
                TimeValue expectedTimeValue = TimeValue.parse(expected);
                if (timeValue.isAfter(expectedTimeValue) || Values.areEqual(value, expected)) {
                    return assertion;
                }
                throw failures.failure((AssertionInfo)info, ShouldBeAfterOrEqual.shouldBeAfterOrEqual(timeValue, expectedTimeValue));
            }
            catch (ParseException e) {
                throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, timeValue);
            }
        }
        DateTimeValue dateTimeValue = object instanceof Date ? DateTimeValue.of(DateValue.from((Date)object)) : DateTimeValue.from((Timestamp)object);
        try {
            DateTimeValue expectedDateTimeValue = DateTimeValue.parse(expected);
            if (dateTimeValue.isAfter(expectedDateTimeValue) || Values.areEqual(value, expected)) {
                return assertion;
            }
            throw failures.failure((AssertionInfo)info, ShouldBeAfterOrEqual.shouldBeAfterOrEqual(dateTimeValue, expectedDateTimeValue));
        }
        catch (ParseException e) {
            throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, dateTimeValue);
        }
    }
}

