/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.api.assertions.impl.AssertionsOnValueType;
import org.assertj.db.error.ShouldBeClose;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.TimeValue;
import org.assertj.db.type.Value;
import org.assertj.db.type.ValueType;
import org.assertj.db.util.Values;

public class AssertionsOnValueCloseness {
    private static final Failures failures = Failures.instance();

    private AssertionsOnValueCloseness() {
    }

    public static <A extends AbstractAssert> A isCloseTo(A assertion, WritableAssertionInfo info, Value value, Number expected, Number tolerance) {
        if (expected != null) {
            AssertionsOnValueType.isNumber(assertion, info, value);
        }
        if (Values.areClose(value, expected, tolerance)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeClose.shouldBeClose(value.getValue(), expected, tolerance));
    }

    public static <A extends AbstractAssert> A isCloseTo(A assertion, WritableAssertionInfo info, Value value, DateValue expected, DateValue tolerance) {
        if (expected != null) {
            AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.DATE_TIME);
        }
        if (Values.areClose(value, expected, tolerance)) {
            return assertion;
        }
        Object object = value.getValue();
        if (value.getValueType() == ValueType.DATE) {
            throw failures.failure((AssertionInfo)info, ShouldBeClose.shouldBeClose(DateValue.from((Date)object), expected, tolerance));
        }
        if (expected != null) {
            throw failures.failure((AssertionInfo)info, ShouldBeClose.shouldBeClose(DateTimeValue.from((Timestamp)object), DateTimeValue.of(expected), tolerance));
        }
        throw failures.failure((AssertionInfo)info, ShouldBeClose.shouldBeClose(DateTimeValue.from((Timestamp)object), null, tolerance));
    }

    public static <A extends AbstractAssert> A isCloseTo(A assertion, WritableAssertionInfo info, Value value, DateValue expected, TimeValue tolerance) {
        if (expected != null) {
            AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.DATE_TIME);
        }
        if (Values.areClose(value, expected, tolerance)) {
            return assertion;
        }
        Object object = value.getValue();
        if (value.getValueType() == ValueType.DATE) {
            throw failures.failure((AssertionInfo)info, ShouldBeClose.shouldBeClose(DateValue.from((Date)object), expected, tolerance));
        }
        if (expected != null) {
            throw failures.failure((AssertionInfo)info, ShouldBeClose.shouldBeClose(DateTimeValue.from((Timestamp)object), DateTimeValue.of(expected), tolerance));
        }
        throw failures.failure((AssertionInfo)info, ShouldBeClose.shouldBeClose(DateTimeValue.from((Timestamp)object), null, tolerance));
    }

    public static <A extends AbstractAssert> A isCloseTo(A assertion, WritableAssertionInfo info, Value value, DateValue expected, DateTimeValue tolerance) {
        if (expected != null) {
            AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.DATE_TIME);
        }
        if (Values.areClose(value, expected, tolerance)) {
            return assertion;
        }
        Object object = value.getValue();
        if (value.getValueType() == ValueType.DATE) {
            throw failures.failure((AssertionInfo)info, ShouldBeClose.shouldBeClose(DateValue.from((Date)object), expected, tolerance));
        }
        if (expected != null) {
            throw failures.failure((AssertionInfo)info, ShouldBeClose.shouldBeClose(DateTimeValue.from((Timestamp)object), DateTimeValue.of(expected), tolerance));
        }
        throw failures.failure((AssertionInfo)info, ShouldBeClose.shouldBeClose(DateTimeValue.from((Timestamp)object), null, tolerance));
    }

    public static <A extends AbstractAssert> A isCloseTo(A assertion, WritableAssertionInfo info, Value value, TimeValue expected, TimeValue tolerance) {
        if (expected != null) {
            AssertionsOnValueType.isTime(assertion, info, value);
        }
        if (Values.areClose(value, expected, tolerance)) {
            return assertion;
        }
        Object object = value.getValue();
        throw failures.failure((AssertionInfo)info, ShouldBeClose.shouldBeClose(TimeValue.from((Time)object), expected, tolerance));
    }

    public static <A extends AbstractAssert> A isCloseTo(A assertion, WritableAssertionInfo info, Value value, DateTimeValue expected, DateValue tolerance) {
        if (expected != null) {
            AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.DATE_TIME);
        }
        if (Values.areClose(value, expected, tolerance)) {
            return assertion;
        }
        Object object = value.getValue();
        if (value.getValueType() == ValueType.DATE) {
            throw failures.failure((AssertionInfo)info, ShouldBeClose.shouldBeClose(DateTimeValue.of(DateValue.from((Date)object)), expected, tolerance));
        }
        throw failures.failure((AssertionInfo)info, ShouldBeClose.shouldBeClose(DateTimeValue.from((Timestamp)object), expected, tolerance));
    }

    public static <A extends AbstractAssert> A isCloseTo(A assertion, WritableAssertionInfo info, Value value, DateTimeValue expected, TimeValue tolerance) {
        if (expected != null) {
            AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.DATE_TIME);
        }
        if (Values.areClose(value, expected, tolerance)) {
            return assertion;
        }
        Object object = value.getValue();
        if (value.getValueType() == ValueType.DATE) {
            throw failures.failure((AssertionInfo)info, ShouldBeClose.shouldBeClose(DateTimeValue.of(DateValue.from((Date)object)), expected, tolerance));
        }
        throw failures.failure((AssertionInfo)info, ShouldBeClose.shouldBeClose(DateTimeValue.from((Timestamp)object), expected, tolerance));
    }

    public static <A extends AbstractAssert> A isCloseTo(A assertion, WritableAssertionInfo info, Value value, DateTimeValue expected, DateTimeValue tolerance) {
        if (expected != null) {
            AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.DATE_TIME);
        }
        if (Values.areClose(value, expected, tolerance)) {
            return assertion;
        }
        Object object = value.getValue();
        if (value.getValueType() == ValueType.DATE) {
            throw failures.failure((AssertionInfo)info, ShouldBeClose.shouldBeClose(DateTimeValue.of(DateValue.from((Date)object)), expected, tolerance));
        }
        throw failures.failure((AssertionInfo)info, ShouldBeClose.shouldBeClose(DateTimeValue.from((Timestamp)object), expected, tolerance));
    }
}

