/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldBeValueType;
import org.assertj.db.error.ShouldBeValueTypeOfAny;
import org.assertj.db.type.Value;
import org.assertj.db.type.ValueType;

public class AssertionsOnValueType {
    private static final Failures failures = Failures.instance();

    private AssertionsOnValueType() {
    }

    public static <A extends AbstractAssert> A isOfType(A assertion, WritableAssertionInfo info, Value value, ValueType expected) {
        ValueType type = value.getValueType();
        if (type != expected) {
            throw failures.failure((AssertionInfo)info, ShouldBeValueType.shouldBeValueType(value, type, expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A isOfAnyTypeIn(A assertion, WritableAssertionInfo info, Value value, ValueType ... expected) {
        ValueType type = value.getValueType();
        for (ValueType valueType : expected) {
            if (type != valueType) continue;
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeValueTypeOfAny.shouldBeValueTypeOfAny(value, type, expected));
    }

    public static <A extends AbstractAssert> A isNumber(A assertion, WritableAssertionInfo info, Value value) {
        return AssertionsOnValueType.isOfType(assertion, info, value, ValueType.NUMBER);
    }

    public static <A extends AbstractAssert> A isBoolean(A assertion, WritableAssertionInfo info, Value value) {
        return AssertionsOnValueType.isOfType(assertion, info, value, ValueType.BOOLEAN);
    }

    public static <A extends AbstractAssert> A isDate(A assertion, WritableAssertionInfo info, Value value) {
        return AssertionsOnValueType.isOfType(assertion, info, value, ValueType.DATE);
    }

    public static <A extends AbstractAssert> A isTime(A assertion, WritableAssertionInfo info, Value value) {
        return AssertionsOnValueType.isOfType(assertion, info, value, ValueType.TIME);
    }

    public static <A extends AbstractAssert> A isDateTime(A assertion, WritableAssertionInfo info, Value value) {
        return AssertionsOnValueType.isOfType(assertion, info, value, ValueType.DATE_TIME);
    }

    public static <A extends AbstractAssert> A isBytes(A assertion, WritableAssertionInfo info, Value value) {
        return AssertionsOnValueType.isOfType(assertion, info, value, ValueType.BYTES);
    }

    public static <A extends AbstractAssert> A isText(A assertion, WritableAssertionInfo info, Value value) {
        return AssertionsOnValueType.isOfType(assertion, info, value, ValueType.TEXT);
    }

    public static <A extends AbstractAssert> A isUUID(A assertion, WritableAssertionInfo info, Value value) {
        return AssertionsOnValueType.isOfType(assertion, info, value, ValueType.UUID);
    }
}

