/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.error;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.db.type.Value;
import org.assertj.db.type.ValueType;

public class ShouldBeValueTypeOfAny
extends BasicErrorMessageFactory {
    private static final String EXPECTED_MESSAGE = "%nExpecting:%n  <%s>%nto be of type%n  <%s>%nbut was of type%n  <%s>";
    private static final String EXPECTED_MESSAGE_WITH_INDEX = "%nExpecting that the value at index %s:%n  <%s>%nto be of type%n  <%s>%nbut was of type%n  <%s>";
    private static final String EXPECTED_MESSAGE_NOT_IDENTIFIED = "%nExpecting:%n  <%s>%nto be of type%n  <%s>%nbut was of type%n  <%s> (%s)";
    private static final String EXPECTED_MESSAGE_NOT_IDENTIFIED_WITH_INDEX = "%nExpecting that the value at index %s:%n  <%s>%nto be of type%n  <%s>%nbut was of type%n  <%s> (%s)";

    public static ErrorMessageFactory shouldBeValueTypeOfAny(Value actual, ValueType tested, ValueType ... expected) {
        if (actual.getValue() != null && tested == ValueType.NOT_IDENTIFIED) {
            return new ShouldBeValueTypeOfAny(actual, actual.getValue().getClass(), tested, expected);
        }
        return new ShouldBeValueTypeOfAny(actual, tested, expected);
    }

    public static ErrorMessageFactory shouldBeValueTypeOfAny(int index, Value actual, ValueType tested, ValueType ... expected) {
        if (actual.getValue() != null && tested == ValueType.NOT_IDENTIFIED) {
            return new ShouldBeValueTypeOfAny(index, actual, actual.getValue().getClass(), tested, expected);
        }
        return new ShouldBeValueTypeOfAny(index, actual, tested, expected);
    }

    private ShouldBeValueTypeOfAny(Value actual, ValueType tested, ValueType ... expected) {
        super(EXPECTED_MESSAGE, new Object[]{actual.getValue(), expected, tested});
    }

    private ShouldBeValueTypeOfAny(int index, Value actual, ValueType tested, ValueType ... expected) {
        super(EXPECTED_MESSAGE_WITH_INDEX, new Object[]{index, actual.getValue(), expected, tested});
    }

    private ShouldBeValueTypeOfAny(Value actual, Class classOfActual, ValueType tested, ValueType ... expected) {
        super(EXPECTED_MESSAGE_NOT_IDENTIFIED, new Object[]{actual.getValue(), expected, tested, classOfActual});
    }

    private ShouldBeValueTypeOfAny(int index, Value actual, Class classOfActual, ValueType tested, ValueType ... expected) {
        super(EXPECTED_MESSAGE_NOT_IDENTIFIED_WITH_INDEX, new Object[]{index, actual.getValue(), expected, tested, classOfActual});
    }
}

