/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.navigation;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.global.AbstractElement;
import org.assertj.db.type.Change;
import org.assertj.db.type.Row;
import org.assertj.db.type.Value;
import org.assertj.db.type.lettercase.CaseComparison;
import org.assertj.db.util.Changes;
import org.assertj.db.util.NameComparator;

public abstract class PositionWithColumnsChange<E extends AbstractElement, N extends AbstractElement> {
    private final E myself;
    private int nextIndex;
    private final Class<N> elementClass;
    private final Map<Integer, N> elementsMap = new HashMap<Integer, N>();

    public PositionWithColumnsChange(E myself, Class<N> elementClass) {
        this.myself = myself;
        this.elementClass = elementClass;
    }

    public N getChangeColumnInstance(Change change) {
        return this.getChangeColumnInstance(change, this.nextIndex);
    }

    public N getChangeColumnInstance(Change change, int index) {
        Value valueAtEndPoint;
        Value valueAtStartPoint;
        if (this.elementsMap.containsKey(index)) {
            AbstractElement instance = (AbstractElement)this.elementsMap.get(index);
            this.nextIndex = index + 1;
            return (N)instance;
        }
        int size = change.getColumnsNameList().size();
        if (index < 0 || index >= size) {
            throw new AssertJDBException("Index %s out of the limits [0, %s[", index, size);
        }
        List<String> columnsNameList = change.getColumnsNameList();
        String columnName = columnsNameList.get(index);
        Row rowAtStartPoint = change.getRowAtStartPoint();
        Row rowAtEndPoint = change.getRowAtEndPoint();
        if (rowAtStartPoint != null) {
            List<Value> valuesAtStartPoint = rowAtStartPoint.getValuesList();
            valueAtStartPoint = valuesAtStartPoint.get(index);
        } else {
            valueAtStartPoint = Value.getNullValue(columnName, change.getColumnLetterCase());
        }
        if (rowAtEndPoint != null) {
            List<Value> valuesAtEndPoint = rowAtEndPoint.getValuesList();
            valueAtEndPoint = valuesAtEndPoint.get(index);
        } else {
            valueAtEndPoint = Value.getNullValue(columnName, change.getColumnLetterCase());
        }
        try {
            Constructor<N> constructor = this.elementClass.getDeclaredConstructor(this.myself.getClass(), String.class, Value.class, Value.class);
            AbstractElement instance = (AbstractElement)constructor.newInstance(this.myself, columnName, valueAtStartPoint, valueAtEndPoint);
            this.elementsMap.put(index, instance);
            this.nextIndex = index + 1;
            instance.as(this.getDescription(index, columnName), new Object[0]);
            return (N)instance;
        }
        catch (Exception e) {
            throw new AssertJDBException(String.format("There is an exception '" + e.getMessage() + "'%n\t in the instantiation of the element " + this.elementClass.getName() + "%n\t " + " with " + this.myself.getClass() + ".%n " + "It is normally impossible.%n That means there is a big mistake in the development of AssertJDB.%n " + "Please write an issue for that if you meet this problem.", new Object[0]), new Object[0]);
        }
    }

    public N getChangeColumnInstance(Change change, String columnName, CaseComparison comparison) {
        if (columnName == null) {
            throw new NullPointerException("Column name must be not null");
        }
        List<String> columnsNameList = change.getColumnsNameList();
        int index = NameComparator.INSTANCE.indexOf(columnsNameList, columnName, comparison);
        if (index == -1) {
            throw new AssertJDBException(String.format("Column <%s> does not exist%nin <%s>%nwith comparison %s", columnName, columnsNameList, comparison.getComparisonName()), new Object[0]);
        }
        return this.getChangeColumnInstance(change, index);
    }

    public N getModifiedChangeColumnInstance(Change change) {
        Integer[] indexesOfModifiedColumns;
        for (Integer indexModified : indexesOfModifiedColumns = Changes.getIndexesOfModifiedColumns(change)) {
            if (indexModified < this.nextIndex) continue;
            return this.getChangeColumnInstance(change, indexModified);
        }
        throw new AssertJDBException("No more modified columns", new Object[0]);
    }

    public N getModifiedChangeColumnInstance(Change change, int index) {
        Integer[] indexesOfModifiedColumns = Changes.getIndexesOfModifiedColumns(change);
        int size = indexesOfModifiedColumns.length;
        if (index < 0 || index >= size) {
            throw new AssertJDBException("Index %s out of the limits of the modified columns [0, %s[", index, size);
        }
        int indexModified = indexesOfModifiedColumns[index];
        return this.getChangeColumnInstance(change, indexModified);
    }

    public N getModifiedChangeColumnInstance(Change change, String columnName, CaseComparison comparison) {
        if (columnName == null) {
            throw new NullPointerException("Column name must be not null");
        }
        Integer[] indexesOfModifiedColumns = Changes.getIndexesOfModifiedColumns(change);
        ArrayList<String> modifiedColumnsNameList = new ArrayList<String>();
        List<String> columnsNameList = change.getColumnsNameList();
        for (Integer indexModified : indexesOfModifiedColumns) {
            String modifiedColumnName = columnsNameList.get(indexModified);
            modifiedColumnsNameList.add(modifiedColumnName);
            if (!comparison.isEqual(modifiedColumnName, columnName)) continue;
            return this.getChangeColumnInstance(change, indexModified);
        }
        throw new AssertJDBException(String.format("Column <%s> does not exist among the modified columns%nin <%s>%nwith comparison %s", columnName, modifiedColumnsNameList, comparison.getComparisonName()), new Object[0]);
    }

    protected abstract String getDescription(int var1, String var2);
}

