/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.output;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.global.AbstractElement;
import org.assertj.db.output.impl.Output;

public abstract class AbstractOutputter<E extends AbstractOutputter<E>>
extends AbstractElement<E> {
    protected Output outputType;

    AbstractOutputter(Class<E> selfType) {
        super(selfType);
    }

    public E withType(Output outputType) {
        this.outputType = outputType;
        return (E)((AbstractOutputter)this.myself);
    }

    protected abstract String getOutput(Output var1);

    public E toConsole() {
        return this.toStream(System.out);
    }

    public E toStream(OutputStream outputStream) {
        String output = this.getOutput(this.outputType);
        PrintStream printStream = new PrintStream(outputStream);
        printStream.print(output);
        return (E)((AbstractOutputter)this.myself);
    }

    public E toFile(String fileName) {
        String output = this.getOutput(this.outputType);
        try (FileOutputStream fileOutputStream = new FileOutputStream(fileName);){
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.print(output);
        }
        catch (FileNotFoundException e) {
            throw new AssertJDBException(e);
        }
        catch (IOException e) {
            throw new AssertJDBException(e);
        }
        return (E)((AbstractOutputter)this.myself);
    }
}

