/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.output;

import org.assertj.db.navigation.PositionWithChanges;
import org.assertj.db.navigation.element.ChangesElement;
import org.assertj.db.navigation.origin.OriginWithChanges;
import org.assertj.db.output.AbstractOutputterWithOrigin;
import org.assertj.db.output.ChangeOutputter;
import org.assertj.db.output.impl.Output;
import org.assertj.db.output.impl.OutputType;
import org.assertj.db.type.Change;
import org.assertj.db.type.ChangeType;
import org.assertj.db.type.Changes;
import org.assertj.db.util.Descriptions;

public class ChangesOutputter
extends AbstractOutputterWithOrigin<ChangesOutputter, ChangesOutputter>
implements ChangesElement,
OriginWithChanges<ChangesOutputter, ChangeOutputter> {
    private final Changes changes;
    private final PositionWithChanges<ChangesOutputter, ChangeOutputter> changesPosition;

    ChangesOutputter(Changes changes) {
        this((ChangesOutputter)null, changes);
    }

    public ChangesOutputter(ChangesOutputter origin, Changes changes) {
        super(ChangesOutputter.class, origin);
        this.changes = changes;
        this.changesPosition = new PositionWithChanges(this, ChangesOutputter.class, ChangeOutputter.class){

            @Override
            protected String getChangesDescription(ChangeType changeType, String tableName) {
                return Descriptions.getChangesDescription(ChangesOutputter.this.info, changeType, tableName);
            }

            @Override
            protected String getChangeDescription(Changes changes, Change change, int index, ChangeType changeType, String tableName) {
                return Descriptions.getChangeDescription(ChangesOutputter.this.info, changes, change, index, changeType, tableName);
            }
        };
        this.withType(OutputType.PLAIN);
    }

    @Override
    public ChangesOutputter ofAll() {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).ofAll();
        }
        return this;
    }

    @Override
    public ChangesOutputter ofCreation() {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).ofCreation();
        }
        return (ChangesOutputter)this.changesPosition.getChangesInstance(this.changes, ChangeType.CREATION, null).withType(this.outputType);
    }

    @Override
    public ChangesOutputter ofModification() {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).ofModification();
        }
        return (ChangesOutputter)this.changesPosition.getChangesInstance(this.changes, ChangeType.MODIFICATION, null).withType(this.outputType);
    }

    @Override
    public ChangesOutputter ofDeletion() {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).ofDeletion();
        }
        return (ChangesOutputter)this.changesPosition.getChangesInstance(this.changes, ChangeType.DELETION, null).withType(this.outputType);
    }

    @Override
    public ChangesOutputter ofCreationOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).ofCreationOnTable(tableName);
        }
        return (ChangesOutputter)this.changesPosition.getChangesInstance(this.changes, ChangeType.CREATION, tableName).withType(this.outputType);
    }

    @Override
    public ChangesOutputter ofModificationOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).ofModificationOnTable(tableName);
        }
        return (ChangesOutputter)this.changesPosition.getChangesInstance(this.changes, ChangeType.MODIFICATION, tableName).withType(this.outputType);
    }

    @Override
    public ChangesOutputter ofDeletionOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).ofDeletionOnTable(tableName);
        }
        return (ChangesOutputter)this.changesPosition.getChangesInstance(this.changes, ChangeType.DELETION, tableName).withType(this.outputType);
    }

    @Override
    public ChangesOutputter onTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).onTable(tableName);
        }
        return (ChangesOutputter)this.changesPosition.getChangesInstance(this.changes, null, tableName).withType(this.outputType);
    }

    @Override
    public ChangeOutputter change() {
        return (ChangeOutputter)this.changesPosition.getChangeInstance(this.changes, null, null).withType(this.outputType);
    }

    @Override
    public ChangeOutputter change(int index) {
        return (ChangeOutputter)this.changesPosition.getChangeInstance(this.changes, null, null, index).withType(this.outputType);
    }

    @Override
    public ChangeOutputter changeOfCreation() {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).changeOfCreation();
        }
        return (ChangeOutputter)this.changesPosition.getChangeInstance(this.changes, ChangeType.CREATION, null).withType(this.outputType);
    }

    @Override
    public ChangeOutputter changeOfCreation(int index) {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).changeOfCreation(index);
        }
        return (ChangeOutputter)this.changesPosition.getChangeInstance(this.changes, ChangeType.CREATION, null, index).withType(this.outputType);
    }

    @Override
    public ChangeOutputter changeOfModification() {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).changeOfModification();
        }
        return (ChangeOutputter)this.changesPosition.getChangeInstance(this.changes, ChangeType.MODIFICATION, null).withType(this.outputType);
    }

    @Override
    public ChangeOutputter changeOfModification(int index) {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).changeOfModification(index);
        }
        return (ChangeOutputter)this.changesPosition.getChangeInstance(this.changes, ChangeType.MODIFICATION, null, index).withType(this.outputType);
    }

    @Override
    public ChangeOutputter changeOfDeletion() {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).changeOfDeletion();
        }
        return (ChangeOutputter)this.changesPosition.getChangeInstance(this.changes, ChangeType.DELETION, null).withType(this.outputType);
    }

    @Override
    public ChangeOutputter changeOfDeletion(int index) {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).changeOfDeletion(index);
        }
        return (ChangeOutputter)this.changesPosition.getChangeInstance(this.changes, ChangeType.DELETION, null, index).withType(this.outputType);
    }

    @Override
    public ChangeOutputter changeOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).changeOnTable(tableName);
        }
        return (ChangeOutputter)this.changesPosition.getChangeInstance(this.changes, null, tableName).withType(this.outputType);
    }

    @Override
    public ChangeOutputter changeOnTable(String tableName, int index) {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).changeOnTable(tableName, index);
        }
        return (ChangeOutputter)this.changesPosition.getChangeInstance(this.changes, null, tableName, index).withType(this.outputType);
    }

    @Override
    public ChangeOutputter changeOnTableWithPks(String tableName, Object ... pksValues) {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).changeOnTableWithPks(tableName, pksValues);
        }
        return (ChangeOutputter)this.changesPosition.getChangeInstanceWithPK(this.changes, tableName, pksValues).withType(this.outputType);
    }

    @Override
    public ChangeOutputter changeOfCreationOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).changeOfCreationOnTable(tableName);
        }
        return (ChangeOutputter)this.changesPosition.getChangeInstance(this.changes, ChangeType.CREATION, tableName).withType(this.outputType);
    }

    @Override
    public ChangeOutputter changeOfCreationOnTable(String tableName, int index) {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).changeOfCreationOnTable(tableName, index);
        }
        return (ChangeOutputter)this.changesPosition.getChangeInstance(this.changes, ChangeType.CREATION, tableName, index).withType(this.outputType);
    }

    @Override
    public ChangeOutputter changeOfModificationOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).changeOfModificationOnTable(tableName);
        }
        return (ChangeOutputter)this.changesPosition.getChangeInstance(this.changes, ChangeType.MODIFICATION, tableName).withType(this.outputType);
    }

    @Override
    public ChangeOutputter changeOfModificationOnTable(String tableName, int index) {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).changeOfModificationOnTable(tableName, index);
        }
        return (ChangeOutputter)this.changesPosition.getChangeInstance(this.changes, ChangeType.MODIFICATION, tableName, index).withType(this.outputType);
    }

    @Override
    public ChangeOutputter changeOfDeletionOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).changeOfDeletionOnTable(tableName);
        }
        return (ChangeOutputter)this.changesPosition.getChangeInstance(this.changes, ChangeType.DELETION, tableName).withType(this.outputType);
    }

    @Override
    public ChangeOutputter changeOfDeletionOnTable(String tableName, int index) {
        if (this.origin != null) {
            return ((ChangesOutputter)this.origin).changeOfDeletionOnTable(tableName, index);
        }
        return (ChangeOutputter)this.changesPosition.getChangeInstance(this.changes, ChangeType.DELETION, tableName, index).withType(this.outputType);
    }

    @Override
    protected String getOutput(Output outputType) {
        return outputType.getChangesOutput(this.info, this.changes);
    }
}

