/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.output.impl;

import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.db.output.impl.Output;
import org.assertj.db.output.impl.OutputType;
import org.assertj.db.type.Change;
import org.assertj.db.type.ChangeType;
import org.assertj.db.type.Changes;
import org.assertj.db.type.Column;
import org.assertj.db.type.DataType;
import org.assertj.db.type.Request;
import org.assertj.db.type.Row;
import org.assertj.db.type.Table;
import org.assertj.db.type.Value;

enum HtmlOutput implements Output
{
    INSTANCE;


    private static String getHtml(WritableAssertionInfo info, String content) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><head><title>description</title></head>");
        stringBuilder.append("<body><h1>");
        stringBuilder.append(info.descriptionText());
        stringBuilder.append("</h1>");
        stringBuilder.append(content);
        stringBuilder.append("</body></html>");
        return stringBuilder.toString();
    }

    @Override
    public String getTableOutput(WritableAssertionInfo info, Table table) {
        List<String> pksNameList = table.getPksNameList();
        List<String> columnsNameList = table.getColumnsNameList();
        List<Row> rowsList = table.getRowsList();
        Row[] rows = rowsList.toArray(new Row[rowsList.size()]);
        List<String> typesList = OutputType.getTypesList(rows);
        StringBuilder[] pksValueStringBuilders = OutputType.getPksValueStringBuilder(rows);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table border=\"1\" cellspacing=\"0\">");
        stringBuilder.append("<tr>");
        stringBuilder.append("<th>");
        stringBuilder.append("</th>");
        stringBuilder.append("<th>");
        stringBuilder.append("<br/>PRIMARY<br/>KEY");
        stringBuilder.append("</th>");
        int index = 0;
        for (String columnName : columnsNameList) {
            String pk = "";
            if (pksNameList != null && pksNameList.contains(columnName)) {
                pk = "*";
            }
            stringBuilder.append("<th>");
            stringBuilder.append(pk);
            stringBuilder.append("<br/>");
            stringBuilder.append(columnName);
            stringBuilder.append("<br/>");
            if (index < typesList.size()) {
                stringBuilder.append(typesList.get(index));
            }
            stringBuilder.append("<br/>Index : ");
            stringBuilder.append(index);
            stringBuilder.append("</th>");
            ++index;
        }
        stringBuilder.append("</tr>");
        index = 0;
        for (Row row : table.getRowsList()) {
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>Index :");
            stringBuilder.append(index);
            stringBuilder.append("</td>");
            stringBuilder.append("<td>");
            stringBuilder.append((CharSequence)pksValueStringBuilders[index]);
            stringBuilder.append("</td>");
            for (Value value : row.getValuesList()) {
                stringBuilder.append("<td>");
                stringBuilder.append(OutputType.getText(value));
                stringBuilder.append("</td>");
            }
            stringBuilder.append("</tr>");
            ++index;
        }
        stringBuilder.append("</table>");
        return HtmlOutput.getHtml(info, stringBuilder.toString());
    }

    @Override
    public String getRequestOutput(WritableAssertionInfo info, Request request) {
        List<String> pksNameList = request.getPksNameList();
        List<String> columnsNameList = request.getColumnsNameList();
        List<Row> rowsList = request.getRowsList();
        Row[] rows = rowsList.toArray(new Row[rowsList.size()]);
        List<String> typesList = OutputType.getTypesList(rows);
        StringBuilder[] pksValueStringBuilders = OutputType.getPksValueStringBuilder(rows);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table border=\"1\" cellspacing=\"0\">");
        stringBuilder.append("<tr>");
        stringBuilder.append("<th>");
        stringBuilder.append("</th>");
        stringBuilder.append("<th>");
        stringBuilder.append("<br/>PRIMARY<br/>KEY");
        stringBuilder.append("</th>");
        int index = 0;
        for (String columnName : columnsNameList) {
            String pk = "";
            if (pksNameList != null && pksNameList.contains(columnName)) {
                pk = "*";
            }
            stringBuilder.append("<th>");
            stringBuilder.append(pk);
            stringBuilder.append("<br/>");
            stringBuilder.append(columnName);
            stringBuilder.append("<br/>");
            if (index < typesList.size()) {
                stringBuilder.append(typesList.get(index));
            }
            stringBuilder.append("<br/>Index : ");
            stringBuilder.append(index);
            stringBuilder.append("</th>");
            ++index;
        }
        stringBuilder.append("</tr>");
        index = 0;
        for (Row row : request.getRowsList()) {
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>Index :");
            stringBuilder.append(index);
            stringBuilder.append("</td>");
            stringBuilder.append("<td>");
            stringBuilder.append((CharSequence)pksValueStringBuilders[index]);
            stringBuilder.append("</td>");
            for (Value value : row.getValuesList()) {
                stringBuilder.append("<td>");
                stringBuilder.append(OutputType.getText(value));
                stringBuilder.append("</td>");
            }
            stringBuilder.append("</tr>");
            ++index;
        }
        stringBuilder.append("</table>");
        return HtmlOutput.getHtml(info, stringBuilder.toString());
    }

    @Override
    public String getChangesOutput(WritableAssertionInfo info, Changes changes) {
        StringBuilder stringBuilder = new StringBuilder();
        List<Change> changesList = changes.getChangesList();
        stringBuilder.append("<table border=\"1\" cellspacing=\"0\">");
        stringBuilder.append("<tr>");
        stringBuilder.append("<th>");
        stringBuilder.append("</th>");
        stringBuilder.append("<th>");
        stringBuilder.append("<br/>TYPE");
        stringBuilder.append("</th>");
        stringBuilder.append("<th><br/>");
        stringBuilder.append(changesList.size() > 0 ? changesList.get(0).getDataType() : "");
        stringBuilder.append("</th>");
        stringBuilder.append("<th>");
        stringBuilder.append("<br/>PRIMARY<br/>KEY");
        stringBuilder.append("</th>");
        stringBuilder.append("<th>");
        stringBuilder.append("</th>");
        stringBuilder.append("</tr>");
        int index1 = 0;
        for (Change change : changes.getChangesList()) {
            Iterator<Object> iterator;
            ChangeType changeType = change.getChangeType();
            String dataName = OutputType.getDataName(change);
            List<String> columnsNameList = change.getColumnsNameList();
            Row rowAtStartPoint = change.getRowAtStartPoint();
            Row rowAtEndPoint = change.getRowAtEndPoint();
            StringBuilder[] pksValueStringBuilders = OutputType.getPksValueStringBuilder(change);
            List<String> typesList = OutputType.getTypesList(rowAtStartPoint, rowAtEndPoint);
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>Index : ");
            stringBuilder.append(index1);
            stringBuilder.append("</td>");
            stringBuilder.append("<td>");
            stringBuilder.append((Object)changeType);
            stringBuilder.append("</td>");
            stringBuilder.append("<td>");
            stringBuilder.append(dataName);
            stringBuilder.append("</td>");
            stringBuilder.append("<td>");
            stringBuilder.append((CharSequence)pksValueStringBuilders[0]);
            stringBuilder.append("</td>");
            stringBuilder.append("<td>");
            stringBuilder.append("<table border=\"1\" cellspacing=\"0\">");
            stringBuilder.append("<tr>");
            stringBuilder.append("<th>");
            stringBuilder.append("</th>");
            int index = 0;
            for (String columnName : columnsNameList) {
                String pk = "";
                if (change.getPksNameList() != null && change.getPksNameList().contains(columnName)) {
                    pk = "*";
                }
                stringBuilder.append("<th>");
                stringBuilder.append(pk);
                stringBuilder.append("<br/>");
                stringBuilder.append(columnName);
                stringBuilder.append("<br/>");
                stringBuilder.append(typesList.get(index));
                stringBuilder.append("<br/>Index : ");
                stringBuilder.append(index);
                stringBuilder.append("</th>");
                ++index;
            }
            stringBuilder.append("</tr>");
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>");
            stringBuilder.append("At start point");
            stringBuilder.append("</td>");
            if (change.getRowAtStartPoint() == null) {
                iterator = change.getColumnsNameList().iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    stringBuilder.append("<td>");
                    stringBuilder.append("</td>");
                }
            } else {
                for (Value value : change.getRowAtStartPoint().getValuesList()) {
                    stringBuilder.append("<td>");
                    stringBuilder.append(OutputType.getText(value));
                    stringBuilder.append("</td>");
                }
            }
            stringBuilder.append("</tr>");
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>");
            stringBuilder.append("At end point");
            stringBuilder.append("</td>");
            if (change.getRowAtEndPoint() == null) {
                iterator = change.getColumnsNameList().iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    stringBuilder.append("<td>");
                    stringBuilder.append("</td>");
                }
            } else {
                for (Value value : change.getRowAtEndPoint().getValuesList()) {
                    stringBuilder.append("<td>");
                    stringBuilder.append(OutputType.getText(value));
                    stringBuilder.append("</td>");
                }
            }
            stringBuilder.append("</tr>");
            stringBuilder.append("</table>");
            stringBuilder.append("</td>");
            stringBuilder.append("</tr>");
            ++index1;
        }
        stringBuilder.append("</table>");
        return HtmlOutput.getHtml(info, stringBuilder.toString());
    }

    @Override
    public String getChangeOutput(WritableAssertionInfo info, Change change) {
        Iterator<Object> iterator;
        ChangeType changeType = change.getChangeType();
        DataType dataType = change.getDataType();
        String dataName = OutputType.getDataName(change);
        List<String> columnsNameList = change.getColumnsNameList();
        Row rowAtStartPoint = change.getRowAtStartPoint();
        Row rowAtEndPoint = change.getRowAtEndPoint();
        StringBuilder[] pksValueStringBuilders = OutputType.getPksValueStringBuilder(change);
        List<String> typesList = OutputType.getTypesList(rowAtStartPoint, rowAtEndPoint);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table border=\"1\" cellspacing=\"0\">");
        stringBuilder.append("<tr>");
        stringBuilder.append("<th>");
        stringBuilder.append("<br/>TYPE");
        stringBuilder.append("</th>");
        stringBuilder.append("<th><br/>");
        stringBuilder.append((Object)dataType);
        stringBuilder.append("</th>");
        stringBuilder.append("<th>");
        stringBuilder.append("<br/>PRIMARY<br/>KEY");
        stringBuilder.append("</th>");
        stringBuilder.append("<th>");
        stringBuilder.append("</th>");
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td>");
        stringBuilder.append((Object)changeType);
        stringBuilder.append("</td>");
        stringBuilder.append("<td>");
        stringBuilder.append(dataName);
        stringBuilder.append("</td>");
        stringBuilder.append("<td>");
        stringBuilder.append((CharSequence)pksValueStringBuilders[0]);
        stringBuilder.append("</td>");
        stringBuilder.append("<td>");
        stringBuilder.append("<table border=\"1\" cellspacing=\"0\">");
        stringBuilder.append("<tr>");
        stringBuilder.append("<th>");
        stringBuilder.append("</th>");
        int index = 0;
        for (String columnName : columnsNameList) {
            String pk = "";
            if (change.getPksNameList() != null && change.getPksNameList().contains(columnName)) {
                pk = "*";
            }
            stringBuilder.append("<th>");
            stringBuilder.append(pk);
            stringBuilder.append("<br/>");
            stringBuilder.append(columnName);
            stringBuilder.append("<br/>");
            stringBuilder.append(typesList.get(index));
            stringBuilder.append("<br/>Index : ");
            stringBuilder.append(index);
            stringBuilder.append("</th>");
            ++index;
        }
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td>");
        stringBuilder.append("At start point");
        stringBuilder.append("</td>");
        if (change.getRowAtStartPoint() == null) {
            iterator = change.getColumnsNameList().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                stringBuilder.append("<td>");
                stringBuilder.append("</td>");
            }
        } else {
            for (Value value : change.getRowAtStartPoint().getValuesList()) {
                stringBuilder.append("<td>");
                stringBuilder.append(OutputType.getText(value));
                stringBuilder.append("</td>");
            }
        }
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td>");
        stringBuilder.append("At end point");
        stringBuilder.append("</td>");
        if (change.getRowAtEndPoint() == null) {
            iterator = change.getColumnsNameList().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                stringBuilder.append("<td>");
                stringBuilder.append("</td>");
            }
        } else {
            for (Value value : change.getRowAtEndPoint().getValuesList()) {
                stringBuilder.append("<td>");
                stringBuilder.append(OutputType.getText(value));
                stringBuilder.append("</td>");
            }
        }
        stringBuilder.append("</tr>");
        stringBuilder.append("</table>");
        stringBuilder.append("</td>");
        stringBuilder.append("</tr>");
        stringBuilder.append("</table>");
        return HtmlOutput.getHtml(info, stringBuilder.toString());
    }

    @Override
    public String getRowOutput(WritableAssertionInfo info, Row row) {
        if (row == null) {
            return HtmlOutput.getHtml(info, "Row does not exist");
        }
        List<String> columnsNameList = row.getColumnsNameList();
        List<String> typesList = OutputType.getTypesList(row);
        StringBuilder[] pksValueStringBuilders = OutputType.getPksValueStringBuilder(row);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table border=\"1\" cellspacing=\"0\">");
        stringBuilder.append("<tr>");
        stringBuilder.append("<th>");
        stringBuilder.append("<br/>PRIMARY<br/>KEY");
        stringBuilder.append("</th>");
        int index = 0;
        for (String columnName : columnsNameList) {
            String pk = "";
            if (row.getPksNameList() != null && row.getPksNameList().contains(columnName)) {
                pk = "*";
            }
            stringBuilder.append("<th>");
            stringBuilder.append(pk);
            stringBuilder.append("<br/>");
            stringBuilder.append(columnName);
            stringBuilder.append("<br/>");
            stringBuilder.append(typesList.get(index));
            stringBuilder.append("<br/>Index : ");
            stringBuilder.append(index);
            stringBuilder.append("</th>");
            ++index;
        }
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td>");
        stringBuilder.append((CharSequence)pksValueStringBuilders[0]);
        stringBuilder.append("</td>");
        for (Value value : row.getValuesList()) {
            stringBuilder.append("<td>");
            stringBuilder.append(OutputType.getText(value));
            stringBuilder.append("</td>");
        }
        stringBuilder.append("</tr>");
        stringBuilder.append("</table>");
        return HtmlOutput.getHtml(info, stringBuilder.toString());
    }

    @Override
    public String getColumnOutput(WritableAssertionInfo info, Column column) {
        String columnName = column.getName();
        List<Value> valuesList = column.getValuesList();
        Value[] values = valuesList.toArray(new Value[valuesList.size()]);
        String type = OutputType.getType(values);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table border=\"1\" cellspacing=\"0\">");
        stringBuilder.append("<tr>");
        stringBuilder.append("<th>");
        stringBuilder.append("</th>");
        stringBuilder.append("<th>");
        stringBuilder.append(columnName);
        stringBuilder.append("<br/>");
        stringBuilder.append(type);
        stringBuilder.append("</th>");
        stringBuilder.append("</tr>");
        int index = 0;
        for (Value value : values) {
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>Index : ");
            stringBuilder.append(index);
            stringBuilder.append("</td>");
            stringBuilder.append("<td>");
            stringBuilder.append(OutputType.getText(value));
            stringBuilder.append("</td>");
            stringBuilder.append("</tr>");
            ++index;
        }
        stringBuilder.append("</table>");
        return HtmlOutput.getHtml(info, stringBuilder.toString());
    }

    @Override
    public String getChangeColumnOutput(WritableAssertionInfo info, String columnName, Value valueAtStartPoint, Value valueAtEndPoint) {
        String typeAtStartPoint = OutputType.getType(valueAtStartPoint);
        String typeAtEndPoint = OutputType.getType(valueAtEndPoint);
        String type = valueAtStartPoint.getValue() != null ? typeAtStartPoint : typeAtEndPoint;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table border=\"1\" cellspacing=\"0\">");
        stringBuilder.append("<tr>");
        stringBuilder.append("<th>");
        stringBuilder.append("</th>");
        stringBuilder.append("<th>");
        stringBuilder.append(columnName);
        stringBuilder.append("<br/>");
        stringBuilder.append(type);
        stringBuilder.append("</th>");
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td>At start point</td>");
        stringBuilder.append("<td>");
        stringBuilder.append(OutputType.getText(valueAtStartPoint));
        stringBuilder.append("</td>");
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td>At end point</td>");
        stringBuilder.append("<td>");
        stringBuilder.append(OutputType.getText(valueAtEndPoint));
        stringBuilder.append("</td>");
        stringBuilder.append("</tr>");
        stringBuilder.append("</table>");
        return HtmlOutput.getHtml(info, stringBuilder.toString());
    }

    @Override
    public String getValueOutput(WritableAssertionInfo info, Value value) {
        String columnName = value.getColumnName();
        String type = OutputType.getType(value);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table border=\"1\" cellspacing=\"0\">");
        stringBuilder.append("<tr>");
        stringBuilder.append("<th>");
        stringBuilder.append(columnName);
        stringBuilder.append("<br/>");
        stringBuilder.append(type);
        stringBuilder.append("</th>");
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td>");
        stringBuilder.append(OutputType.getText(value));
        stringBuilder.append("</td>");
        stringBuilder.append("</tr>");
        stringBuilder.append("</table>");
        return HtmlOutput.getHtml(info, stringBuilder.toString());
    }
}

