/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.UUID;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.DbElement;
import org.assertj.db.type.TimeValue;
import org.assertj.db.type.ValueType;
import org.assertj.db.type.lettercase.LetterCase;
import org.assertj.db.type.lettercase.WithColumnLetterCase;

public class Value
implements DbElement,
WithColumnLetterCase {
    private final String columnName;
    private final Object value;
    private final ValueType valueType;
    private final LetterCase columnLetterCase;

    public static Value getNullValue(String columnName, LetterCase columnLetterCase) {
        return new Value(columnName, null, columnLetterCase);
    }

    static ValueType getType(Object object) {
        if (object instanceof byte[]) {
            return ValueType.BYTES;
        }
        if (object instanceof Boolean) {
            return ValueType.BOOLEAN;
        }
        if (object instanceof String) {
            return ValueType.TEXT;
        }
        if (object instanceof Date) {
            return ValueType.DATE;
        }
        if (object instanceof Time) {
            return ValueType.TIME;
        }
        if (object instanceof Timestamp) {
            return ValueType.DATE_TIME;
        }
        if (object instanceof UUID) {
            return ValueType.UUID;
        }
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof BigDecimal || object instanceof BigInteger) {
            return ValueType.NUMBER;
        }
        return ValueType.NOT_IDENTIFIED;
    }

    Value(String columnName, Object value, LetterCase columnLetterCase) {
        this.columnName = columnName;
        this.value = value;
        this.columnLetterCase = columnLetterCase;
        this.valueType = Value.getType(value);
    }

    @Override
    public LetterCase getColumnLetterCase() {
        return this.columnLetterCase;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Object getValue() {
        return this.value;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public String getValueTypeRepresentation() {
        if (this.value == null || this.valueType != ValueType.NOT_IDENTIFIED) {
            return this.valueType.toString();
        }
        return (Object)((Object)this.valueType) + " : " + this.value.getClass();
    }

    public boolean isComparisonPossible(Object object) {
        switch (this.valueType) {
            case BYTES: {
                return object instanceof byte[];
            }
            case BOOLEAN: {
                return object instanceof Boolean;
            }
            case TEXT: {
                return object instanceof String;
            }
            case DATE: 
            case DATE_TIME: {
                return object instanceof DateValue || object instanceof DateTimeValue || object instanceof String;
            }
            case TIME: {
                return object instanceof TimeValue || object instanceof String;
            }
            case NUMBER: {
                return object instanceof Number || object instanceof String;
            }
            case UUID: {
                return object instanceof UUID || object instanceof String;
            }
            case NOT_IDENTIFIED: {
                if (this.value == null) {
                    return object == null;
                }
                if (object == null) break;
                return this.value.getClass().equals(object.getClass());
            }
        }
        return false;
    }
}

