/**
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 *
 * Copyright 2012-2016 the original author or authors.
 */
package org.assertj.db.type.lettercase;

/**
 * Conversion of the case of a {@link java.lang.String}.
 * @author Régis Pouiller
 * @since 1.1.0
 */
public interface CaseConversion {

  /**
   * Returns the name of the conversion.
   * @return The name of the conversion.
   */
  String getConversionName();

  /**
   * Converts the {@link java.lang.String} in parameter to another.
   * @param value The {@link java.lang.String} to convert.
   * @return The result.
   */
  String convert(String value);
}
