/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import java.util.List;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.api.AbstractColumnAssert;
import org.assertj.db.api.AbstractColumnValueAssert;
import org.assertj.db.api.AbstractRowAssert;
import org.assertj.db.api.AbstractRowValueAssert;
import org.assertj.db.api.assertions.AssertOnNumberOfColumns;
import org.assertj.db.api.assertions.AssertOnNumberOfRows;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfColumns;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfRows;
import org.assertj.db.navigation.Position;
import org.assertj.db.navigation.PositionWithColumns;
import org.assertj.db.navigation.origin.OriginWithColumnsAndRows;
import org.assertj.db.type.AbstractDbData;
import org.assertj.db.type.AbstractDbElement;
import org.assertj.db.type.Column;
import org.assertj.db.type.Row;
import org.assertj.db.util.Descriptions;

public abstract class AbstractDbAssert<D extends AbstractDbData<D>, A extends AbstractDbAssert<D, A, C, CV, R, RV>, C extends AbstractColumnAssert<D, A, C, CV, R, RV>, CV extends AbstractColumnValueAssert<D, A, C, CV, R, RV>, R extends AbstractRowAssert<D, A, C, CV, R, RV>, RV extends AbstractRowValueAssert<D, A, C, CV, R, RV>>
extends AbstractAssert<A>
implements OriginWithColumnsAndRows<C, R>,
AssertOnNumberOfColumns<A>,
AssertOnNumberOfRows<A> {
    private final D actual;
    private final PositionWithColumns<A, C, Column> columnPosition;
    private final Position<A, R, Row> rowPosition;

    AbstractDbAssert(D actualValue, Class<A> selfType, Class<C> columnAssertType, Class<R> rowAssertType) {
        super(selfType);
        this.actual = actualValue;
        this.columnPosition = new PositionWithColumns<A, C, Column>((AbstractDbAssert)selfType.cast(this), columnAssertType){

            @Override
            protected String getDescription(int index) {
                List<String> columnsNameList = AbstractDbAssert.this.actual.getColumnsNameList();
                String columnName = columnsNameList.get(index);
                return Descriptions.getColumnDescription(((AbstractDbAssert)AbstractDbAssert.this.myself).getInfo(), index, columnName);
            }
        };
        this.rowPosition = new Position<A, R, Row>((AbstractDbAssert)selfType.cast(this), rowAssertType){

            @Override
            protected String getDescription(int index) {
                return Descriptions.getRowDescription(((AbstractDbAssert)AbstractDbAssert.this.myself).getInfo(), index);
            }
        };
    }

    @Override
    public R row() {
        return (R)((AbstractRowAssert)this.rowPosition.getInstance(((AbstractDbData)this.actual).getRowsList()));
    }

    @Override
    public R row(int index) {
        return (R)((AbstractRowAssert)this.rowPosition.getInstance(((AbstractDbData)this.actual).getRowsList(), index));
    }

    @Override
    public C column() {
        return (C)((AbstractColumnAssert)this.columnPosition.getInstance(((AbstractDbData)this.actual).getColumnsList()));
    }

    @Override
    public C column(int index) {
        return (C)((AbstractColumnAssert)this.columnPosition.getInstance(((AbstractDbData)this.actual).getColumnsList(), index));
    }

    @Override
    public C column(String columnName) {
        return (C)((AbstractColumnAssert)this.columnPosition.getInstance(((AbstractDbData)this.actual).getColumnsList(), ((AbstractDbData)this.actual).getColumnsNameList(), columnName, ((AbstractDbElement)this.actual).getColumnLetterCase()));
    }

    @Override
    public A isEmpty() {
        return (A)this.hasNumberOfRows(0);
    }

    @Override
    public A hasNumberOfRows(int expected) {
        List<Row> rowsList = ((AbstractDbData)this.actual).getRowsList();
        int size = rowsList.size();
        return (A)((AbstractDbAssert)AssertionsOnNumberOfRows.hasNumberOfRows((AbstractAssert)this.myself, this.info, size, expected));
    }

    @Override
    public A hasNumberOfRowsGreaterThan(int expected) {
        List<Row> rowsList = ((AbstractDbData)this.actual).getRowsList();
        int size = rowsList.size();
        return (A)((AbstractDbAssert)AssertionsOnNumberOfRows.hasNumberOfRowsGreaterThan((AbstractAssert)this.myself, this.info, size, expected));
    }

    @Override
    public A hasNumberOfRowsLessThan(int expected) {
        List<Row> rowsList = ((AbstractDbData)this.actual).getRowsList();
        int size = rowsList.size();
        return (A)((AbstractDbAssert)AssertionsOnNumberOfRows.hasNumberOfRowsLessThan((AbstractAssert)this.myself, this.info, size, expected));
    }

    @Override
    public A hasNumberOfRowsGreaterThanOrEqualTo(int expected) {
        List<Row> rowsList = ((AbstractDbData)this.actual).getRowsList();
        int size = rowsList.size();
        return (A)((AbstractDbAssert)AssertionsOnNumberOfRows.hasNumberOfRowsGreaterThanOrEqualTo((AbstractAssert)this.myself, this.info, size, expected));
    }

    @Override
    public A hasNumberOfRowsLessThanOrEqualTo(int expected) {
        List<Row> rowsList = ((AbstractDbData)this.actual).getRowsList();
        int size = rowsList.size();
        return (A)((AbstractDbAssert)AssertionsOnNumberOfRows.hasNumberOfRowsLessThanOrEqualTo((AbstractAssert)this.myself, this.info, size, expected));
    }

    @Override
    public A hasNumberOfColumns(int expected) {
        List<String> columnsNameList = ((AbstractDbData)this.actual).getColumnsNameList();
        int size = columnsNameList.size();
        return (A)((AbstractDbAssert)AssertionsOnNumberOfColumns.hasNumberOfColumns((AbstractAssert)this.myself, this.info, size, expected));
    }

    @Override
    public A hasNumberOfColumnsGreaterThan(int expected) {
        List<String> columnsNameList = ((AbstractDbData)this.actual).getColumnsNameList();
        int size = columnsNameList.size();
        return (A)((AbstractDbAssert)AssertionsOnNumberOfColumns.hasNumberOfColumnsGreaterThan((AbstractAssert)this.myself, this.info, size, expected));
    }

    @Override
    public A hasNumberOfColumnsLessThan(int expected) {
        List<String> columnsNameList = ((AbstractDbData)this.actual).getColumnsNameList();
        int size = columnsNameList.size();
        return (A)((AbstractDbAssert)AssertionsOnNumberOfColumns.hasNumberOfColumnsLessThan((AbstractAssert)this.myself, this.info, size, expected));
    }

    @Override
    public A hasNumberOfColumnsGreaterThanOrEqualTo(int expected) {
        List<String> columnsNameList = ((AbstractDbData)this.actual).getColumnsNameList();
        int size = columnsNameList.size();
        return (A)((AbstractDbAssert)AssertionsOnNumberOfColumns.hasNumberOfColumnsGreaterThanOrEqualTo((AbstractAssert)this.myself, this.info, size, expected));
    }

    @Override
    public A hasNumberOfColumnsLessThanOrEqualTo(int expected) {
        List<String> columnsNameList = ((AbstractDbData)this.actual).getColumnsNameList();
        int size = columnsNameList.size();
        return (A)((AbstractDbAssert)AssertionsOnNumberOfColumns.hasNumberOfColumnsLessThanOrEqualTo((AbstractAssert)this.myself, this.info, size, expected));
    }
}

