/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import java.lang.reflect.Constructor;
import java.util.List;
import org.assertj.db.api.ErrorCollector;
import org.assertj.db.api.ProxifyPositionResult;
import org.assertj.db.internal.bytebuddy.ByteBuddy;
import org.assertj.db.internal.bytebuddy.description.method.MethodDescription;
import org.assertj.db.internal.bytebuddy.dynamic.scaffold.TypeValidation;
import org.assertj.db.internal.bytebuddy.implementation.MethodDelegation;
import org.assertj.db.internal.bytebuddy.implementation.auxiliary.AuxiliaryType;
import org.assertj.db.internal.bytebuddy.matcher.ElementMatcher;
import org.assertj.db.internal.bytebuddy.matcher.ElementMatchers;

class SoftProxies {
    private static final ByteBuddy BYTE_BUDDY = new ByteBuddy().with(new AuxiliaryType.NamingStrategy.SuffixingRandom("AssertJDb$SoftProxies")).with(TypeValidation.DISABLED);
    private static final ElementMatcher.Junction<MethodDescription> METHODS_TO_EXTRACT_PROXY = ElementMatchers.nameContains("change").or(ElementMatchers.nameContains("column")).or(ElementMatchers.nameContains("row")).or(ElementMatchers.nameContains("value")).or(ElementMatchers.nameStartsWith("changeOf")).or(ElementMatchers.nameStartsWith("of")).or(ElementMatchers.nameStartsWith("rowAt"));
    private static final ElementMatcher.Junction<MethodDescription> METHODS_NOT_TO_PROXY = METHODS_TO_EXTRACT_PROXY.or(ElementMatchers.named("equals")).or(ElementMatchers.named("hashCode")).or(ElementMatchers.named("clone")).or(ElementMatchers.named("as")).or(ElementMatchers.named("toString")).or(ElementMatchers.named("describedAs")).or(ElementMatchers.named("descriptionText")).or(ElementMatchers.named("getWritableAssertionInfo")).or(ElementMatchers.named("inBinary")).or(ElementMatchers.named("inHexadecimal")).or(ElementMatchers.named("newAbstractIterableAssert")).or(ElementMatchers.named("newObjectArrayAssert")).or(ElementMatchers.named("removeCustomAssertRelatedElementsFromStackTraceIfNeeded")).or(ElementMatchers.named("overridingErrorMessage")).or(ElementMatchers.named("usingComparator")).or(ElementMatchers.named("usingDefaultComparator")).or(ElementMatchers.named("usingElementComparator")).or(ElementMatchers.named("withComparatorsForElementPropertyOrFieldNames")).or(ElementMatchers.named("withComparatorsForElementPropertyOrFieldTypes")).or(ElementMatchers.named("withIterables")).or(ElementMatchers.named("withFailMessage")).or(ElementMatchers.named("withAssertionInfo")).or(ElementMatchers.named("withAssertionState")).or(ElementMatchers.named("withRepresentation")).or(ElementMatchers.named("withTypeComparators")).or(ElementMatchers.named("withThreadDumpOnError")).or(ElementMatchers.named("succeedsWithin")).or(ElementMatchers.named("isEmpty"));
    private final ErrorCollector collector = new ErrorCollector();

    SoftProxies() {
    }

    List<Throwable> errorsCollected() {
        return this.collector.errors();
    }

    <V, T> V create(Class<V> assertClass, Class<T> actualClass, T actual) {
        try {
            Class<V> proxyClass = this.createProxyClass(assertClass);
            Constructor<V> constructor = proxyClass.getConstructor(actualClass);
            return constructor.newInstance(actual);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    <V> V create(Class<V> assertClass, Class[] paramClass, Object[] params) {
        try {
            Class<V> proxyClass = this.createProxyClass(assertClass);
            Constructor<V> constructor = proxyClass.getConstructor(paramClass);
            return constructor.newInstance(params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean wasSuccess() {
        return this.collector.wasSuccess();
    }

    private <V> Class<V> createProxyClass(Class<V> assertClass) {
        return BYTE_BUDDY.subclass(assertClass).method(ElementMatchers.any().and(ElementMatchers.not(METHODS_NOT_TO_PROXY))).intercept(MethodDelegation.to(this.collector)).method(METHODS_TO_EXTRACT_PROXY).intercept(MethodDelegation.to(new ProxifyPositionResult(this))).make().load(assertClass.getClassLoader()).getLoaded();
    }
}

