/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldBeValueClass;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.Value;

public class AssertionsOnColumnClass {
    private static final Failures failures = Failures.instance();

    private AssertionsOnColumnClass() {
    }

    public static <A extends AbstractAssert<?>> A isOfClass(A assertion, WritableAssertionInfo info, List<Value> valuesList, Class<?> expected, boolean lenient) {
        if (expected == null) {
            throw new AssertJDBException("Class of the column is null", new Object[0]);
        }
        int index = 0;
        for (Value value : valuesList) {
            Object object = value.getValue();
            if (!(object != null && expected.isAssignableFrom(object.getClass()) || lenient && object == null)) {
                throw failures.failure((AssertionInfo)info, ShouldBeValueClass.shouldBeValueClass(index, value, expected));
            }
            ++index;
        }
        return assertion;
    }
}

