/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.internal.bytebuddy.implementation.bind.annotation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import org.assertj.db.internal.bytebuddy.ByteBuddy;
import org.assertj.db.internal.bytebuddy.ClassFileVersion;
import org.assertj.db.internal.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.assertj.db.internal.bytebuddy.description.annotation.AnnotationDescription;
import org.assertj.db.internal.bytebuddy.description.field.FieldDescription;
import org.assertj.db.internal.bytebuddy.description.field.FieldList;
import org.assertj.db.internal.bytebuddy.description.method.MethodDescription;
import org.assertj.db.internal.bytebuddy.description.method.MethodList;
import org.assertj.db.internal.bytebuddy.description.method.ParameterDescription;
import org.assertj.db.internal.bytebuddy.description.modifier.ModifierContributor;
import org.assertj.db.internal.bytebuddy.description.modifier.Visibility;
import org.assertj.db.internal.bytebuddy.description.type.TypeDefinition;
import org.assertj.db.internal.bytebuddy.description.type.TypeDescription;
import org.assertj.db.internal.bytebuddy.description.type.TypeList;
import org.assertj.db.internal.bytebuddy.dynamic.DynamicType;
import org.assertj.db.internal.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.assertj.db.internal.bytebuddy.dynamic.scaffold.TypeValidation;
import org.assertj.db.internal.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import org.assertj.db.internal.bytebuddy.implementation.Implementation;
import org.assertj.db.internal.bytebuddy.implementation.MethodAccessorFactory;
import org.assertj.db.internal.bytebuddy.implementation.auxiliary.AuxiliaryType;
import org.assertj.db.internal.bytebuddy.implementation.bind.MethodDelegationBinder;
import org.assertj.db.internal.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.Duplication;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.StackManipulation;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.TypeCreation;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.assign.Assigner;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.member.FieldAccess;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.assertj.db.internal.bytebuddy.jar.asm.MethodVisitor;
import org.assertj.db.internal.bytebuddy.matcher.ElementMatchers;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface Pipe {
    public boolean serializableProxy() default false;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Binder
    implements TargetMethodAnnotationDrivenBinder.ParameterBinder<Pipe> {
        private final MethodDescription forwardingMethod;

        protected Binder(MethodDescription forwardingMethod) {
            this.forwardingMethod = forwardingMethod;
        }

        public static TargetMethodAnnotationDrivenBinder.ParameterBinder<Pipe> install(Class<?> type) {
            return Binder.install(TypeDescription.ForLoadedType.of(type));
        }

        public static TargetMethodAnnotationDrivenBinder.ParameterBinder<Pipe> install(TypeDescription typeDescription) {
            return new Binder(Binder.onlyMethod(typeDescription));
        }

        private static MethodDescription onlyMethod(TypeDescription typeDescription) {
            if (!typeDescription.isInterface()) {
                throw new IllegalArgumentException(typeDescription + " is not an interface");
            }
            if (!typeDescription.getInterfaces().isEmpty()) {
                throw new IllegalArgumentException(typeDescription + " must not extend other interfaces");
            }
            if (!typeDescription.isPublic()) {
                throw new IllegalArgumentException(typeDescription + " is mot public");
            }
            MethodList methodCandidates = (MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.isAbstract());
            if (methodCandidates.size() != 1) {
                throw new IllegalArgumentException(typeDescription + " must declare exactly one abstract method");
            }
            MethodDescription methodDescription = (MethodDescription)methodCandidates.getOnly();
            if (!methodDescription.getReturnType().asErasure().represents((Type)((Object)Object.class))) {
                throw new IllegalArgumentException(methodDescription + " does not return an Object-type");
            }
            if (methodDescription.getParameters().size() != 1 || !((ParameterDescription)methodDescription.getParameters().getOnly()).getType().asErasure().represents((Type)((Object)Object.class))) {
                throw new IllegalArgumentException(methodDescription + " does not take a single Object-typed argument");
            }
            return methodDescription;
        }

        @Override
        public Class<Pipe> getHandledType() {
            return Pipe.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<Pipe> annotation, MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner, Assigner.Typing typing) {
            if (!target.getType().asErasure().equals(this.forwardingMethod.getDeclaringType())) {
                throw new IllegalStateException("Illegal use of @Pipe for " + target + " which was installed for " + this.forwardingMethod.getDeclaringType());
            }
            if (source.isStatic()) {
                return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            return new MethodDelegationBinder.ParameterBinding.Anonymous(new Redirection(this.forwardingMethod.getDeclaringType().asErasure(), source, assigner, annotation.load().serializableProxy()));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.forwardingMethod.equals(((Binder)object).forwardingMethod);
        }

        public int hashCode() {
            return 17 * 31 + this.forwardingMethod.hashCode();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class Redirection
        implements AuxiliaryType,
        StackManipulation {
            private static final String FIELD_NAME_PREFIX = "argument";
            private final TypeDescription forwardingType;
            private final MethodDescription sourceMethod;
            private final Assigner assigner;
            private final boolean serializableProxy;

            protected Redirection(TypeDescription forwardingType, MethodDescription sourceMethod, Assigner assigner, boolean serializableProxy) {
                this.forwardingType = forwardingType;
                this.sourceMethod = sourceMethod;
                this.assigner = assigner;
                this.serializableProxy = serializableProxy;
            }

            private static LinkedHashMap<String, TypeDescription> extractFields(MethodDescription methodDescription) {
                TypeList parameterTypes = methodDescription.getParameters().asTypeList().asErasures();
                LinkedHashMap<String, TypeDescription> typeDescriptions = new LinkedHashMap<String, TypeDescription>();
                int currentIndex = 0;
                for (TypeDescription parameterType : parameterTypes) {
                    typeDescriptions.put(Redirection.fieldName(currentIndex++), parameterType);
                }
                return typeDescriptions;
            }

            private static String fieldName(int index) {
                return FIELD_NAME_PREFIX + index;
            }

            @Override
            public DynamicType make(String auxiliaryTypeName, ClassFileVersion classFileVersion, MethodAccessorFactory methodAccessorFactory) {
                Type[] typeArray;
                LinkedHashMap<String, TypeDescription> parameterFields = Redirection.extractFields(this.sourceMethod);
                DynamicType.Builder<?> builder = new ByteBuddy(classFileVersion).with(TypeValidation.DISABLED).subclass(this.forwardingType, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).name(auxiliaryTypeName).modifiers(DEFAULT_TYPE_MODIFIER);
                if (this.serializableProxy) {
                    Class[] classArray = new Class[1];
                    typeArray = classArray;
                    classArray[0] = Serializable.class;
                } else {
                    typeArray = new Class[]{};
                }
                DynamicType.Builder<Object> builder2 = builder.implement(typeArray).method(ElementMatchers.isAbstract().and(ElementMatchers.isDeclaredBy(this.forwardingType))).intercept(new MethodCall(this.sourceMethod, this.assigner)).defineConstructor(new ModifierContributor.ForMethod[0]).withParameters(parameterFields.values()).intercept(ConstructorCall.INSTANCE);
                for (Map.Entry<String, TypeDescription> field : parameterFields.entrySet()) {
                    builder2 = builder2.defineField(field.getKey(), (TypeDefinition)field.getValue(), Visibility.PRIVATE);
                }
                return builder2.make();
            }

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                TypeDescription forwardingType = implementationContext.register(this);
                return new StackManipulation.Compound(TypeCreation.of(forwardingType), Duplication.SINGLE, MethodVariableAccess.allArgumentsOf(this.sourceMethod), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)forwardingType.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly())).apply(methodVisitor, implementationContext);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.serializableProxy != ((Redirection)object).serializableProxy) {
                    return false;
                }
                if (!this.forwardingType.equals(((Redirection)object).forwardingType)) {
                    return false;
                }
                if (!this.sourceMethod.equals(((Redirection)object).sourceMethod)) {
                    return false;
                }
                return this.assigner.equals(((Redirection)object).assigner);
            }

            public int hashCode() {
                return (((17 * 31 + this.forwardingType.hashCode()) * 31 + this.sourceMethod.hashCode()) * 31 + this.assigner.hashCode()) * 31 + this.serializableProxy;
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class MethodCall
            implements Implementation {
                private final MethodDescription redirectedMethod;
                private final Assigner assigner;

                private MethodCall(MethodDescription redirectedMethod, Assigner assigner) {
                    this.redirectedMethod = redirectedMethod;
                    this.assigner = assigner;
                }

                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public ByteCodeAppender appender(Implementation.Target implementationTarget) {
                    if (!this.redirectedMethod.isAccessibleTo(implementationTarget.getInstrumentedType())) {
                        throw new IllegalStateException("Cannot invoke " + this.redirectedMethod + " from outside of class via @Pipe proxy");
                    }
                    return new Appender(implementationTarget.getInstrumentedType());
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.redirectedMethod.equals(((MethodCall)object).redirectedMethod)) {
                        return false;
                    }
                    return this.assigner.equals(((MethodCall)object).assigner);
                }

                public int hashCode() {
                    return (17 * 31 + this.redirectedMethod.hashCode()) * 31 + this.assigner.hashCode();
                }

                @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
                private class Appender
                implements ByteCodeAppender {
                    private final TypeDescription instrumentedType;

                    private Appender(TypeDescription instrumentedType) {
                        this.instrumentedType = instrumentedType;
                    }

                    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                        FieldList<FieldDescription.InDefinedShape> fieldList = this.instrumentedType.getDeclaredFields();
                        StackManipulation[] fieldLoading = new StackManipulation[fieldList.size()];
                        int index = 0;
                        for (FieldDescription fieldDescription : fieldList) {
                            fieldLoading[index++] = new StackManipulation.Compound(MethodVariableAccess.loadThis(), FieldAccess.forField(fieldDescription).read());
                        }
                        StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFrom(1), MethodCall.this.assigner.assign(TypeDescription.Generic.OBJECT, MethodCall.this.redirectedMethod.getDeclaringType().asGenericType(), Assigner.Typing.DYNAMIC), new StackManipulation.Compound(fieldLoading), MethodInvocation.invoke(MethodCall.this.redirectedMethod), MethodCall.this.assigner.assign(MethodCall.this.redirectedMethod.getReturnType(), instrumentedMethod.getReturnType(), Assigner.Typing.DYNAMIC), MethodReturn.REFERENCE).apply(methodVisitor, implementationContext);
                        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!this.instrumentedType.equals(((Appender)object).instrumentedType)) {
                            return false;
                        }
                        return MethodCall.this.equals(((Appender)object).MethodCall.this);
                    }

                    public int hashCode() {
                        return (17 * 31 + this.instrumentedType.hashCode()) * 31 + MethodCall.this.hashCode();
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Fields of enumerations are never serialized")
            protected static enum ConstructorCall implements Implementation
            {
                INSTANCE;

                private final MethodDescription.InDefinedShape objectTypeDefaultConstructor = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.OBJECT.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly();

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public ByteCodeAppender appender(Implementation.Target implementationTarget) {
                    return new Appender(implementationTarget.getInstrumentedType());
                }

                @HashCodeAndEqualsPlugin.Enhance
                private static class Appender
                implements ByteCodeAppender {
                    private final TypeDescription instrumentedType;

                    private Appender(TypeDescription instrumentedType) {
                        this.instrumentedType = instrumentedType;
                    }

                    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                        FieldList<FieldDescription.InDefinedShape> fieldList = this.instrumentedType.getDeclaredFields();
                        StackManipulation[] fieldLoading = new StackManipulation[fieldList.size()];
                        int index = 0;
                        for (FieldDescription fieldDescription : fieldList) {
                            fieldLoading[index] = new StackManipulation.Compound(MethodVariableAccess.loadThis(), MethodVariableAccess.load((ParameterDescription)instrumentedMethod.getParameters().get(index)), FieldAccess.forField(fieldDescription).write());
                            ++index;
                        }
                        StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.loadThis(), MethodInvocation.invoke(INSTANCE.objectTypeDefaultConstructor), new StackManipulation.Compound(fieldLoading), MethodReturn.VOID).apply(methodVisitor, implementationContext);
                        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.instrumentedType.equals(((Appender)object).instrumentedType);
                    }

                    public int hashCode() {
                        return 17 * 31 + this.instrumentedType.hashCode();
                    }
                }
            }
        }
    }
}

