/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldBeDataType;
import org.assertj.db.error.ShouldBeOnTable;
import org.assertj.db.type.Change;
import org.assertj.db.type.DataType;
import org.assertj.db.type.lettercase.LetterCase;

public class AssertionsOnDataType {
    private static final Failures failures = Failures.instance();

    private AssertionsOnDataType() {
    }

    public static <A extends AbstractAssert<?>> A isOnDataType(A assertion, WritableAssertionInfo info, Change change, DataType expected) {
        DataType dataType = change.getDataType();
        if (dataType != expected) {
            throw failures.failure((AssertionInfo)info, ShouldBeDataType.shouldBeDataType(expected, dataType));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A isOnTable(A assertion, WritableAssertionInfo info, Change change) {
        return AssertionsOnDataType.isOnDataType(assertion, info, change, DataType.TABLE);
    }

    public static <A extends AbstractAssert<?>> A isOnRequest(A assertion, WritableAssertionInfo info, Change change) {
        return AssertionsOnDataType.isOnDataType(assertion, info, change, DataType.REQUEST);
    }

    public static <A extends AbstractAssert<?>> A isOnTable(A assertion, WritableAssertionInfo info, Change change, LetterCase tableLetterCase, String name) {
        if (name == null) {
            throw new NullPointerException("Table name must be not null");
        }
        AssertionsOnDataType.isOnTable(assertion, info, change);
        String dataName = change.getDataName();
        if (!tableLetterCase.isEqual(dataName, name)) {
            throw failures.failure((AssertionInfo)info, ShouldBeOnTable.shouldBeOnTable(name, dataName));
        }
        return assertion;
    }
}

