/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.navigation;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.global.AbstractElement;
import org.assertj.db.type.DbElement;
import org.assertj.db.util.Proxies;

public abstract class Position<E extends AbstractElement<E>, N extends AbstractElement<N>, D extends DbElement> {
    private final E myself;
    private int nextIndex;
    private final Class<N> elementClass;
    private final Map<Integer, N> elementsMap = new HashMap<Integer, N>();

    public Position(E myself, Class<N> elementClass) {
        this.myself = myself;
        this.elementClass = elementClass;
    }

    protected D getDbElement(List<D> dbElementsList, int index) {
        int size = dbElementsList.size();
        if (index < 0 || index >= size) {
            throw new AssertJDBException("Index %s out of the limits [0, %s[", index, size);
        }
        DbElement element = (DbElement)dbElementsList.get(index);
        this.nextIndex = index + 1;
        return (D)element;
    }

    public N getInstance(List<D> elementsList) {
        return this.getInstance(elementsList, this.nextIndex);
    }

    public N getInstance(List<D> elementsList, int index) {
        if (this.elementsMap.containsKey(index)) {
            AbstractElement rowAssert = (AbstractElement)this.elementsMap.get(index);
            this.nextIndex = index + 1;
            return (N)rowAssert;
        }
        D element = this.getDbElement(elementsList, index);
        try {
            Class clazz = Proxies.unProxy(this.myself.getClass());
            Constructor<N> constructor = this.elementClass.getDeclaredConstructor(clazz, element.getClass());
            AbstractElement instance = (AbstractElement)constructor.newInstance(this.myself, element);
            this.elementsMap.put(index, instance);
            instance.as(this.getDescription(index), new Object[0]);
            return (N)instance;
        }
        catch (Exception e) {
            throw new AssertJDBException(String.format("There is an exception '" + e.getMessage() + "'%n\t in the instantiation of the element " + this.elementClass.getName() + "%n\t on " + element.getClass() + " with " + this.myself.getClass() + ".%n It is normally impossible.%n That means there is a big mistake in the development of AssertJDB.%n Please write an issue for that if you meet this problem.", new Object[0]), new Object[0]);
        }
    }

    protected abstract String getDescription(int var1);
}

