/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.navigation;

import java.util.List;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.global.AbstractElement;
import org.assertj.db.navigation.Position;
import org.assertj.db.type.DbElement;
import org.assertj.db.type.lettercase.CaseComparison;
import org.assertj.db.util.NameComparator;

public abstract class PositionWithColumns<E extends AbstractElement<E>, N extends AbstractElement<N>, D extends DbElement>
extends Position<E, N, D> {
    public PositionWithColumns(E myself, Class<N> elementClass) {
        super(myself, elementClass);
    }

    public N getInstance(List<D> elementsList, List<String> columnsNameList, String columnName, CaseComparison comparison) {
        if (columnName == null) {
            throw new NullPointerException("Column name must be not null");
        }
        int index = NameComparator.INSTANCE.indexOf(columnsNameList, columnName, comparison);
        if (index == -1) {
            throw new AssertJDBException(String.format("Column <%s> does not exist%nin <%s>%nwith comparison %s", columnName, columnsNameList, comparison.getComparisonName()), new Object[0]);
        }
        return this.getInstance(elementsList, index);
    }
}

