/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.output;

import org.assertj.db.navigation.PositionWithColumnsChange;
import org.assertj.db.navigation.PositionWithPoints;
import org.assertj.db.navigation.element.ChangeElement;
import org.assertj.db.navigation.origin.OriginWithColumnsAndRowsFromChange;
import org.assertj.db.output.AbstractOutputterWithOriginWithChanges;
import org.assertj.db.output.ChangeColumnOutputter;
import org.assertj.db.output.ChangeRowOutputter;
import org.assertj.db.output.ChangesOutputter;
import org.assertj.db.output.impl.Output;
import org.assertj.db.type.Change;
import org.assertj.db.type.Row;
import org.assertj.db.util.Descriptions;

public class ChangeOutputter
extends AbstractOutputterWithOriginWithChanges<ChangeOutputter, ChangesOutputter>
implements ChangeElement,
OriginWithColumnsAndRowsFromChange<ChangesOutputter, ChangeOutputter, ChangeColumnOutputter, ChangeRowOutputter> {
    private final Change change;
    private final PositionWithPoints<ChangeOutputter, ChangeRowOutputter, Row> rowPosition;
    private final PositionWithColumnsChange<ChangeOutputter, ChangeColumnOutputter> columnPosition;

    public ChangeOutputter(ChangesOutputter origin, Change change) {
        super(ChangeOutputter.class, origin);
        this.change = change;
        this.rowPosition = new PositionWithPoints<ChangeOutputter, ChangeRowOutputter, Row>(this, ChangeRowOutputter.class, Row.class, change.getRowAtStartPoint(), change.getRowAtEndPoint()){

            @Override
            protected String getDescriptionAtStartPoint() {
                return Descriptions.getRowAtStartPointDescription(ChangeOutputter.this.info);
            }

            @Override
            protected String getDescriptionAtEndPoint() {
                return Descriptions.getRowAtEndPointDescription(ChangeOutputter.this.info);
            }
        };
        this.columnPosition = new PositionWithColumnsChange<ChangeOutputter, ChangeColumnOutputter>(this, ChangeColumnOutputter.class){

            @Override
            protected String getDescription(int index, String columnName) {
                return Descriptions.getColumnDescription(ChangeOutputter.this.info, index, columnName);
            }
        };
    }

    @Override
    public ChangeRowOutputter rowAtStartPoint() {
        return (ChangeRowOutputter)this.rowPosition.getInstanceAtStartPoint().withType(this.outputType);
    }

    @Override
    public ChangeRowOutputter rowAtEndPoint() {
        return (ChangeRowOutputter)this.rowPosition.getInstanceAtEndPoint().withType(this.outputType);
    }

    @Override
    public ChangeColumnOutputter column() {
        return (ChangeColumnOutputter)this.columnPosition.getChangeColumnInstance(this.change).withType(this.outputType);
    }

    @Override
    public ChangeColumnOutputter column(int index) {
        return (ChangeColumnOutputter)this.columnPosition.getChangeColumnInstance(this.change, index).withType(this.outputType);
    }

    @Override
    public ChangeColumnOutputter column(String columnName) {
        return (ChangeColumnOutputter)this.columnPosition.getChangeColumnInstance(this.change, columnName, this.change.getColumnLetterCase()).withType(this.outputType);
    }

    @Override
    public ChangeColumnOutputter columnAmongTheModifiedOnes() {
        return (ChangeColumnOutputter)this.columnPosition.getModifiedChangeColumnInstance(this.change).withType(this.outputType);
    }

    @Override
    public ChangeColumnOutputter columnAmongTheModifiedOnes(int index) {
        return (ChangeColumnOutputter)this.columnPosition.getModifiedChangeColumnInstance(this.change, index).withType(this.outputType);
    }

    @Override
    public ChangeColumnOutputter columnAmongTheModifiedOnes(String columnName) {
        return (ChangeColumnOutputter)this.columnPosition.getModifiedChangeColumnInstance(this.change, columnName, this.change.getColumnLetterCase()).withType(this.outputType);
    }

    public ChangesOutputter returnToChanges() {
        return (ChangesOutputter)this.returnToOrigin();
    }

    @Override
    protected String getOutput(Output outputType) {
        return outputType.getChangeOutput(this.info, this.change);
    }
}

