/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.AbstractDbElement;
import org.assertj.db.type.Column;
import org.assertj.db.type.DataType;
import org.assertj.db.type.Row;
import org.assertj.db.type.Source;
import org.assertj.db.type.Value;
import org.assertj.db.type.lettercase.LetterCase;
import org.assertj.db.util.NameComparator;
import org.assertj.db.util.RowComparator;

public abstract class AbstractDbData<D extends AbstractDbData<D>>
extends AbstractDbElement<D> {
    private final DataType dataType;
    private List<String> columnsNameList;
    private List<String> pksNameList;
    private List<Row> rowsList;
    private List<Column> columnsList;

    AbstractDbData(Class<D> selfType, DataType dataType) {
        super(selfType);
        this.dataType = dataType;
    }

    AbstractDbData(Class<D> selfType, DataType dataType, Source source) {
        super(selfType, source);
        this.dataType = dataType;
    }

    AbstractDbData(Class<D> selfType, DataType dataType, DataSource dataSource) {
        super(selfType, dataSource);
        this.dataType = dataType;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public abstract String getRequest();

    private void load() {
        try (Connection connection = this.getConnection();){
            this.loadImpl(connection);
            if (this.pksNameList == null) {
                this.pksNameList = new ArrayList<String>();
            }
        }
        catch (SQLException e) {
            throw new AssertJDBException(e);
        }
    }

    protected void sortRows() {
        this.rowsList.sort(RowComparator.INSTANCE);
    }

    protected abstract void loadImpl(Connection var1) throws SQLException;

    protected void collectRowsFromResultSet(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        this.rowsList = new ArrayList<Row>();
        while (resultSet.next()) {
            ArrayList<Value> valuesList = new ArrayList<Value>();
            for (String columnName : this.columnsNameList) {
                Object object;
                int index = -1;
                for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                    if (!this.getColumnLetterCase().isEqual(columnName, metaData.getColumnLabel(i))) continue;
                    index = i;
                    break;
                }
                int type = metaData.getColumnType(index);
                switch (type) {
                    case 91: {
                        object = resultSet.getDate(columnName);
                        break;
                    }
                    case 92: {
                        object = resultSet.getTime(columnName);
                        break;
                    }
                    case 93: {
                        object = resultSet.getTimestamp(columnName);
                        break;
                    }
                    case 2004: {
                        object = resultSet.getBytes(columnName);
                        break;
                    }
                    case 2005: {
                        object = resultSet.getString(columnName);
                        break;
                    }
                    default: {
                        object = resultSet.getObject(columnName);
                    }
                }
                valuesList.add(new Value(columnName, object, this.getColumnLetterCase()));
            }
            this.rowsList.add(new Row(this.pksNameList, this.columnsNameList, valuesList, this.getColumnLetterCase(), this.getPrimaryKeyLetterCase()));
        }
    }

    public List<String> getColumnsNameList() {
        if (this.columnsNameList == null) {
            this.load();
        }
        return this.columnsNameList;
    }

    protected void setColumnsNameList(List<String> columnsNameList) {
        this.columnsNameList = columnsNameList;
    }

    public List<String> getPksNameList() {
        if (this.pksNameList == null) {
            this.load();
        }
        return this.pksNameList;
    }

    protected void controlIfAllThePksNameExistInTheColumns() {
        LetterCase letterCase = this.getPrimaryKeyLetterCase();
        if (this.pksNameList != null) {
            for (String pkName : this.pksNameList) {
                if (this.columnsNameList == null || NameComparator.INSTANCE.contains(this.columnsNameList, pkName, letterCase)) continue;
                throw new AssertJDBException("Primary key %s do not exist in the columns %s", pkName, this.columnsNameList);
            }
        }
    }

    protected void setPksNameList(List<String> pksNameList) {
        this.pksNameList = new ArrayList<String>();
        this.pksNameList.addAll(pksNameList);
        if (this.rowsList != null) {
            for (Row row : this.rowsList) {
                row.setPksNameList(this.pksNameList);
            }
        }
        this.controlIfAllThePksNameExistInTheColumns();
    }

    public List<Row> getRowsList() {
        if (this.rowsList == null) {
            this.load();
        }
        return this.rowsList;
    }

    public List<Column> getColumnsList() {
        if (this.columnsList == null) {
            this.columnsList = new ArrayList<Column>();
            List<String> loadedColumnsNameList = this.getColumnsNameList();
            int index = 0;
            for (String name : loadedColumnsNameList) {
                List<Value> valuesList = this.getValuesList(index);
                Column column = new Column(name, valuesList, this.getColumnLetterCase());
                this.columnsList.add(column);
                ++index;
            }
        }
        return this.columnsList;
    }

    public Column getColumn(int index) {
        return this.getColumnsList().get(index);
    }

    public Row getRow(int index) {
        return this.getRowsList().get(index);
    }

    private List<Value> getValuesList(int index) {
        ArrayList<Value> valuesList = new ArrayList<Value>();
        for (Row row : this.getRowsList()) {
            valuesList.add(row.getColumnValue(index));
        }
        return valuesList;
    }

    public Row getRowFromPksValues(Value ... pksValues) {
        for (Row row : this.getRowsList()) {
            if (!row.hasPksValuesEqualTo(pksValues)) continue;
            return row;
        }
        return null;
    }
}

