/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.util.UUID;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.api.assertions.impl.AssertionsOnColumnOfChangeClass;
import org.assertj.db.api.assertions.impl.AssertionsOnColumnOfChangeType;
import org.assertj.db.error.ShouldBeEqualWithEndPoint;
import org.assertj.db.error.ShouldBeEqualWithStartPoint;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.TimeValue;
import org.assertj.db.type.Value;
import org.assertj.db.type.ValueType;
import org.assertj.db.util.Values;

public class AssertionsOnColumnOfChangeEquality {
    private static final Failures failures = Failures.instance();

    private AssertionsOnColumnOfChangeEquality() {
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, Object expected) {
        if (expected != null) {
            AssertionsOnColumnOfChangeClass.isOfClass(assertion, info, valueAtStartPoint, valueAtEndPoint, expected.getClass(), true);
        }
        if (!Values.areEqual(valueAtStartPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(valueAtStartPoint.getValue(), expected));
        }
        if (!Values.areEqual(valueAtEndPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(valueAtEndPoint.getValue(), expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, Object expectedAtStartPoint, Object expectedAtEndPoint) {
        if (expectedAtStartPoint != null) {
            AssertionsOnColumnOfChangeClass.isOfClass(assertion, info, valueAtStartPoint, Value.getNullValue(valueAtEndPoint.getColumnName(), valueAtEndPoint.getColumnLetterCase()), expectedAtStartPoint.getClass(), true);
        }
        if (expectedAtEndPoint != null) {
            AssertionsOnColumnOfChangeClass.isOfClass(assertion, info, Value.getNullValue(valueAtStartPoint.getColumnName(), valueAtStartPoint.getColumnLetterCase()), valueAtEndPoint, expectedAtEndPoint.getClass(), true);
        }
        if (!Values.areEqual(valueAtStartPoint, expectedAtStartPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(valueAtStartPoint.getValue(), expectedAtStartPoint));
        }
        if (!Values.areEqual(valueAtEndPoint, expectedAtEndPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(valueAtEndPoint.getValue(), expectedAtEndPoint));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, Boolean expected) {
        AssertionsOnColumnOfChangeType.isBoolean(assertion, info, valueAtStartPoint, valueAtEndPoint, true);
        if (!Values.areEqual(valueAtStartPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(valueAtStartPoint.getValue(), expected));
        }
        if (!Values.areEqual(valueAtEndPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(valueAtEndPoint.getValue(), expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, Boolean expectedAtStartPoint, Boolean expectedAtEndPoint) {
        AssertionsOnColumnOfChangeType.isBoolean(assertion, info, valueAtStartPoint, valueAtEndPoint, true);
        if (!Values.areEqual(valueAtStartPoint, expectedAtStartPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(valueAtStartPoint.getValue(), expectedAtStartPoint));
        }
        if (!Values.areEqual(valueAtEndPoint, expectedAtEndPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(valueAtEndPoint.getValue(), expectedAtEndPoint));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, Number expected) {
        AssertionsOnColumnOfChangeType.isNumber(assertion, info, valueAtStartPoint, valueAtEndPoint, true);
        if (!Values.areEqual(valueAtStartPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expected), expected));
        }
        if (!Values.areEqual(valueAtEndPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expected), expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, Number expectedAtStartPoint, Number expectedAtEndPoint) {
        AssertionsOnColumnOfChangeType.isNumber(assertion, info, valueAtStartPoint, valueAtEndPoint, true);
        if (!Values.areEqual(valueAtStartPoint, expectedAtStartPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expectedAtStartPoint), expectedAtStartPoint));
        }
        if (!Values.areEqual(valueAtEndPoint, expectedAtEndPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expectedAtEndPoint), expectedAtEndPoint));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, byte[] expected) {
        AssertionsOnColumnOfChangeType.isBytes(assertion, info, valueAtStartPoint, valueAtEndPoint, true);
        if (!Values.areEqual(valueAtStartPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint());
        }
        if (!Values.areEqual(valueAtEndPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint());
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, byte[] expectedAtStartPoint, byte[] expectedAtEndPoint) {
        AssertionsOnColumnOfChangeType.isBytes(assertion, info, valueAtStartPoint, valueAtEndPoint, true);
        if (!Values.areEqual(valueAtStartPoint, expectedAtStartPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint());
        }
        if (!Values.areEqual(valueAtEndPoint, expectedAtEndPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint());
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, String expected) {
        AssertionsOnColumnOfChangeType.isOfAnyTypeIn(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.TEXT, ValueType.NUMBER, ValueType.DATE, ValueType.TIME, ValueType.DATE_TIME, ValueType.UUID, ValueType.NOT_IDENTIFIED);
        if (!Values.areEqual(valueAtStartPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expected), expected));
        }
        if (!Values.areEqual(valueAtEndPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expected), expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, String expectedAtStartPoint, String expectedAtEndPoint) {
        AssertionsOnColumnOfChangeType.isOfAnyTypeIn(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.TEXT, ValueType.NUMBER, ValueType.DATE, ValueType.TIME, ValueType.DATE_TIME, ValueType.UUID, ValueType.NOT_IDENTIFIED);
        if (!Values.areEqual(valueAtStartPoint, expectedAtStartPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expectedAtStartPoint), expectedAtStartPoint));
        }
        if (!Values.areEqual(valueAtEndPoint, expectedAtEndPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expectedAtEndPoint), expectedAtEndPoint));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, Character expected) {
        AssertionsOnColumnOfChangeType.isText(assertion, info, valueAtStartPoint, valueAtEndPoint, true);
        if (!Values.areEqual(valueAtStartPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(valueAtStartPoint.getValue(), expected));
        }
        if (!Values.areEqual(valueAtEndPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(valueAtEndPoint.getValue(), expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, Character expectedAtStartPoint, Character expectedAtEndPoint) {
        AssertionsOnColumnOfChangeType.isText(assertion, info, valueAtStartPoint, valueAtEndPoint, true);
        if (!Values.areEqual(valueAtStartPoint, expectedAtStartPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(valueAtStartPoint.getValue(), expectedAtStartPoint));
        }
        if (!Values.areEqual(valueAtEndPoint, expectedAtEndPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(valueAtEndPoint.getValue(), expectedAtEndPoint));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, DateValue expected) {
        AssertionsOnColumnOfChangeType.isOfAnyTypeIn(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.DATE, ValueType.DATE_TIME, ValueType.NOT_IDENTIFIED);
        if (!Values.areEqual(valueAtStartPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expected), expected));
        }
        if (!Values.areEqual(valueAtEndPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expected), expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, DateValue expectedAtStartPoint, DateValue expectedAtEndPoint) {
        AssertionsOnColumnOfChangeType.isOfAnyTypeIn(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.DATE, ValueType.DATE_TIME, ValueType.NOT_IDENTIFIED);
        if (!Values.areEqual(valueAtStartPoint, expectedAtStartPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expectedAtStartPoint), expectedAtStartPoint));
        }
        if (!Values.areEqual(valueAtEndPoint, expectedAtEndPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expectedAtEndPoint), expectedAtEndPoint));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, TimeValue expected) {
        AssertionsOnColumnOfChangeType.isOfAnyTypeIn(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.TIME, ValueType.NOT_IDENTIFIED);
        if (!Values.areEqual(valueAtStartPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expected), expected));
        }
        if (!Values.areEqual(valueAtEndPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expected), expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, TimeValue expectedAtStartPoint, TimeValue expectedAtEndPoint) {
        AssertionsOnColumnOfChangeType.isOfAnyTypeIn(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.TIME, ValueType.NOT_IDENTIFIED);
        if (!Values.areEqual(valueAtStartPoint, expectedAtStartPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expectedAtStartPoint), expectedAtStartPoint));
        }
        if (!Values.areEqual(valueAtEndPoint, expectedAtEndPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expectedAtEndPoint), expectedAtEndPoint));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, DateTimeValue expected) {
        AssertionsOnColumnOfChangeType.isOfAnyTypeIn(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.DATE, ValueType.DATE_TIME, ValueType.NOT_IDENTIFIED);
        if (!Values.areEqual(valueAtStartPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expected), expected));
        }
        if (!Values.areEqual(valueAtEndPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expected), expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, DateTimeValue expectedAtStartPoint, DateTimeValue expectedAtEndPoint) {
        AssertionsOnColumnOfChangeType.isOfAnyTypeIn(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.DATE, ValueType.DATE_TIME, ValueType.NOT_IDENTIFIED);
        if (!Values.areEqual(valueAtStartPoint, expectedAtStartPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expectedAtStartPoint), expectedAtStartPoint));
        }
        if (!Values.areEqual(valueAtEndPoint, expectedAtEndPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expectedAtEndPoint), expectedAtEndPoint));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, UUID expected) {
        AssertionsOnColumnOfChangeType.isOfAnyTypeIn(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.UUID, ValueType.NOT_IDENTIFIED);
        if (!Values.areEqual(valueAtStartPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expected), expected));
        }
        if (!Values.areEqual(valueAtEndPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expected), expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint, UUID expectedAtStartPoint, UUID expectedAtEndPoint) {
        AssertionsOnColumnOfChangeType.isOfAnyTypeIn(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.UUID, ValueType.NOT_IDENTIFIED);
        if (!Values.areEqual(valueAtStartPoint, expectedAtStartPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expectedAtStartPoint), expectedAtStartPoint));
        }
        if (!Values.areEqual(valueAtEndPoint, expectedAtEndPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expectedAtEndPoint), expectedAtEndPoint));
        }
        return assertion;
    }
}

