/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldBeValueClass;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.Value;

public class AssertionsOnValueClass {
    private static final Failures failures = Failures.instance();

    private AssertionsOnValueClass() {
    }

    public static <A extends AbstractAssert<?>> A isOfClass(A assertion, WritableAssertionInfo info, Value value, Class<?> classOfValue) {
        if (value.getValue() == null) {
            throw failures.failure((AssertionInfo)info, ShouldBeValueClass.shouldBeValueClass(value, classOfValue));
        }
        if (classOfValue == null) {
            throw new AssertJDBException("Class of the value is null", new Object[0]);
        }
        Class<?> testedClass = value.getValue().getClass();
        if (!classOfValue.isAssignableFrom(testedClass)) {
            throw failures.failure((AssertionInfo)info, ShouldBeValueClass.shouldBeValueClass(value, classOfValue));
        }
        return assertion;
    }
}

