/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.output;

import org.assertj.db.navigation.PositionWithPoints;
import org.assertj.db.navigation.element.ColumnElement;
import org.assertj.db.navigation.origin.OriginWithValuesFromColumn;
import org.assertj.db.output.AbstractOutputterWithOriginWithColumnsAndRowsFromChange;
import org.assertj.db.output.ChangeColumnValueOutputter;
import org.assertj.db.output.ChangeOutputter;
import org.assertj.db.output.ChangeRowOutputter;
import org.assertj.db.output.ChangesOutputter;
import org.assertj.db.output.impl.Output;
import org.assertj.db.type.Value;
import org.assertj.db.util.Descriptions;

public class ChangeColumnOutputter
extends AbstractOutputterWithOriginWithColumnsAndRowsFromChange<ChangeColumnOutputter, ChangeOutputter>
implements ColumnElement,
OriginWithValuesFromColumn<ChangesOutputter, ChangeOutputter, ChangeColumnOutputter, ChangeRowOutputter, ChangeColumnValueOutputter> {
    private final String columnName;
    private final Value valueAtStartPoint;
    private final Value valueAtEndPoint;
    private final PositionWithPoints<ChangeColumnOutputter, ChangeColumnValueOutputter, Value> valuePosition;

    public ChangeColumnOutputter(ChangeOutputter origin, String columnName, Value valueAtStartPoint, Value valueAtEndPoint) {
        super(ChangeColumnOutputter.class, origin);
        this.columnName = columnName;
        this.valueAtStartPoint = valueAtStartPoint;
        this.valueAtEndPoint = valueAtEndPoint;
        this.valuePosition = new PositionWithPoints<ChangeColumnOutputter, ChangeColumnValueOutputter, Value>(this, ChangeColumnValueOutputter.class, Value.class, valueAtStartPoint, valueAtEndPoint){

            @Override
            protected String getDescriptionAtStartPoint() {
                return Descriptions.getColumnValueAtStartPointDescription(ChangeColumnOutputter.this.info);
            }

            @Override
            protected String getDescriptionAtEndPoint() {
                return Descriptions.getColumnValueAtEndPointDescription(ChangeColumnOutputter.this.info);
            }
        };
    }

    @Override
    public ChangeColumnValueOutputter valueAtStartPoint() {
        return (ChangeColumnValueOutputter)this.valuePosition.getInstanceAtStartPoint().withType(this.outputType);
    }

    @Override
    public ChangeColumnValueOutputter valueAtEndPoint() {
        return (ChangeColumnValueOutputter)this.valuePosition.getInstanceAtEndPoint().withType(this.outputType);
    }

    public ChangeOutputter returnToChange() {
        return (ChangeOutputter)this.returnToOrigin();
    }

    @Override
    protected String getOutput(Output outputType) {
        return outputType.getChangeColumnOutput(this.info, this.columnName, this.valueAtStartPoint, this.valueAtEndPoint);
    }
}

