/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.assertj.db.type.DbElement;
import org.assertj.db.type.Source;
import org.assertj.db.type.lettercase.LetterCase;
import org.assertj.db.type.lettercase.WithLetterCase;

public abstract class AbstractDbElement<D extends AbstractDbElement<D>>
implements DbElement,
WithLetterCase {
    protected final D myself;
    private Source source;
    private DataSource dataSource;
    private LetterCase tableLetterCase;
    private LetterCase columnLetterCase;
    private LetterCase primaryKeyLetterCase;

    AbstractDbElement(Class<D> selfType) {
        this.myself = (AbstractDbElement)selfType.cast(this);
        this.setLetterCases();
    }

    AbstractDbElement(Class<D> selfType, Source source) {
        this(selfType);
        this.source = source;
    }

    AbstractDbElement(Class<D> selfType, DataSource dataSource) {
        this(selfType);
        this.dataSource = dataSource;
    }

    D setLetterCases(LetterCase tableLetterCase, LetterCase columnLetterCase, LetterCase primaryKeyLetterCase) {
        this.tableLetterCase = tableLetterCase;
        this.columnLetterCase = columnLetterCase;
        this.primaryKeyLetterCase = primaryKeyLetterCase;
        return this.myself;
    }

    private void setLetterCases() {
        if (this.dataSource instanceof WithLetterCase) {
            WithLetterCase withLetterCase = (WithLetterCase)((Object)this.dataSource);
            this.tableLetterCase = withLetterCase.getTableLetterCase();
            this.columnLetterCase = withLetterCase.getColumnLetterCase();
            this.primaryKeyLetterCase = withLetterCase.getPrimaryKeyLetterCase();
        } else if (this.source instanceof WithLetterCase) {
            WithLetterCase withLetterCase = (WithLetterCase)((Object)this.source);
            this.tableLetterCase = withLetterCase.getTableLetterCase();
            this.columnLetterCase = withLetterCase.getColumnLetterCase();
            this.primaryKeyLetterCase = withLetterCase.getPrimaryKeyLetterCase();
        } else {
            this.tableLetterCase = LetterCase.TABLE_DEFAULT;
            this.columnLetterCase = LetterCase.COLUMN_DEFAULT;
            this.primaryKeyLetterCase = LetterCase.PRIMARY_KEY_DEFAULT;
        }
    }

    @Override
    public LetterCase getColumnLetterCase() {
        return this.columnLetterCase;
    }

    @Override
    public LetterCase getPrimaryKeyLetterCase() {
        return this.primaryKeyLetterCase;
    }

    @Override
    public LetterCase getTableLetterCase() {
        return this.tableLetterCase;
    }

    public Source getSource() {
        return this.source;
    }

    public D setSource(Source source) {
        if (source == null) {
            throw new NullPointerException("source must be not null");
        }
        this.source = source;
        this.dataSource = null;
        this.setLetterCases();
        return this.myself;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public D setDataSource(DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource must be not null");
        }
        this.source = null;
        this.dataSource = dataSource;
        this.setLetterCases();
        return this.myself;
    }

    protected Connection getConnection() throws SQLException {
        if (this.dataSource == null && this.source == null) {
            throw new NullPointerException("connection or dataSource must be not null");
        }
        if (this.dataSource != null) {
            return this.dataSource.getConnection();
        }
        return DriverManager.getConnection(this.source.getUrl(), this.source.getUser(), this.source.getPassword());
    }

    protected static String getCatalog(Connection connection) throws SQLException {
        try {
            return connection.getCatalog();
        }
        catch (SQLException exception) {
            throw exception;
        }
        catch (Exception throwable) {
            return null;
        }
    }

    protected static String getSchema(Connection connection) throws SQLException {
        try {
            return connection.getSchema();
        }
        catch (SQLException exception) {
            throw exception;
        }
        catch (Exception throwable) {
            return null;
        }
    }
}

