/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.assertj.core.api.Condition;
import org.assertj.db.api.AbstractAssertWithOriginWithColumnsAndRowsFromChange;
import org.assertj.db.api.ChangeAssert;
import org.assertj.db.api.ChangeColumnAssert;
import org.assertj.db.api.ChangeRowAssert;
import org.assertj.db.api.ChangesAssert;
import org.assertj.db.api.assertions.AssertOnValueChronology;
import org.assertj.db.api.assertions.AssertOnValueClass;
import org.assertj.db.api.assertions.AssertOnValueCloseness;
import org.assertj.db.api.assertions.AssertOnValueComparison;
import org.assertj.db.api.assertions.AssertOnValueCondition;
import org.assertj.db.api.assertions.AssertOnValueEquality;
import org.assertj.db.api.assertions.AssertOnValueInequality;
import org.assertj.db.api.assertions.AssertOnValueNullity;
import org.assertj.db.api.assertions.AssertOnValueType;
import org.assertj.db.api.assertions.impl.AssertionsOnValueChronology;
import org.assertj.db.api.assertions.impl.AssertionsOnValueClass;
import org.assertj.db.api.assertions.impl.AssertionsOnValueCloseness;
import org.assertj.db.api.assertions.impl.AssertionsOnValueComparison;
import org.assertj.db.api.assertions.impl.AssertionsOnValueCondition;
import org.assertj.db.api.assertions.impl.AssertionsOnValueEquality;
import org.assertj.db.api.assertions.impl.AssertionsOnValueInequality;
import org.assertj.db.api.assertions.impl.AssertionsOnValueNullity;
import org.assertj.db.api.assertions.impl.AssertionsOnValueType;
import org.assertj.db.navigation.element.ValueElement;
import org.assertj.db.navigation.origin.OriginWithColumnsAndRowsFromChange;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.TimeValue;
import org.assertj.db.type.Value;
import org.assertj.db.type.ValueType;

public abstract class AbstractAssertWithValues<E extends AbstractAssertWithValues<E, O>, O extends OriginWithColumnsAndRowsFromChange<ChangesAssert, ChangeAssert, ChangeColumnAssert, ChangeRowAssert>>
extends AbstractAssertWithOriginWithColumnsAndRowsFromChange<E, O>
implements ValueElement,
AssertOnValueClass<E>,
AssertOnValueType<E>,
AssertOnValueNullity<E>,
AssertOnValueEquality<E>,
AssertOnValueInequality<E>,
AssertOnValueComparison<E>,
AssertOnValueChronology<E>,
AssertOnValueCloseness<E>,
AssertOnValueCondition<E> {
    protected final Value value;

    AbstractAssertWithValues(Class<E> selfType, O origin, Value value) {
        super(selfType, origin);
        this.value = value;
    }

    @Override
    public E isOfClass(Class<?> expected) {
        return (E)AssertionsOnValueClass.isOfClass((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isOfType(ValueType expected) {
        return (E)AssertionsOnValueType.isOfType((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isOfAnyTypeIn(ValueType ... expected) {
        return (E)AssertionsOnValueType.isOfAnyTypeIn((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isNumber() {
        return (E)AssertionsOnValueType.isNumber((AbstractAssertWithValues)this.myself, this.info, this.value);
    }

    @Override
    public E isBoolean() {
        return (E)AssertionsOnValueType.isBoolean((AbstractAssertWithValues)this.myself, this.info, this.value);
    }

    @Override
    public E isDate() {
        return (E)AssertionsOnValueType.isDate((AbstractAssertWithValues)this.myself, this.info, this.value);
    }

    @Override
    public E isTime() {
        return (E)AssertionsOnValueType.isTime((AbstractAssertWithValues)this.myself, this.info, this.value);
    }

    @Override
    public E isDateTime() {
        return (E)AssertionsOnValueType.isDateTime((AbstractAssertWithValues)this.myself, this.info, this.value);
    }

    @Override
    public E isBytes() {
        return (E)AssertionsOnValueType.isBytes((AbstractAssertWithValues)this.myself, this.info, this.value);
    }

    @Override
    public E isText() {
        return (E)AssertionsOnValueType.isText((AbstractAssertWithValues)this.myself, this.info, this.value);
    }

    @Override
    public E isUUID() {
        return (E)AssertionsOnValueType.isUUID((AbstractAssertWithValues)this.myself, this.info, this.value);
    }

    @Override
    public E isNull() {
        return (E)AssertionsOnValueNullity.isNull((AbstractAssertWithValues)this.myself, this.info, this.value);
    }

    @Override
    public E isNotNull() {
        return (E)AssertionsOnValueNullity.isNotNull((AbstractAssertWithValues)this.myself, this.info, this.value);
    }

    @Override
    public E isEqualTo(Object expected) {
        return (E)AssertionsOnValueEquality.isEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isEqualTo(Boolean expected) {
        return (E)AssertionsOnValueEquality.isEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isTrue() {
        return (E)AssertionsOnValueEquality.isTrue((AbstractAssertWithValues)this.myself, this.info, this.value);
    }

    @Override
    public E isFalse() {
        return (E)AssertionsOnValueEquality.isFalse((AbstractAssertWithValues)this.myself, this.info, this.value);
    }

    @Override
    public E isEqualTo(Number expected) {
        return (E)AssertionsOnValueEquality.isEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isEqualTo(byte[] expected) {
        return (E)AssertionsOnValueEquality.isEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isEqualTo(String expected) {
        return (E)AssertionsOnValueEquality.isEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isEqualTo(Character expected) {
        return (E)AssertionsOnValueEquality.isEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isEqualTo(UUID expected) {
        return (E)AssertionsOnValueEquality.isEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isEqualTo(DateValue expected) {
        return (E)AssertionsOnValueEquality.isEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isEqualTo(TimeValue expected) {
        return (E)AssertionsOnValueEquality.isEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isEqualTo(DateTimeValue expected) {
        return (E)AssertionsOnValueEquality.isEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isEqualTo(LocalDate expected) {
        return (E)this.isEqualTo(DateValue.from(expected));
    }

    @Override
    public E isEqualTo(LocalTime expected) {
        return (E)this.isEqualTo(TimeValue.from(expected));
    }

    @Override
    public E isEqualTo(LocalDateTime expected) {
        return (E)this.isEqualTo(DateTimeValue.from(expected));
    }

    @Override
    public E isNotEqualTo(Object expected) {
        return (E)AssertionsOnValueInequality.isNotEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isNotEqualTo(Boolean expected) {
        return (E)AssertionsOnValueInequality.isNotEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isNotEqualTo(byte[] expected) {
        return (E)AssertionsOnValueInequality.isNotEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isNotEqualTo(DateTimeValue expected) {
        return (E)AssertionsOnValueInequality.isNotEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isNotEqualTo(DateValue expected) {
        return (E)AssertionsOnValueInequality.isNotEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isNotEqualTo(Number expected) {
        return (E)AssertionsOnValueInequality.isNotEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isNotEqualTo(String expected) {
        return (E)AssertionsOnValueInequality.isNotEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isNotEqualTo(Character expected) {
        return (E)AssertionsOnValueInequality.isNotEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isNotEqualTo(UUID expected) {
        return (E)AssertionsOnValueInequality.isNotEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isNotEqualTo(TimeValue expected) {
        return (E)AssertionsOnValueInequality.isNotEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isNotEqualTo(LocalDate expected) {
        return (E)this.isNotEqualTo(DateValue.from(expected));
    }

    @Override
    public E isNotEqualTo(LocalTime expected) {
        return (E)this.isNotEqualTo(TimeValue.from(expected));
    }

    @Override
    public E isNotEqualTo(LocalDateTime expected) {
        return (E)this.isNotEqualTo(DateTimeValue.from(expected));
    }

    @Override
    public E isBefore(DateValue date) {
        return (E)AssertionsOnValueChronology.isBefore((AbstractAssertWithValues)this.myself, this.info, this.value, date);
    }

    @Override
    public E isBefore(TimeValue time) {
        return (E)AssertionsOnValueChronology.isBefore((AbstractAssertWithValues)this.myself, this.info, this.value, time);
    }

    @Override
    public E isBefore(DateTimeValue dateTime) {
        return (E)AssertionsOnValueChronology.isBefore((AbstractAssertWithValues)this.myself, this.info, this.value, dateTime);
    }

    @Override
    public E isBefore(LocalDate date) {
        return (E)this.isBefore(DateValue.from(date));
    }

    @Override
    public E isBefore(LocalTime time) {
        return (E)this.isBefore(TimeValue.from(time));
    }

    @Override
    public E isBefore(LocalDateTime dateTime) {
        return (E)this.isBefore(DateTimeValue.from(dateTime));
    }

    @Override
    public E isBefore(String expected) {
        return (E)AssertionsOnValueChronology.isBefore((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isBeforeOrEqualTo(DateValue date) {
        return (E)AssertionsOnValueChronology.isBeforeOrEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, date);
    }

    @Override
    public E isBeforeOrEqualTo(TimeValue time) {
        return (E)AssertionsOnValueChronology.isBeforeOrEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, time);
    }

    @Override
    public E isBeforeOrEqualTo(DateTimeValue dateTime) {
        return (E)AssertionsOnValueChronology.isBeforeOrEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, dateTime);
    }

    @Override
    public E isBeforeOrEqualTo(LocalDate date) {
        return (E)this.isBeforeOrEqualTo(DateValue.from(date));
    }

    @Override
    public E isBeforeOrEqualTo(LocalTime time) {
        return (E)this.isBeforeOrEqualTo(TimeValue.from(time));
    }

    @Override
    public E isBeforeOrEqualTo(LocalDateTime dateTime) {
        return (E)this.isBeforeOrEqualTo(DateTimeValue.from(dateTime));
    }

    @Override
    public E isBeforeOrEqualTo(String expected) {
        return (E)AssertionsOnValueChronology.isBeforeOrEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isAfter(DateValue date) {
        return (E)AssertionsOnValueChronology.isAfter((AbstractAssertWithValues)this.myself, this.info, this.value, date);
    }

    @Override
    public E isAfter(TimeValue time) {
        return (E)AssertionsOnValueChronology.isAfter((AbstractAssertWithValues)this.myself, this.info, this.value, time);
    }

    @Override
    public E isAfter(DateTimeValue dateTime) {
        return (E)AssertionsOnValueChronology.isAfter((AbstractAssertWithValues)this.myself, this.info, this.value, dateTime);
    }

    @Override
    public E isAfter(LocalDate date) {
        return (E)this.isAfter(DateValue.from(date));
    }

    @Override
    public E isAfter(LocalTime time) {
        return (E)this.isAfter(TimeValue.from(time));
    }

    @Override
    public E isAfter(LocalDateTime dateTime) {
        return (E)this.isAfter(DateTimeValue.from(dateTime));
    }

    @Override
    public E isAfter(String expected) {
        return (E)AssertionsOnValueChronology.isAfter((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isAfterOrEqualTo(DateValue date) {
        return (E)AssertionsOnValueChronology.isAfterOrEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, date);
    }

    @Override
    public E isAfterOrEqualTo(TimeValue time) {
        return (E)AssertionsOnValueChronology.isAfterOrEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, time);
    }

    @Override
    public E isAfterOrEqualTo(DateTimeValue dateTime) {
        return (E)AssertionsOnValueChronology.isAfterOrEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, dateTime);
    }

    @Override
    public E isAfterOrEqualTo(LocalDate date) {
        return (E)this.isAfterOrEqualTo(DateValue.from(date));
    }

    @Override
    public E isAfterOrEqualTo(LocalTime time) {
        return (E)this.isAfterOrEqualTo(TimeValue.from(time));
    }

    @Override
    public E isAfterOrEqualTo(LocalDateTime dateTime) {
        return (E)this.isAfterOrEqualTo(DateTimeValue.from(dateTime));
    }

    @Override
    public E isAfterOrEqualTo(String expected) {
        return (E)AssertionsOnValueChronology.isAfterOrEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isZero() {
        return (E)AssertionsOnValueEquality.isZero((AbstractAssertWithValues)this.myself, this.info, this.value);
    }

    @Override
    public E isNotZero() {
        return (E)AssertionsOnValueInequality.isNotZero((AbstractAssertWithValues)this.myself, this.info, this.value);
    }

    @Override
    public E isGreaterThan(Number expected) {
        return (E)AssertionsOnValueComparison.isGreaterThan((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isLessThan(Number expected) {
        return (E)AssertionsOnValueComparison.isLessThan((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isGreaterThanOrEqualTo(Number expected) {
        return (E)AssertionsOnValueComparison.isGreaterThanOrEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isLessThanOrEqualTo(Number expected) {
        return (E)AssertionsOnValueComparison.isLessThanOrEqualTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected);
    }

    @Override
    public E isCloseTo(Number expected, Number tolerance) {
        return (E)AssertionsOnValueCloseness.isCloseTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected, tolerance);
    }

    @Override
    public E isCloseTo(DateValue expected, DateValue tolerance) {
        return (E)AssertionsOnValueCloseness.isCloseTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected, tolerance);
    }

    @Override
    public E isCloseTo(DateValue expected, TimeValue tolerance) {
        return (E)AssertionsOnValueCloseness.isCloseTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected, tolerance);
    }

    @Override
    public E isCloseTo(DateValue expected, DateTimeValue tolerance) {
        return (E)AssertionsOnValueCloseness.isCloseTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected, tolerance);
    }

    @Override
    public E isCloseTo(TimeValue expected, TimeValue tolerance) {
        return (E)AssertionsOnValueCloseness.isCloseTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected, tolerance);
    }

    @Override
    public E isCloseTo(DateTimeValue expected, DateValue tolerance) {
        return (E)AssertionsOnValueCloseness.isCloseTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected, tolerance);
    }

    @Override
    public E isCloseTo(DateTimeValue expected, TimeValue tolerance) {
        return (E)AssertionsOnValueCloseness.isCloseTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected, tolerance);
    }

    @Override
    public E isCloseTo(DateTimeValue expected, DateTimeValue tolerance) {
        return (E)AssertionsOnValueCloseness.isCloseTo((AbstractAssertWithValues)this.myself, this.info, this.value, expected, tolerance);
    }

    @Override
    public E is(Condition<?> condition) {
        return (E)AssertionsOnValueCondition.is((AbstractAssertWithValues)this.myself, this.info, this.value, condition);
    }

    @Override
    public E isNot(Condition<?> condition) {
        return (E)AssertionsOnValueCondition.isNot((AbstractAssertWithValues)this.myself, this.info, this.value, condition);
    }

    @Override
    public E has(Condition<?> condition) {
        return (E)AssertionsOnValueCondition.is((AbstractAssertWithValues)this.myself, this.info, this.value, condition);
    }

    @Override
    public E doesNotHave(Condition<?> condition) {
        return (E)AssertionsOnValueCondition.isNot((AbstractAssertWithValues)this.myself, this.info, this.value, condition);
    }

    @Override
    public E satisfies(Condition<?> condition) {
        return (E)AssertionsOnValueCondition.satisfies((AbstractAssertWithValues)this.myself, this.info, this.value, condition);
    }
}

