/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import java.util.List;
import org.assertj.db.api.AbstractColumnAssert;
import org.assertj.db.api.AbstractColumnValueAssert;
import org.assertj.db.api.AbstractDbAssert;
import org.assertj.db.api.AbstractRowValueAssert;
import org.assertj.db.api.AbstractSubAssert;
import org.assertj.db.api.assertions.AssertOnNumberOfColumns;
import org.assertj.db.api.assertions.AssertOnRowCondition;
import org.assertj.db.api.assertions.AssertOnRowEquality;
import org.assertj.db.api.assertions.AssertOnRowNullity;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfColumns;
import org.assertj.db.api.assertions.impl.AssertionsOnRowCondition;
import org.assertj.db.api.assertions.impl.AssertionsOnRowEquality;
import org.assertj.db.api.assertions.impl.AssertionsOnValuesNullity;
import org.assertj.db.navigation.Position;
import org.assertj.db.navigation.PositionWithColumns;
import org.assertj.db.navigation.ToValueFromRow;
import org.assertj.db.navigation.element.RowElement;
import org.assertj.db.type.AbstractDbData;
import org.assertj.db.type.Row;
import org.assertj.db.type.Value;
import org.assertj.db.util.Descriptions;

public abstract class AbstractRowAssert<D extends AbstractDbData<D>, A extends AbstractDbAssert<D, A, C, CV, R, RV>, C extends AbstractColumnAssert<D, A, C, CV, R, RV>, CV extends AbstractColumnValueAssert<D, A, C, CV, R, RV>, R extends AbstractRowAssert<D, A, C, CV, R, RV>, RV extends AbstractRowValueAssert<D, A, C, CV, R, RV>>
extends AbstractSubAssert<D, A, R, RV, C, CV, R, RV>
implements RowElement,
ToValueFromRow<RV>,
AssertOnRowEquality<R>,
AssertOnNumberOfColumns<R>,
AssertOnRowNullity<R>,
AssertOnRowCondition<R> {
    protected final Row row;
    private final PositionWithColumns<R, RV, Value> valuePosition;

    AbstractRowAssert(A originalDbAssert, Class<R> selfType, Class<RV> valueType, Row row) {
        super(originalDbAssert, selfType);
        this.row = row;
        this.valuePosition = new PositionWithColumns<R, RV, Value>((AbstractRowAssert)selfType.cast(this), valueType){

            @Override
            protected String getDescription(int index) {
                return AbstractRowAssert.this.getValueDescription(index);
            }
        };
    }

    @Override
    protected String getValueDescription(int index) {
        List<String> columnsNameList = this.row.getColumnsNameList();
        String columnName = columnsNameList.get(index);
        return Descriptions.getRowValueDescription(this.info, index, columnName);
    }

    @Override
    protected Position<R, RV, Value> getValuePosition() {
        return this.valuePosition;
    }

    @Override
    protected List<Value> getValuesList() {
        return this.row.getValuesList();
    }

    @Override
    public RV value(String columnName) {
        return (RV)((AbstractRowValueAssert)this.valuePosition.getInstance(this.getValuesList(), this.row.getColumnsNameList(), columnName, this.row.getColumnLetterCase()));
    }

    @Override
    public R hasNumberOfColumns(int expected) {
        return (R)AssertionsOnNumberOfColumns.hasNumberOfColumns((AbstractRowAssert)this.myself, this.info, this.getValuesList().size(), expected);
    }

    @Override
    public R hasNumberOfColumnsGreaterThan(int expected) {
        return (R)AssertionsOnNumberOfColumns.hasNumberOfColumnsGreaterThan((AbstractRowAssert)this.myself, this.info, this.getValuesList().size(), expected);
    }

    @Override
    public R hasNumberOfColumnsLessThan(int expected) {
        return (R)AssertionsOnNumberOfColumns.hasNumberOfColumnsLessThan((AbstractRowAssert)this.myself, this.info, this.getValuesList().size(), expected);
    }

    @Override
    public R hasNumberOfColumnsGreaterThanOrEqualTo(int expected) {
        return (R)AssertionsOnNumberOfColumns.hasNumberOfColumnsGreaterThanOrEqualTo((AbstractRowAssert)this.myself, this.info, this.getValuesList().size(), expected);
    }

    @Override
    public R hasNumberOfColumnsLessThanOrEqualTo(int expected) {
        return (R)AssertionsOnNumberOfColumns.hasNumberOfColumnsLessThanOrEqualTo((AbstractRowAssert)this.myself, this.info, this.getValuesList().size(), expected);
    }

    @Override
    public R hasValues(Object ... expected) {
        return (R)AssertionsOnRowEquality.hasValues((AbstractRowAssert)this.myself, this.info, this.getValuesList(), expected);
    }

    @Override
    public R hasOnlyNotNullValues() {
        return (R)AssertionsOnValuesNullity.hasOnlyNotNullValues((AbstractRowAssert)this.myself, this.info, this.getValuesList());
    }

    @Override
    public R hasValuesSatisfying(Object ... expected) {
        return (R)AssertionsOnRowCondition.hasValuesSatisfying((AbstractRowAssert)this.myself, this.info, this.getValuesList(), expected);
    }
}

