/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.assertj.core.api.Condition;
import org.assertj.db.api.AbstractAssertWithOriginWithColumnsAndRows;
import org.assertj.db.api.AbstractColumnAssert;
import org.assertj.db.api.AbstractColumnValueAssert;
import org.assertj.db.api.AbstractDbAssert;
import org.assertj.db.api.AbstractRowAssert;
import org.assertj.db.api.AbstractRowValueAssert;
import org.assertj.db.api.AbstractSubAssert;
import org.assertj.db.api.assertions.AssertOnValueChronology;
import org.assertj.db.api.assertions.AssertOnValueClass;
import org.assertj.db.api.assertions.AssertOnValueCloseness;
import org.assertj.db.api.assertions.AssertOnValueComparison;
import org.assertj.db.api.assertions.AssertOnValueCondition;
import org.assertj.db.api.assertions.AssertOnValueEquality;
import org.assertj.db.api.assertions.AssertOnValueInequality;
import org.assertj.db.api.assertions.AssertOnValueNullity;
import org.assertj.db.api.assertions.AssertOnValueType;
import org.assertj.db.api.assertions.impl.AssertionsOnValueChronology;
import org.assertj.db.api.assertions.impl.AssertionsOnValueClass;
import org.assertj.db.api.assertions.impl.AssertionsOnValueCloseness;
import org.assertj.db.api.assertions.impl.AssertionsOnValueComparison;
import org.assertj.db.api.assertions.impl.AssertionsOnValueCondition;
import org.assertj.db.api.assertions.impl.AssertionsOnValueEquality;
import org.assertj.db.api.assertions.impl.AssertionsOnValueInequality;
import org.assertj.db.api.assertions.impl.AssertionsOnValueNullity;
import org.assertj.db.api.assertions.impl.AssertionsOnValueType;
import org.assertj.db.navigation.ToValue;
import org.assertj.db.navigation.element.ValueElement;
import org.assertj.db.type.AbstractDbData;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.TimeValue;
import org.assertj.db.type.Value;
import org.assertj.db.type.ValueType;

public abstract class AbstractValueAssert<D extends AbstractDbData<D>, A extends AbstractDbAssert<D, A, C, CV, R, RV>, S extends AbstractSubAssert<D, A, S, V, C, CV, R, RV>, V extends AbstractValueAssert<D, A, S, V, C, CV, R, RV>, C extends AbstractColumnAssert<D, A, C, CV, R, RV>, CV extends AbstractColumnValueAssert<D, A, C, CV, R, RV>, R extends AbstractRowAssert<D, A, C, CV, R, RV>, RV extends AbstractRowValueAssert<D, A, C, CV, R, RV>>
extends AbstractAssertWithOriginWithColumnsAndRows<V, S, D, A, C, CV, R, RV>
implements ValueElement,
ToValue<V>,
AssertOnValueClass<V>,
AssertOnValueType<V>,
AssertOnValueNullity<V>,
AssertOnValueEquality<V>,
AssertOnValueInequality<V>,
AssertOnValueChronology<V>,
AssertOnValueComparison<V>,
AssertOnValueCloseness<V>,
AssertOnValueCondition<V> {
    protected final Value value;

    AbstractValueAssert(Class<V> selfType, S origin, Value value) {
        super(selfType, origin);
        this.value = value;
    }

    @Override
    public V value() {
        return (V)((AbstractSubAssert)this.returnToOrigin()).value();
    }

    @Override
    public V value(int index) {
        return (V)((AbstractSubAssert)this.returnToOrigin()).value(index);
    }

    @Override
    public V isOfClass(Class<?> expected) {
        return (V)AssertionsOnValueClass.isOfClass((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isOfType(ValueType expected) {
        return (V)AssertionsOnValueType.isOfType((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isOfAnyTypeIn(ValueType ... expected) {
        return (V)AssertionsOnValueType.isOfAnyTypeIn((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isNumber() {
        return (V)AssertionsOnValueType.isNumber((AbstractValueAssert)this.myself, this.info, this.value);
    }

    @Override
    public V isBoolean() {
        return (V)AssertionsOnValueType.isBoolean((AbstractValueAssert)this.myself, this.info, this.value);
    }

    @Override
    public V isDate() {
        return (V)AssertionsOnValueType.isDate((AbstractValueAssert)this.myself, this.info, this.value);
    }

    @Override
    public V isTime() {
        return (V)AssertionsOnValueType.isTime((AbstractValueAssert)this.myself, this.info, this.value);
    }

    @Override
    public V isDateTime() {
        return (V)AssertionsOnValueType.isDateTime((AbstractValueAssert)this.myself, this.info, this.value);
    }

    @Override
    public V isBytes() {
        return (V)AssertionsOnValueType.isBytes((AbstractValueAssert)this.myself, this.info, this.value);
    }

    @Override
    public V isText() {
        return (V)AssertionsOnValueType.isText((AbstractValueAssert)this.myself, this.info, this.value);
    }

    @Override
    public V isUUID() {
        return (V)AssertionsOnValueType.isUUID((AbstractValueAssert)this.myself, this.info, this.value);
    }

    @Override
    public V isNull() {
        return (V)AssertionsOnValueNullity.isNull((AbstractValueAssert)this.myself, this.info, this.value);
    }

    @Override
    public V isNotNull() {
        return (V)AssertionsOnValueNullity.isNotNull((AbstractValueAssert)this.myself, this.info, this.value);
    }

    @Override
    public V isEqualTo(Object expected) {
        return (V)AssertionsOnValueEquality.isEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isEqualTo(Boolean expected) {
        return (V)AssertionsOnValueEquality.isEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isTrue() {
        return (V)AssertionsOnValueEquality.isTrue((AbstractValueAssert)this.myself, this.info, this.value);
    }

    @Override
    public V isFalse() {
        return (V)AssertionsOnValueEquality.isFalse((AbstractValueAssert)this.myself, this.info, this.value);
    }

    @Override
    public V isEqualTo(Number expected) {
        return (V)AssertionsOnValueEquality.isEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isEqualTo(byte[] expected) {
        return (V)AssertionsOnValueEquality.isEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isEqualTo(String expected) {
        return (V)AssertionsOnValueEquality.isEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isEqualTo(Character expected) {
        return (V)AssertionsOnValueEquality.isEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isEqualTo(UUID expected) {
        return (V)AssertionsOnValueEquality.isEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isEqualTo(DateValue expected) {
        return (V)AssertionsOnValueEquality.isEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isEqualTo(TimeValue expected) {
        return (V)AssertionsOnValueEquality.isEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isEqualTo(DateTimeValue expected) {
        return (V)AssertionsOnValueEquality.isEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isEqualTo(LocalDate expected) {
        return (V)this.isEqualTo(DateValue.from(expected));
    }

    @Override
    public V isEqualTo(LocalTime expected) {
        return (V)this.isEqualTo(TimeValue.from(expected));
    }

    @Override
    public V isEqualTo(LocalDateTime expected) {
        return (V)this.isEqualTo(DateTimeValue.from(expected));
    }

    @Override
    public V isNotEqualTo(Object expected) {
        return (V)AssertionsOnValueInequality.isNotEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isNotEqualTo(Boolean expected) {
        return (V)AssertionsOnValueInequality.isNotEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isNotEqualTo(byte[] expected) {
        return (V)AssertionsOnValueInequality.isNotEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isNotEqualTo(DateTimeValue expected) {
        return (V)AssertionsOnValueInequality.isNotEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isNotEqualTo(DateValue expected) {
        return (V)AssertionsOnValueInequality.isNotEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isNotEqualTo(Number expected) {
        return (V)AssertionsOnValueInequality.isNotEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isNotEqualTo(String expected) {
        return (V)AssertionsOnValueInequality.isNotEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isNotEqualTo(Character expected) {
        return (V)AssertionsOnValueInequality.isNotEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isNotEqualTo(UUID expected) {
        return (V)AssertionsOnValueInequality.isNotEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isNotEqualTo(TimeValue expected) {
        return (V)AssertionsOnValueInequality.isNotEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isNotEqualTo(LocalDate expected) {
        return (V)this.isNotEqualTo(DateValue.from(expected));
    }

    @Override
    public V isNotEqualTo(LocalTime expected) {
        return (V)this.isNotEqualTo(TimeValue.from(expected));
    }

    @Override
    public V isNotEqualTo(LocalDateTime expected) {
        return (V)this.isNotEqualTo(DateTimeValue.from(expected));
    }

    @Override
    public V isBefore(DateValue date) {
        return (V)AssertionsOnValueChronology.isBefore((AbstractValueAssert)this.myself, this.info, this.value, date);
    }

    @Override
    public V isBefore(TimeValue time) {
        return (V)AssertionsOnValueChronology.isBefore((AbstractValueAssert)this.myself, this.info, this.value, time);
    }

    @Override
    public V isBefore(DateTimeValue dateTime) {
        return (V)AssertionsOnValueChronology.isBefore((AbstractValueAssert)this.myself, this.info, this.value, dateTime);
    }

    @Override
    public V isBefore(LocalDate date) {
        return (V)this.isBefore(DateValue.from(date));
    }

    @Override
    public V isBefore(LocalTime time) {
        return (V)this.isBefore(TimeValue.from(time));
    }

    @Override
    public V isBefore(LocalDateTime dateTime) {
        return (V)this.isBefore(DateTimeValue.from(dateTime));
    }

    @Override
    public V isBefore(String expected) {
        return (V)AssertionsOnValueChronology.isBefore((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isBeforeOrEqualTo(DateValue date) {
        return (V)AssertionsOnValueChronology.isBeforeOrEqualTo((AbstractValueAssert)this.myself, this.info, this.value, date);
    }

    @Override
    public V isBeforeOrEqualTo(TimeValue time) {
        return (V)AssertionsOnValueChronology.isBeforeOrEqualTo((AbstractValueAssert)this.myself, this.info, this.value, time);
    }

    @Override
    public V isBeforeOrEqualTo(DateTimeValue dateTime) {
        return (V)AssertionsOnValueChronology.isBeforeOrEqualTo((AbstractValueAssert)this.myself, this.info, this.value, dateTime);
    }

    @Override
    public V isBeforeOrEqualTo(LocalDate date) {
        return (V)this.isBeforeOrEqualTo(DateValue.from(date));
    }

    @Override
    public V isBeforeOrEqualTo(LocalTime time) {
        return (V)this.isBeforeOrEqualTo(TimeValue.from(time));
    }

    @Override
    public V isBeforeOrEqualTo(LocalDateTime dateTime) {
        return (V)this.isBeforeOrEqualTo(DateTimeValue.from(dateTime));
    }

    @Override
    public V isBeforeOrEqualTo(String expected) {
        return (V)AssertionsOnValueChronology.isBeforeOrEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isAfter(DateValue date) {
        return (V)AssertionsOnValueChronology.isAfter((AbstractValueAssert)this.myself, this.info, this.value, date);
    }

    @Override
    public V isAfter(TimeValue time) {
        return (V)AssertionsOnValueChronology.isAfter((AbstractValueAssert)this.myself, this.info, this.value, time);
    }

    @Override
    public V isAfter(DateTimeValue dateTime) {
        return (V)AssertionsOnValueChronology.isAfter((AbstractValueAssert)this.myself, this.info, this.value, dateTime);
    }

    @Override
    public V isAfter(LocalDate date) {
        return (V)this.isAfter(DateValue.from(date));
    }

    @Override
    public V isAfter(LocalTime time) {
        return (V)this.isAfter(TimeValue.from(time));
    }

    @Override
    public V isAfter(LocalDateTime dateTime) {
        return (V)this.isAfter(DateTimeValue.from(dateTime));
    }

    @Override
    public V isAfter(String expected) {
        return (V)AssertionsOnValueChronology.isAfter((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isAfterOrEqualTo(DateValue date) {
        return (V)AssertionsOnValueChronology.isAfterOrEqualTo((AbstractValueAssert)this.myself, this.info, this.value, date);
    }

    @Override
    public V isAfterOrEqualTo(TimeValue time) {
        return (V)AssertionsOnValueChronology.isAfterOrEqualTo((AbstractValueAssert)this.myself, this.info, this.value, time);
    }

    @Override
    public V isAfterOrEqualTo(DateTimeValue dateTime) {
        return (V)AssertionsOnValueChronology.isAfterOrEqualTo((AbstractValueAssert)this.myself, this.info, this.value, dateTime);
    }

    @Override
    public V isAfterOrEqualTo(LocalDate date) {
        return (V)this.isAfterOrEqualTo(DateValue.from(date));
    }

    @Override
    public V isAfterOrEqualTo(LocalTime time) {
        return (V)this.isAfterOrEqualTo(TimeValue.from(time));
    }

    @Override
    public V isAfterOrEqualTo(LocalDateTime dateTime) {
        return (V)this.isAfterOrEqualTo(DateTimeValue.from(dateTime));
    }

    @Override
    public V isAfterOrEqualTo(String expected) {
        return (V)AssertionsOnValueChronology.isAfterOrEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isZero() {
        return (V)AssertionsOnValueEquality.isZero((AbstractValueAssert)this.myself, this.info, this.value);
    }

    @Override
    public V isNotZero() {
        return (V)AssertionsOnValueInequality.isNotZero((AbstractValueAssert)this.myself, this.info, this.value);
    }

    @Override
    public V isGreaterThan(Number expected) {
        return (V)AssertionsOnValueComparison.isGreaterThan((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isLessThan(Number expected) {
        return (V)AssertionsOnValueComparison.isLessThan((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isGreaterThanOrEqualTo(Number expected) {
        return (V)AssertionsOnValueComparison.isGreaterThanOrEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isLessThanOrEqualTo(Number expected) {
        return (V)AssertionsOnValueComparison.isLessThanOrEqualTo((AbstractValueAssert)this.myself, this.info, this.value, expected);
    }

    @Override
    public V isCloseTo(Number expected, Number tolerance) {
        return (V)AssertionsOnValueCloseness.isCloseTo((AbstractValueAssert)this.myself, this.info, this.value, expected, tolerance);
    }

    @Override
    public V isCloseTo(DateValue expected, DateValue tolerance) {
        return (V)AssertionsOnValueCloseness.isCloseTo((AbstractValueAssert)this.myself, this.info, this.value, expected, tolerance);
    }

    @Override
    public V isCloseTo(DateValue expected, TimeValue tolerance) {
        return (V)AssertionsOnValueCloseness.isCloseTo((AbstractValueAssert)this.myself, this.info, this.value, expected, tolerance);
    }

    @Override
    public V isCloseTo(DateValue expected, DateTimeValue tolerance) {
        return (V)AssertionsOnValueCloseness.isCloseTo((AbstractValueAssert)this.myself, this.info, this.value, expected, tolerance);
    }

    @Override
    public V isCloseTo(TimeValue expected, TimeValue tolerance) {
        return (V)AssertionsOnValueCloseness.isCloseTo((AbstractValueAssert)this.myself, this.info, this.value, expected, tolerance);
    }

    @Override
    public V isCloseTo(DateTimeValue expected, DateValue tolerance) {
        return (V)AssertionsOnValueCloseness.isCloseTo((AbstractValueAssert)this.myself, this.info, this.value, expected, tolerance);
    }

    @Override
    public V isCloseTo(DateTimeValue expected, TimeValue tolerance) {
        return (V)AssertionsOnValueCloseness.isCloseTo((AbstractValueAssert)this.myself, this.info, this.value, expected, tolerance);
    }

    @Override
    public V isCloseTo(DateTimeValue expected, DateTimeValue tolerance) {
        return (V)AssertionsOnValueCloseness.isCloseTo((AbstractValueAssert)this.myself, this.info, this.value, expected, tolerance);
    }

    @Override
    public V is(Condition<?> condition) {
        return (V)AssertionsOnValueCondition.is((AbstractValueAssert)this.myself, this.info, this.value, condition);
    }

    @Override
    public V isNot(Condition<?> condition) {
        return (V)AssertionsOnValueCondition.isNot((AbstractValueAssert)this.myself, this.info, this.value, condition);
    }

    @Override
    public V has(Condition<?> condition) {
        return (V)AssertionsOnValueCondition.is((AbstractValueAssert)this.myself, this.info, this.value, condition);
    }

    @Override
    public V doesNotHave(Condition<?> condition) {
        return (V)AssertionsOnValueCondition.isNot((AbstractValueAssert)this.myself, this.info, this.value, condition);
    }

    @Override
    public V satisfies(Condition<?> condition) {
        return (V)AssertionsOnValueCondition.satisfies((AbstractValueAssert)this.myself, this.info, this.value, condition);
    }
}

