/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.assertj.db.api.ChangesAssert;
import org.assertj.db.api.RequestAssert;
import org.assertj.db.api.TableAssert;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.Changes;
import org.assertj.db.type.Request;
import org.assertj.db.type.Table;
import org.assertj.db.util.Descriptions;

public final class Assertions {
    private Assertions() {
    }

    public static TableAssert assertThat(Table table) {
        return (TableAssert)new TableAssert(table).as(Descriptions.getDescription(table), new Object[0]);
    }

    public static RequestAssert assertThat(Request request) {
        return (RequestAssert)new RequestAssert(request).as(Descriptions.getDescription(request), new Object[0]);
    }

    public static ChangesAssert assertThat(Changes changes) {
        return (ChangesAssert)new ChangesAssert(changes).as(Descriptions.getDescription(changes), new Object[0]);
    }

    private static byte[] read(InputStream inputStream) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int byteInt = inputStream.read();
            while (byteInt != -1) {
                byteArrayOutputStream.write(byteInt);
                byteInt = inputStream.read();
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new AssertJDBException(e);
        }
    }

    public static byte[] bytesContentOf(File file) {
        byte[] byArray;
        if (file == null) {
            throw new NullPointerException("File must be not null");
        }
        FileInputStream inputStream = new FileInputStream(file);
        try {
            byArray = Assertions.read(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AssertJDBException(e);
            }
        }
        ((InputStream)inputStream).close();
        return byArray;
    }

    public static byte[] bytesContentFromClassPathOf(String resource) {
        byte[] byArray;
        block10: {
            if (resource == null) {
                throw new NullPointerException("Resource must be not null");
            }
            ClassLoader classLoader = Assertions.class.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(resource);
            try {
                if (inputStream == null) {
                    throw new AssertJDBException("Resource %s not found in the classpath", resource);
                }
                byArray = Assertions.read(inputStream);
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AssertJDBException(e);
                }
            }
            inputStream.close();
        }
        return byArray;
    }
}

