/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import org.assertj.db.api.AbstractAssertWithOriginWithChanges;
import org.assertj.db.api.ChangeColumnAssert;
import org.assertj.db.api.ChangeRowAssert;
import org.assertj.db.api.ChangesAssert;
import org.assertj.db.api.assertions.AssertOnChangeType;
import org.assertj.db.api.assertions.AssertOnDataType;
import org.assertj.db.api.assertions.AssertOnModifiedColumns;
import org.assertj.db.api.assertions.AssertOnNumberOfColumns;
import org.assertj.db.api.assertions.AssertOnPrimaryKey;
import org.assertj.db.api.assertions.impl.AssertionsOnChangeType;
import org.assertj.db.api.assertions.impl.AssertionsOnDataType;
import org.assertj.db.api.assertions.impl.AssertionsOnModifiedColumns;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfColumns;
import org.assertj.db.api.assertions.impl.AssertionsOnPrimaryKey;
import org.assertj.db.navigation.PositionWithColumnsChange;
import org.assertj.db.navigation.PositionWithPoints;
import org.assertj.db.navigation.element.ChangeElement;
import org.assertj.db.navigation.origin.OriginWithColumnsAndRowsFromChange;
import org.assertj.db.type.Change;
import org.assertj.db.type.ChangeType;
import org.assertj.db.type.DataType;
import org.assertj.db.type.Row;
import org.assertj.db.util.Descriptions;

public class ChangeAssert
extends AbstractAssertWithOriginWithChanges<ChangeAssert, ChangesAssert>
implements ChangeElement,
OriginWithColumnsAndRowsFromChange<ChangesAssert, ChangeAssert, ChangeColumnAssert, ChangeRowAssert>,
AssertOnDataType<ChangeAssert>,
AssertOnPrimaryKey<ChangeAssert>,
AssertOnChangeType<ChangeAssert>,
AssertOnModifiedColumns<ChangeAssert>,
AssertOnNumberOfColumns<ChangeAssert> {
    protected final Change change;
    private final PositionWithPoints<ChangeAssert, ChangeRowAssert, Row> rowPosition;
    private final PositionWithColumnsChange<ChangeAssert, ChangeColumnAssert> columnPosition;

    public ChangeAssert(ChangesAssert origin, Change change) {
        super(ChangeAssert.class, origin);
        this.change = change;
        this.rowPosition = new PositionWithPoints<ChangeAssert, ChangeRowAssert, Row>(this, ChangeRowAssert.class, Row.class, change.getRowAtStartPoint(), change.getRowAtEndPoint()){

            @Override
            protected String getDescriptionAtStartPoint() {
                return Descriptions.getRowAtStartPointDescription(ChangeAssert.this.info);
            }

            @Override
            protected String getDescriptionAtEndPoint() {
                return Descriptions.getRowAtEndPointDescription(ChangeAssert.this.info);
            }
        };
        this.columnPosition = new PositionWithColumnsChange<ChangeAssert, ChangeColumnAssert>(this, ChangeColumnAssert.class){

            @Override
            protected String getDescription(int index, String columnName) {
                return Descriptions.getColumnDescription(ChangeAssert.this.info, index, columnName);
            }
        };
    }

    @Override
    public ChangeRowAssert rowAtStartPoint() {
        return this.rowPosition.getInstanceAtStartPoint();
    }

    @Override
    public ChangeRowAssert rowAtEndPoint() {
        return this.rowPosition.getInstanceAtEndPoint();
    }

    @Override
    public ChangeColumnAssert column() {
        return this.columnPosition.getChangeColumnInstance(this.change);
    }

    @Override
    public ChangeColumnAssert column(int index) {
        return this.columnPosition.getChangeColumnInstance(this.change, index);
    }

    @Override
    public ChangeColumnAssert column(String columnName) {
        return this.columnPosition.getChangeColumnInstance(this.change, columnName, this.change.getColumnLetterCase());
    }

    @Override
    public ChangeColumnAssert columnAmongTheModifiedOnes() {
        return this.columnPosition.getModifiedChangeColumnInstance(this.change);
    }

    @Override
    public ChangeColumnAssert columnAmongTheModifiedOnes(int index) {
        return this.columnPosition.getModifiedChangeColumnInstance(this.change, index);
    }

    @Override
    public ChangeColumnAssert columnAmongTheModifiedOnes(String columnName) {
        return this.columnPosition.getModifiedChangeColumnInstance(this.change, columnName, this.change.getColumnLetterCase());
    }

    @Override
    public ChangeAssert isOnDataType(DataType expected) {
        return AssertionsOnDataType.isOnDataType((ChangeAssert)this.myself, this.info, this.change, expected);
    }

    @Override
    public ChangeAssert isOnTable() {
        return AssertionsOnDataType.isOnTable((ChangeAssert)this.myself, this.info, this.change);
    }

    @Override
    public ChangeAssert isOnRequest() {
        return AssertionsOnDataType.isOnRequest((ChangeAssert)this.myself, this.info, this.change);
    }

    @Override
    public ChangeAssert isOnTable(String name) {
        return AssertionsOnDataType.isOnTable((ChangeAssert)this.myself, this.info, this.change, this.change.getTableLetterCase(), name);
    }

    @Override
    public ChangeAssert hasPksNames(String ... names) {
        return AssertionsOnPrimaryKey.hasPksNames((ChangeAssert)this.myself, this.info, this.change, this.change.getPrimaryKeyLetterCase(), names);
    }

    @Override
    public ChangeAssert hasPksValues(Object ... values) {
        return AssertionsOnPrimaryKey.hasPksValues((ChangeAssert)this.myself, this.info, this.change, values);
    }

    @Override
    public ChangeAssert isOfType(ChangeType expected) {
        return AssertionsOnChangeType.isOfType((ChangeAssert)this.myself, this.info, this.change, expected);
    }

    @Override
    public ChangeAssert isCreation() {
        return AssertionsOnChangeType.isCreation((ChangeAssert)this.myself, this.info, this.change);
    }

    @Override
    public ChangeAssert isModification() {
        return AssertionsOnChangeType.isModification((ChangeAssert)this.myself, this.info, this.change);
    }

    @Override
    public ChangeAssert isDeletion() {
        return AssertionsOnChangeType.isDeletion((ChangeAssert)this.myself, this.info, this.change);
    }

    @Override
    public ChangeAssert hasNumberOfModifiedColumns(int number) {
        return AssertionsOnModifiedColumns.hasNumberOfModifiedColumns((ChangeAssert)this.myself, this.info, this.change, number);
    }

    @Override
    public ChangeAssert hasNumberOfModifiedColumnsGreaterThan(int number) {
        return AssertionsOnModifiedColumns.hasNumberOfModifiedColumnsGreaterThan((ChangeAssert)this.myself, this.info, this.change, number);
    }

    @Override
    public ChangeAssert hasNumberOfModifiedColumnsLessThan(int number) {
        return AssertionsOnModifiedColumns.hasNumberOfModifiedColumnsLessThan((ChangeAssert)this.myself, this.info, this.change, number);
    }

    @Override
    public ChangeAssert hasNumberOfModifiedColumnsGreaterThanOrEqualTo(int number) {
        return AssertionsOnModifiedColumns.hasNumberOfModifiedColumnsGreaterThanOrEqualTo((ChangeAssert)this.myself, this.info, this.change, number);
    }

    @Override
    public ChangeAssert hasNumberOfModifiedColumnsLessThanOrEqualTo(int number) {
        return AssertionsOnModifiedColumns.hasNumberOfModifiedColumnsLessThanOrEqualTo((ChangeAssert)this.myself, this.info, this.change, number);
    }

    @Override
    public ChangeAssert hasModifiedColumns(Integer ... indexes) {
        return AssertionsOnModifiedColumns.hasModifiedColumns((ChangeAssert)this.myself, this.info, this.change, indexes);
    }

    @Override
    public ChangeAssert hasModifiedColumns(String ... names) {
        return AssertionsOnModifiedColumns.hasModifiedColumns((ChangeAssert)this.myself, this.info, this.change, this.change.getColumnLetterCase(), names);
    }

    @Override
    public ChangeAssert hasNumberOfColumns(int expected) {
        return AssertionsOnNumberOfColumns.hasNumberOfColumns((ChangeAssert)this.myself, this.info, this.change.getColumnsNameList().size(), expected);
    }

    @Override
    public ChangeAssert hasNumberOfColumnsGreaterThan(int expected) {
        return AssertionsOnNumberOfColumns.hasNumberOfColumnsGreaterThan((ChangeAssert)this.myself, this.info, this.change.getColumnsNameList().size(), expected);
    }

    @Override
    public ChangeAssert hasNumberOfColumnsLessThan(int expected) {
        return AssertionsOnNumberOfColumns.hasNumberOfColumnsLessThan((ChangeAssert)this.myself, this.info, this.change.getColumnsNameList().size(), expected);
    }

    @Override
    public ChangeAssert hasNumberOfColumnsGreaterThanOrEqualTo(int expected) {
        return AssertionsOnNumberOfColumns.hasNumberOfColumnsGreaterThanOrEqualTo((ChangeAssert)this.myself, this.info, this.change.getColumnsNameList().size(), expected);
    }

    @Override
    public ChangeAssert hasNumberOfColumnsLessThanOrEqualTo(int expected) {
        return AssertionsOnNumberOfColumns.hasNumberOfColumnsLessThanOrEqualTo((ChangeAssert)this.myself, this.info, this.change.getColumnsNameList().size(), expected);
    }

    public ChangesAssert returnToChanges() {
        return (ChangesAssert)this.returnToOrigin();
    }
}

