/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldBeCompatible;
import org.assertj.db.error.ShouldBeEqual;
import org.assertj.db.error.ShouldHaveColumnsSize;
import org.assertj.db.error.ShouldSatisfy;
import org.assertj.db.type.Value;
import org.assertj.db.type.ValueType;
import org.assertj.db.util.Values;

public class AssertionsOnRowCondition {
    private static final Failures failures = Failures.instance();

    private AssertionsOnRowCondition() {
    }

    public static <A extends AbstractAssert<?>> A hasValuesSatisfying(A assertion, WritableAssertionInfo info, List<Value> valuesList, Object ... expected) {
        if (valuesList.size() != expected.length) {
            throw failures.failure((AssertionInfo)info, ShouldHaveColumnsSize.shouldHaveColumnsSize(valuesList.size(), expected.length));
        }
        int index = 0;
        for (Value value : valuesList) {
            Object object = expected[index];
            if (object instanceof Condition) {
                Condition condition = (Condition)object;
                if (!condition.matches(value.getValue())) {
                    Object actual = Values.getRepresentationFromValueInFrontOfExpected(value, object);
                    throw failures.failure((AssertionInfo)info, ShouldSatisfy.shouldSatisfy(index, actual, condition));
                }
                ++index;
                continue;
            }
            if (!value.isComparisonPossible(object)) {
                throw failures.failure((AssertionInfo)info, ShouldBeCompatible.shouldBeCompatible(value, object));
            }
            if (!Values.areEqual(value, object)) {
                if (value.getValueType() == ValueType.BYTES) {
                    throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index));
                }
                Object actual = Values.getRepresentationFromValueInFrontOfExpected(value, object);
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index, actual, object));
            }
            ++index;
        }
        return assertion;
    }
}

