/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.internal.bytebuddy.implementation.bytecode.constant;

import org.assertj.db.internal.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.assertj.db.internal.bytebuddy.implementation.Implementation;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.StackManipulation;
import org.assertj.db.internal.bytebuddy.implementation.bytecode.StackSize;
import org.assertj.db.internal.bytebuddy.jar.asm.MethodVisitor;

@HashCodeAndEqualsPlugin.Enhance
public class TextConstant
extends StackManipulation.AbstractBase {
    private final String text;

    public TextConstant(String text) {
        this.text = text;
    }

    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitLdcInsn(this.text);
        return StackSize.SINGLE.toIncreasingSize();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.text.equals(((TextConstant)object).text);
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + this.text.hashCode();
    }
}

