/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.lang.reflect.InvocationTargetException;
import org.assertj.db.type.ConnectionProvider;
import org.assertj.db.type.SchemaMetadata;
import org.assertj.db.type.lettercase.LetterCase;

abstract class AbstractConnectionProvider
implements ConnectionProvider {
    private final SchemaMetadata schemaMetadata;
    private final LetterCase tableLetterCase;
    private final LetterCase columnLetterCase;
    private final LetterCase primaryKeyLetterCase;

    protected AbstractConnectionProvider(Class<? extends SchemaMetadata> schemaMetadataType, LetterCase tableLetterCase, LetterCase columnLetterCase, LetterCase primaryKeyLetterCase) {
        this.schemaMetadata = this.instantiateSchemaMetadata(schemaMetadataType);
        this.tableLetterCase = tableLetterCase;
        this.columnLetterCase = columnLetterCase;
        this.primaryKeyLetterCase = primaryKeyLetterCase;
    }

    private SchemaMetadata instantiateSchemaMetadata(Class<? extends SchemaMetadata> schemaMetadataType) {
        try {
            return schemaMetadataType.getConstructor(ConnectionProvider.class).newInstance(this);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Schema metadata instantiation failure", e);
        }
    }

    @Override
    public LetterCase getTableLetterCase() {
        return this.tableLetterCase;
    }

    @Override
    public LetterCase getColumnLetterCase() {
        return this.columnLetterCase;
    }

    @Override
    public LetterCase getPrimaryKeyLetterCase() {
        return this.primaryKeyLetterCase;
    }

    @Override
    public SchemaMetadata getMetaData() {
        return this.schemaMetadata;
    }
}

