/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.sql.Connection;
import java.sql.SQLException;
import org.assertj.db.type.ConnectionProvider;
import org.assertj.db.type.DbElement;
import org.assertj.db.type.SchemaMetadata;
import org.assertj.db.type.lettercase.LetterCase;
import org.assertj.db.type.lettercase.WithLetterCase;

public abstract class AbstractDbElement<D extends AbstractDbElement<D>>
implements DbElement,
WithLetterCase {
    protected final D myself;
    private final ConnectionProvider connectionProvider;

    protected AbstractDbElement(Class<D> selfType, ConnectionProvider connectionProvider) {
        this.myself = (AbstractDbElement)selfType.cast(this);
        if (connectionProvider == null) {
            throw new IllegalArgumentException("connectionProvider can not be null");
        }
        this.connectionProvider = connectionProvider;
    }

    protected AbstractDbElement(Class<D> selfType) {
        this.myself = (AbstractDbElement)selfType.cast(this);
        this.connectionProvider = null;
    }

    @Override
    public LetterCase getColumnLetterCase() {
        return this.connectionProvider.getColumnLetterCase();
    }

    @Override
    public LetterCase getPrimaryKeyLetterCase() {
        return this.connectionProvider.getPrimaryKeyLetterCase();
    }

    @Override
    public LetterCase getTableLetterCase() {
        return this.connectionProvider.getTableLetterCase();
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    protected Connection getConnection() throws SQLException {
        if (this.connectionProvider == null) {
            throw new NullPointerException("connectionProvider must be not null");
        }
        return this.connectionProvider.getConnection();
    }

    protected SchemaMetadata getMetaData() {
        if (this.connectionProvider == null) {
            throw new NullPointerException("connectionProvider must be not null");
        }
        return this.connectionProvider.getMetaData();
    }
}

