/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import javax.sql.DataSource;
import org.assertj.db.type.AssertDbConnection;
import org.assertj.db.type.ConnectionProvider;
import org.assertj.db.type.DataSourceConnectionProvider;
import org.assertj.db.type.JdbcUrlConnectionProvider;
import org.assertj.db.type.SchemaMetaDataMode;
import org.assertj.db.type.lettercase.LetterCase;

public abstract class AssertDbConnectionFactory {
    private AssertDbConnectionFactory() {
        throw new UnsupportedOperationException();
    }

    public static DataSourceConnectionProviderFactory of(DataSource dataSource) {
        return new DataSourceConnectionProviderFactory(dataSource);
    }

    public static JdbcUrlConnectionProviderFactory of(String url, String user, String password) {
        return new JdbcUrlConnectionProviderFactory(url, user, password);
    }

    public static class DataSourceConnectionProviderFactory
    extends AbstractConnectionProviderFactory<DataSourceConnectionProviderFactory> {
        private final DataSource dataSource;

        private DataSourceConnectionProviderFactory(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public ConnectionProvider createConnectionProvider() {
            return new DataSourceConnectionProvider(this.dataSource, this.schemaMetaDataMode.getType(), this.tableLetterCase, this.columnLetterCase, this.primaryKeyLetterCase);
        }
    }

    public static class JdbcUrlConnectionProviderFactory
    extends AbstractConnectionProviderFactory<JdbcUrlConnectionProviderFactory> {
        private final String url;
        private final String user;
        private final String password;

        private JdbcUrlConnectionProviderFactory(String url, String user, String password) {
            this.url = url;
            this.user = user;
            this.password = password;
        }

        @Override
        public ConnectionProvider createConnectionProvider() {
            return new JdbcUrlConnectionProvider(this.url, this.user, this.password, this.schemaMetaDataMode.getType(), this.tableLetterCase, this.columnLetterCase, this.primaryKeyLetterCase);
        }
    }

    private static abstract class AbstractConnectionProviderFactory<T> {
        protected SchemaMetaDataMode schemaMetaDataMode = SchemaMetaDataMode.DYNAMIC;
        protected LetterCase tableLetterCase = LetterCase.TABLE_DEFAULT;
        protected LetterCase columnLetterCase = LetterCase.COLUMN_DEFAULT;
        protected LetterCase primaryKeyLetterCase = LetterCase.PRIMARY_KEY_DEFAULT;

        private AbstractConnectionProviderFactory() {
        }

        public T letterCase(LetterCase tableLetterCase, LetterCase columnLetterCase, LetterCase primaryKeyLetterCase) {
            this.tableLetterCase = tableLetterCase;
            this.columnLetterCase = columnLetterCase;
            this.primaryKeyLetterCase = primaryKeyLetterCase;
            return (T)this;
        }

        public T schemaMetaDataMode(SchemaMetaDataMode mode) {
            if (mode == null) {
                throw new IllegalArgumentException("SchemaMetaDataMode cannot be null");
            }
            this.schemaMetaDataMode = mode;
            return (T)this;
        }

        protected abstract ConnectionProvider createConnectionProvider();

        public AssertDbConnection create() {
            return new AssertDbConnection(this.createConnectionProvider());
        }
    }
}

