/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.assertj.db.type.ConnectionProvider;
import org.assertj.db.type.FromConnectionSchemaMetadata;
import org.assertj.db.type.SchemaMetadata;

class CachedSchemaMetaData
implements SchemaMetadata {
    private final FromConnectionSchemaMetadata metadata;
    private final Map<String, Collection<String>> cache = new ConcurrentHashMap<String, Collection<String>>();

    public CachedSchemaMetaData(ConnectionProvider connectionProvider) {
        this.metadata = new FromConnectionSchemaMetadata(connectionProvider);
    }

    @Override
    public Collection<String> getTablesName() {
        return this.cache.computeIfAbsent("TABLES", key -> this.metadata.getTablesName());
    }

    @Override
    public Collection<String> getColumnsName(String tableName) {
        return this.cache.computeIfAbsent("COLUMNS#" + tableName, key -> this.metadata.getColumnsName(tableName));
    }

    @Override
    public Collection<String> getPrimaryKeys(String tableName) {
        return this.cache.computeIfAbsent("PKS#" + tableName, key -> this.metadata.getPrimaryKeys(tableName));
    }
}

